/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.utils;

import org.apache.mina.core.buffer.IoBuffer;

public class IoBufferDecoder {
    private DecodingContext ctx = new DecodingContext();

    public IoBufferDecoder(byte[] byArray) {
        this.setDelimiter(byArray, true);
    }

    public void setContentLength(int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException("contentLength: " + n);
        }
        this.ctx.setContentLength(n);
        if (bl) {
            this.ctx.setMatchCount(0);
        }
    }

    public void setDelimiter(byte[] byArray, boolean bl) {
        if (byArray == null) {
            throw new IllegalArgumentException("Null delimiter not allowed");
        }
        IoBuffer ioBuffer = IoBuffer.allocate(byArray.length);
        ioBuffer.put(byArray);
        ioBuffer.flip();
        this.ctx.setDelimiter(ioBuffer);
        this.ctx.setContentLength(-1);
        if (bl) {
            this.ctx.setMatchCount(0);
        }
    }

    public IoBuffer decodeFully(IoBuffer ioBuffer) {
        int n = this.ctx.getContentLength();
        IoBuffer ioBuffer2 = this.ctx.getDecodedBuffer();
        int n2 = ioBuffer.limit();
        if (n > -1) {
            if (ioBuffer2 == null) {
                ioBuffer2 = IoBuffer.allocate(n).setAutoExpand(true);
            }
            if (ioBuffer.remaining() < n) {
                int n3 = ioBuffer.remaining();
                ioBuffer2.put(ioBuffer);
                this.ctx.setDecodedBuffer(ioBuffer2);
                this.ctx.setContentLength(n - n3);
                return null;
            }
            int n4 = ioBuffer.position() + n;
            ioBuffer.limit(n4);
            ioBuffer2.put(ioBuffer);
            ioBuffer2.flip();
            ioBuffer.limit(n2);
            this.ctx.reset();
            return ioBuffer2;
        }
        int n5 = ioBuffer.position();
        int n6 = this.ctx.getMatchCount();
        IoBuffer ioBuffer3 = this.ctx.getDelimiter();
        while (ioBuffer.hasRemaining()) {
            byte by = ioBuffer.get();
            if (ioBuffer3.get(n6) == by) {
                if (++n6 != ioBuffer3.limit()) continue;
                int n7 = ioBuffer.position();
                ioBuffer.position(n5);
                ioBuffer.limit(n7);
                if (ioBuffer2 == null) {
                    ioBuffer2 = IoBuffer.allocate(ioBuffer.remaining()).setAutoExpand(true);
                }
                ioBuffer2.put(ioBuffer);
                ioBuffer2.flip();
                ioBuffer.limit(n2);
                this.ctx.reset();
                return ioBuffer2;
            }
            ioBuffer.position(Math.max(0, ioBuffer.position() - n6));
            n6 = 0;
        }
        if (ioBuffer.remaining() > 0) {
            ioBuffer.position(n5);
            ioBuffer2.put(ioBuffer);
            ioBuffer.position(ioBuffer.limit());
        }
        this.ctx.setMatchCount(n6);
        this.ctx.setDecodedBuffer(ioBuffer2);
        return ioBuffer2;
    }

    public class DecodingContext {
        private IoBuffer decodedBuffer;
        private IoBuffer delimiter;
        private int matchCount = 0;
        private int contentLength = -1;

        public void reset() {
            this.contentLength = -1;
            this.matchCount = 0;
            this.decodedBuffer = null;
        }

        public int getContentLength() {
            return this.contentLength;
        }

        public void setContentLength(int n) {
            this.contentLength = n;
        }

        public int getMatchCount() {
            return this.matchCount;
        }

        public void setMatchCount(int n) {
            this.matchCount = n;
        }

        public IoBuffer getDecodedBuffer() {
            return this.decodedBuffer;
        }

        public void setDecodedBuffer(IoBuffer ioBuffer) {
            this.decodedBuffer = ioBuffer;
        }

        public IoBuffer getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(IoBuffer ioBuffer) {
            this.delimiter = ioBuffer;
        }
    }
}

