/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.utils;

import java.io.UnsupportedEncodingException;

public class ByteUtilities {
    public static byte[] intToNetworkByteOrder(int n, int n2) {
        byte[] byArray = new byte[n2];
        ByteUtilities.intToNetworkByteOrder(n, byArray, 0, n2);
        return byArray;
    }

    public static void intToNetworkByteOrder(int n, byte[] byArray, int n2, int n3) {
        if (n3 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        for (int i = n3 - 1; i >= 0; --i) {
            byArray[n2 + i] = (byte)(n & 0xFF);
            n >>>= 8;
        }
    }

    public static final byte[] writeShort(short s, byte[] byArray, int n) {
        byArray[n] = (byte)s;
        byArray[n + 1] = (byte)(s >> 8);
        return byArray;
    }

    public static final byte[] writeInt(int n) {
        return ByteUtilities.writeInt(n, new byte[4], 0);
    }

    public static final byte[] writeInt(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >> 8);
        byArray[n2 + 2] = (byte)(n >> 16);
        byArray[n2 + 3] = (byte)(n >> 24);
        return byArray;
    }

    public static final void changeWordEndianess(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; i += 4) {
            byte by = byArray[i];
            byArray[i] = byArray[i + 3];
            byArray[i + 3] = by;
            by = byArray[i + 1];
            byArray[i + 1] = byArray[i + 2];
            byArray[i + 2] = by;
        }
    }

    public static final byte[] getOEMStringAsByteArray(String string) throws UnsupportedEncodingException {
        return string.getBytes("ASCII");
    }

    public static final byte[] getUTFStringAsByteArray(String string) throws UnsupportedEncodingException {
        return string.getBytes("UTF-16LE");
    }

    public static final byte[] encodeString(String string, boolean bl) throws UnsupportedEncodingException {
        if (bl) {
            return ByteUtilities.getUTFStringAsByteArray(string);
        }
        return ByteUtilities.getOEMStringAsByteArray(string);
    }

    public static String asHex(byte[] byArray) {
        return ByteUtilities.asHex(byArray, null);
    }

    public static String asHex(byte[] byArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i] & 0xFF);
            if ((byArray[i] & 0xFF) < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
            if (string == null || i >= byArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static final int makeIntFromByte4(byte[] byArray) {
        return ByteUtilities.makeIntFromByte4(byArray, 0);
    }

    public static final int makeIntFromByte4(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static final int makeIntFromByte2(byte[] byArray) {
        return ByteUtilities.makeIntFromByte2(byArray, 0);
    }

    public static final int makeIntFromByte2(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    public static final boolean isFlagSet(int n, int n2) {
        return (n & n2) > 0;
    }
}

