/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.service;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.AbstractIoService;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.core.session.IoSessionInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIoConnector
extends AbstractIoService
implements IoConnector {
    private long connectTimeoutCheckInterval = 50L;
    private long connectTimeoutInMillis = 60000L;
    private SocketAddress defaultRemoteAddress;

    protected AbstractIoConnector(IoSessionConfig ioSessionConfig, Executor executor) {
        super(ioSessionConfig, executor);
    }

    public final long getConnectTimeoutMillis() {
        return this.connectTimeoutInMillis;
    }

    public SocketAddress getDefaultRemoteAddress() {
        return this.defaultRemoteAddress;
    }

    public final void setDefaultRemoteAddress(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new IllegalArgumentException("defaultRemoteAddress");
        }
        if (!this.getTransportMetadata().getAddressType().isAssignableFrom(socketAddress.getClass())) {
            throw new IllegalArgumentException("defaultRemoteAddress type: " + socketAddress.getClass() + " (expected: " + this.getTransportMetadata().getAddressType() + ")");
        }
        this.defaultRemoteAddress = socketAddress;
    }

    @Override
    public final ConnectFuture connect() {
        SocketAddress socketAddress = this.getDefaultRemoteAddress();
        if (socketAddress == null) {
            throw new IllegalStateException("defaultRemoteAddress is not set.");
        }
        return this.connect(socketAddress, null, null);
    }

    public ConnectFuture connect(IoSessionInitializer<? extends ConnectFuture> ioSessionInitializer) {
        SocketAddress socketAddress = this.getDefaultRemoteAddress();
        if (socketAddress == null) {
            throw new IllegalStateException("defaultRemoteAddress is not set.");
        }
        return this.connect(socketAddress, null, ioSessionInitializer);
    }

    @Override
    public ConnectFuture connect(SocketAddress socketAddress, IoSessionInitializer<? extends ConnectFuture> ioSessionInitializer) {
        return this.connect(socketAddress, null, ioSessionInitializer);
    }

    public final ConnectFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, IoSessionInitializer<? extends ConnectFuture> ioSessionInitializer) {
        if (this.isDisposing()) {
            throw new IllegalStateException("The connector has been disposed.");
        }
        if (socketAddress == null) {
            throw new IllegalArgumentException("remoteAddress");
        }
        if (!this.getTransportMetadata().getAddressType().isAssignableFrom(socketAddress.getClass())) {
            throw new IllegalArgumentException("remoteAddress type: " + socketAddress.getClass() + " (expected: " + this.getTransportMetadata().getAddressType() + ")");
        }
        if (socketAddress2 != null && !this.getTransportMetadata().getAddressType().isAssignableFrom(socketAddress2.getClass())) {
            throw new IllegalArgumentException("localAddress type: " + socketAddress2.getClass() + " (expected: " + this.getTransportMetadata().getAddressType() + ")");
        }
        if (this.getHandler() == null) {
            if (this.getSessionConfig().isUseReadOperation()) {
                this.setHandler(new IoHandler(){

                    public void exceptionCaught(IoSession ioSession, Throwable throwable) throws Exception {
                    }

                    public void messageReceived(IoSession ioSession, Object object) throws Exception {
                    }

                    public void messageSent(IoSession ioSession, Object object) throws Exception {
                    }

                    public void sessionClosed(IoSession ioSession) throws Exception {
                    }

                    public void sessionCreated(IoSession ioSession) throws Exception {
                    }

                    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) throws Exception {
                    }

                    public void sessionOpened(IoSession ioSession) throws Exception {
                    }
                });
            } else {
                throw new IllegalStateException("handler is not set.");
            }
        }
        return this.connect0(socketAddress, socketAddress2, ioSessionInitializer);
    }

    protected abstract ConnectFuture connect0(SocketAddress var1, SocketAddress var2, IoSessionInitializer<? extends ConnectFuture> var3);

    @Override
    protected final void finishSessionInitialization0(final IoSession ioSession, IoFuture ioFuture) {
        ioFuture.addListener(new IoFutureListener<ConnectFuture>(){

            @Override
            public void operationComplete(ConnectFuture connectFuture) {
                if (connectFuture.isCanceled()) {
                    ioSession.close(true);
                }
            }
        });
    }

    public String toString() {
        TransportMetadata transportMetadata = this.getTransportMetadata();
        return '(' + transportMetadata.getProviderName() + ' ' + transportMetadata.getName() + " connector: " + "managedSessionCount: " + this.getManagedSessionCount() + ')';
    }
}

