/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.panther.filechooser;

import ch.randelshofer.quaqua.BrowserPreviewRenderer;
import ch.randelshofer.quaqua.JBrowser;
import ch.randelshofer.quaqua.QuaquaLookAndFeel;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.filechooser.FileSystemTreeModel;
import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import ch.randelshofer.quaqua.osx.OSXFile;
import ch.randelshofer.quaqua.util.Worker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreePath;

public class FilePreview
extends JPanel
implements BrowserPreviewRenderer {
    private JFileChooser fileChooser;
    private static Icon placeholderIcon = new Icon(){

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return 128;
        }

        public int getIconHeight() {
            return 128;
        }
    };
    private boolean isFileIconAvailable = true;
    private JPanel emptyPreview;
    private FileInfo info;
    private JLabel kindLabel;
    private JTextArea kindText;
    private JLabel modifiedLabel;
    private JTextArea modifiedText;
    private JLabel nameLabel;
    private JTextArea nameText;
    private JPanel northPanel;
    private JLabel originalLabel;
    private JTextArea originalText;
    private JCheckBox previewCheckBox;
    private JLabel previewLabel;
    private JLabel sizeLabel;
    private JTextArea sizeText;
    private JLabel whereLabel;
    private JTextArea whereText;

    public FilePreview(JFileChooser fileChooser) {
        Component[] c;
        this.fileChooser = fileChooser;
        this.initComponents();
        Color bg = UIManager.getColor("List.background");
        Color fgl = UIManager.getColor("FileChooser.previewLabelForeground");
        Color fgv = UIManager.getColor("FileChooser.previewValueForeground");
        Font fl = UIManager.getFont("FileChooser.previewLabelFont");
        Font fv = UIManager.getFont("FileChooser.previewValueFont");
        this.emptyPreview = new JPanel();
        this.emptyPreview.setBackground(bg);
        this.emptyPreview.setOpaque(true);
        Insets labelInsets = UIManager.getInsets("FileChooser.previewLabelInsets");
        GridBagLayout layout = (GridBagLayout)this.northPanel.getLayout();
        String delimiter = UIManager.getString("FileChooser.previewLabelDelimiter");
        if (delimiter == null) {
            delimiter = "";
        }
        int n = this.northPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            c = (Component[])this.northPanel.getComponent(i);
            if (c != this.previewLabel) {
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    c.setFont(fl);
                    c.setForeground(fgl);
                    if (labelInsets != null) {
                        GridBagConstraints gbc = layout.getConstraints((Component)c);
                        gbc.insets = labelInsets;
                        layout.setConstraints((Component)c, gbc);
                    }
                    label.setText(label.getText() + delimiter);
                } else {
                    c.setFont(fv);
                    c.setForeground(fgv);
                }
            }
            c.setBackground(bg);
        }
        this.whereLabel.setVisible(false);
        this.whereText.setVisible(false);
        Insets borderMargin = new Insets(0, 0, 0, 0);
        this.kindLabel.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        this.modifiedLabel.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        this.nameLabel.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        this.originalLabel.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        this.sizeLabel.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        this.whereLabel.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        this.kindText.setFocusable(false);
        this.modifiedText.setFocusable(false);
        this.nameText.setFocusable(false);
        this.originalText.setFocusable(false);
        this.sizeText.setFocusable(false);
        this.whereText.setFocusable(false);
        this.setBackground(bg);
        this.northPanel.setBackground(bg);
        this.setOpaque(true);
        MouseAdapter mouseHandler = new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    FilePreview.this.fileChooser.approveSelection();
                }
            }
        };
        this.addMouseListener(mouseHandler);
        c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            c[i].addMouseListener(mouseHandler);
        }
        if (OSXFile.canWorkWithAliases()) {
            Preferences prefs = Preferences.userNodeForPackage(QuaquaLookAndFeel.class);
            this.previewLabel.setVisible(prefs.getBoolean("FileChooser.isPreviewExpanded", false));
            this.previewCheckBox.setSelected(prefs.getBoolean("FileChooser.isPreviewExpanded", false));
            this.previewCheckBox.setIcon(UIManager.getIcon("FileChooser.disclosureButtonIcon"));
            this.previewCheckBox.setIcon(UIManager.getIcon("FileChooser.disclosureButtonIcon"));
        } else {
            this.previewCheckBox.setVisible(false);
            this.previewLabel.setVisible(false);
        }
    }

    private void initComponents() {
        this.northPanel = new JPanel();
        this.previewCheckBox = new JCheckBox();
        this.previewLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.nameText = new JTextArea();
        this.kindLabel = new JLabel();
        this.kindText = new JTextArea();
        this.sizeLabel = new JLabel();
        this.sizeText = new JTextArea();
        this.modifiedLabel = new JLabel();
        this.modifiedText = new JTextArea();
        this.whereLabel = new JLabel();
        this.whereText = new JTextArea();
        this.originalLabel = new JLabel();
        this.originalText = new JTextArea();
        this.setBorder(BorderFactory.createEmptyBorder(3, 4, 4, 4));
        this.setLayout(new BorderLayout());
        this.northPanel.setLayout(new GridBagLayout());
        this.previewCheckBox.setText(UIManager.getString("Filechooser.previewButton.text"));
        this.previewCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilePreview.this.previewButtonPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.northPanel.add((Component)this.previewCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.northPanel.add((Component)this.previewLabel, gridBagConstraints);
        this.nameLabel.setText(UIManager.getString("FileChooser.name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        this.northPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameText.setEditable(false);
        this.nameText.setLineWrap(true);
        this.nameText.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.nameText, gridBagConstraints);
        this.kindLabel.setText(UIManager.getString("FileChooser.kind"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        this.northPanel.add((Component)this.kindLabel, gridBagConstraints);
        this.kindText.setEditable(false);
        this.kindText.setLineWrap(true);
        this.kindText.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.kindText, gridBagConstraints);
        this.sizeLabel.setText(UIManager.getString("FileChooser.size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        this.northPanel.add((Component)this.sizeLabel, gridBagConstraints);
        this.sizeText.setEditable(false);
        this.sizeText.setLineWrap(true);
        this.sizeText.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.sizeText, gridBagConstraints);
        this.modifiedLabel.setText(UIManager.getString("FileChooser.modified"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        this.northPanel.add((Component)this.modifiedLabel, gridBagConstraints);
        this.modifiedText.setEditable(false);
        this.modifiedText.setLineWrap(true);
        this.modifiedText.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.modifiedText, gridBagConstraints);
        this.whereLabel.setText(UIManager.getString("FileChooser.whereLabelText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 12;
        this.northPanel.add((Component)this.whereLabel, gridBagConstraints);
        this.whereText.setEditable(false);
        this.whereText.setLineWrap(true);
        this.whereText.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.whereText, gridBagConstraints);
        this.originalLabel.setText(UIManager.getString("FileChooser.original"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 12;
        this.northPanel.add((Component)this.originalLabel, gridBagConstraints);
        this.originalText.setEditable(false);
        this.originalText.setLineWrap(true);
        this.originalText.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.originalText, gridBagConstraints);
        this.add((Component)this.northPanel, "North");
    }

    private void previewButtonPerformed(ActionEvent evt) {
        boolean b = this.previewCheckBox.isSelected();
        Preferences prefs = Preferences.userNodeForPackage(QuaquaLookAndFeel.class);
        prefs.putBoolean("FileChooser.isPreviewExpanded", b);
        this.updatePreviewIcon();
    }

    private String toOSXPath(File file) {
        StringBuffer buf = new StringBuffer();
        QuaquaFileSystemView fsv = QuaquaFileSystemView.getQuaquaFileSystemView();
        if (file != null && file.isDirectory()) {
            buf.append(':');
        }
        while (file != null) {
            buf.insert(0, this.fileChooser.getName(file));
            if ((file = ((FileSystemView)fsv).getParentDirectory(file)) == null) continue;
            buf.insert(0, ':');
        }
        return buf.toString();
    }

    public Component getPreviewRendererComponent(JBrowser browser, TreePath[] paths) {
        float scaledLength;
        String label;
        Locale locale = Locale.getDefault();
        NumberFormat nf = NumberFormat.getInstance(locale);
        nf.setMaximumFractionDigits(1);
        this.info = (FileInfo)paths[0].getLastPathComponent();
        if (!this.info.isAcceptable()) {
            return this.emptyPreview;
        }
        long fileLength = 0L;
        if (paths.length == 1) {
            this.nameLabel.setVisible(true);
            this.modifiedLabel.setVisible(true);
            this.modifiedText.setVisible(true);
            this.nameText.setText(this.info.getUserName());
            File file = this.info.getFile();
            fileLength = this.info.getFileLength();
            if (file != null) {
                this.modifiedText.setText(DateFormat.getInstance().format(new Date(file.lastModified())));
            } else {
                this.modifiedText.setText(UIManager.getString("FileChooser.modifiedUnknown"));
            }
            String kind = this.info.getFileKind();
            this.kindText.setText(OSXFile.getKindString(file));
            if (kind == "alias") {
                this.originalText.setText(this.toOSXPath(this.info.lazyGetResolvedFile()));
                this.originalLabel.setVisible(true);
                this.originalText.setVisible(true);
            } else {
                this.originalLabel.setVisible(false);
                this.originalText.setVisible(false);
            }
        } else {
            this.nameLabel.setVisible(false);
            this.modifiedLabel.setVisible(false);
            this.modifiedText.setVisible(false);
            this.nameText.setText(MessageFormat.format(UIManager.getString("FileChooser.items"), nf.format(paths.length)));
            TreeMap<String, Integer> kinds = new TreeMap<String, Integer>();
            for (int i = 0; i < paths.length; ++i) {
                Integer kindCount;
                String kind;
                this.info = (FileSystemTreeModel.Node)paths[i].getLastPathComponent();
                if (fileLength != -1L) {
                    fileLength = this.info.getFileLength() == -1L ? -1L : (fileLength += this.info.getFileLength());
                }
                kinds.put(kind, (kindCount = (Integer)kinds.get(kind = this.info.getFileKind())) == null ? new Integer(1) : new Integer(kindCount + 1));
            }
            StringBuffer buf = new StringBuffer();
            Iterator i = kinds.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                buf.append(MessageFormat.format(UIManager.getString("FileChooser." + entry.getKey() + "Count"), entry.getValue()));
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
            this.kindText.setText(buf.toString());
            this.originalLabel.setVisible(false);
            this.originalText.setVisible(false);
        }
        if (fileLength == -1L) {
            label = "FileChooser.sizeUnknown";
            scaledLength = 0.0f;
        } else if (fileLength >= 0x40000000L) {
            label = "FileChooser.sizeGBytes";
            scaledLength = (float)fileLength / 1.0737418E9f;
        } else if (fileLength >= 0x100000L) {
            label = "FileChooser.sizeMBytes";
            scaledLength = (float)fileLength / 1048576.0f;
        } else if (fileLength >= 1024L) {
            label = "FileChooser.sizeKBytes";
            scaledLength = (float)fileLength / 1024.0f;
        } else {
            label = "FileChooser.sizeBytes";
            scaledLength = fileLength;
        }
        this.sizeText.setText(MessageFormat.format(UIManager.getString(label), new Float(scaledLength), new Long(fileLength), new Integer(paths.length)));
        this.updatePreviewIcon();
        return this;
    }

    private void updatePreviewIcon() {
        File file;
        this.previewLabel.setVisible(this.isFileIconAvailable && this.previewCheckBox.isSelected());
        this.previewLabel.setIcon(placeholderIcon);
        if (this.info != null && this.previewCheckBox.isSelected() && (file = this.info.lazyGetResolvedFile()) != null) {
            new Worker<Image>(){

                @Override
                public Image construct() {
                    BufferedImage o = null;
                    if (System.getProperty("os.version").compareTo("10.6") >= 0) {
                        o = OSXFile.getQuickLookThumbnailImage(file, 128);
                    }
                    if (o == null) {
                        return OSXFile.getIconImage(file, 128);
                    }
                    return o;
                }

                @Override
                public void done(Image value) {
                    Image fileIconImage = value;
                    FilePreview.this.isFileIconAvailable = fileIconImage != null;
                    if (FilePreview.this.isFileIconAvailable) {
                        FilePreview.this.previewLabel.setIcon(new ImageIcon(fileIconImage));
                    } else {
                        FilePreview.this.previewLabel.setVisible(false);
                    }
                    FilePreview.this.previewLabel.getParent().validate();
                }
            }.start();
        }
    }
}

