/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.utils;

import cz.vity.freerapid.utilities.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.BCodec;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

public final class HttpUtils {
    private static final Logger logger = Logger.getLogger(HttpUtils.class.getName());

    private HttpUtils() {
    }

    public static String getFileName(HttpMethod httpMethod) {
        Header header = httpMethod.getResponseHeader("Content-Disposition");
        if (header != null) {
            String string;
            String string2 = header.getValue();
            String string3 = string2.toLowerCase(Locale.ENGLISH);
            if (!string3.contains("attachment") && !string3.contains("inline")) {
                return null;
            }
            String string4 = "filename==?";
            int n = string3.indexOf(string4);
            if (n >= 0 && !(string = string2.substring(n + string4.length() - 2)).isEmpty()) {
                try {
                    return new BCodec().decode(string);
                }
                catch (DecoderException decoderException) {
                    logger.warning("BCodec - Unsupported encoding or decoder failed");
                }
            }
            string4 = "filename=";
            string = string2.toLowerCase();
            n = string.lastIndexOf(string4);
            if (n >= 0) {
                String string5 = string2.substring(n + string4.length());
                int n2 = string5.lastIndexOf(34);
                if (string5.startsWith("\"") && n2 > 0) {
                    string5 = string5.substring(1, n2);
                }
                if (string5.matches(".*%[0-9A-Fa-f]+.*")) {
                    try {
                        string5 = URLDecoder.decode(string5, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        logger.warning("Unsupported encoding");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logger.warning("Invalid file name header: " + illegalArgumentException.getMessage());
                        return string5;
                    }
                }
                return string5;
            }
            string4 = "filename\\*=utf-8''";
            n = string.lastIndexOf(string4);
            if (n == -1) {
                string4 = "filename*=utf-8''";
                n = string.lastIndexOf(string4);
            }
            if (n >= 0) {
                String string6 = string2.substring(n + string4.length());
                if (!string6.isEmpty()) {
                    try {
                        return URLDecoder.decode(string6, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        logger.warning("Unsupported encoding");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logger.warning("Invalid file name header: " + illegalArgumentException.getMessage());
                        return string6;
                    }
                }
            } else {
                logger.warning("File name was not found in " + string2);
            }
        }
        return null;
    }

    public static String replaceInvalidCharsForFileSystem(String string, String string2) {
        if (Utils.isWindows()) {
            String string3 = string.replaceAll("(\\\\|\\||:|\\*|\\?|<|>|\\uFFFD|/|\")", string2);
            if (string3.startsWith(".")) {
                string3 = string3.substring(1);
            }
            return string3;
        }
        return string.replaceAll("/|\\uFFFD", string2);
    }
}

