/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.filechooser;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.dialogs.filechooser.EnhancedFileFilter;
import cz.vity.freerapid.swing.Swinger;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.jdesktop.appframework.swingx.SingleXFrameApplication;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

abstract class JAppFileChooser
extends JFileChooser {
    public JAppFileChooser(File file) {
        super(file);
        this.setName(this.getDialogName());
        Swinger.getResourceMap(JAppFileChooser.class).injectComponents((Component)this);
    }

    @Override
    public int showSaveDialog(Component component) throws HeadlessException {
        return super.showSaveDialog(component);
    }

    @Override
    protected JDialog createDialog(Component component) throws HeadlessException {
        JDialog jDialog = super.createDialog(component);
        Application application = Application.getInstance(Application.class);
        ApplicationContext applicationContext = application.getContext();
        if (applicationContext.getApplication() instanceof SingleXFrameApplication) {
            jDialog.setName(this.getDialogName());
            ((SingleXFrameApplication)applicationContext.getApplication()).prepareDialog(jDialog, false);
        }
        return jDialog;
    }

    public void setFileName(String string) {
        FileChooserUI fileChooserUI = this.getUI();
        if (fileChooserUI instanceof BasicFileChooserUI) {
            ((BasicFileChooserUI)fileChooserUI).setFileName(string);
        }
    }

    protected abstract String getDialogName();

    public void updateFileFilters(List<EnhancedFileFilter> list, String string) {
        for (EnhancedFileFilter enhancedFileFilter : list) {
            this.addChoosableFileFilter(enhancedFileFilter);
        }
        int n = AppPrefs.getProperty(string, list.size() - 1);
        if (n >= 0 && n < list.size()) {
            this.setFileFilter(list.get(n));
        }
    }
}

