/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.dialogs.abouteffect.VolleyExplosion;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.application.Action;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelineScenario;
import org.pushingpixels.trident.callback.TimelineScenarioCallback;
import org.pushingpixels.trident.swing.SwingRepaintTimeline;

public class AboutDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(AboutDialog.class.getName());
    private JLabel xImagePanel;
    private JLabel infoLabel;
    private AudioClip audioClip;
    private final Set<VolleyExplosion> volleys;
    private final Map<VolleyExplosion, TimelineScenario> volleyScenarios;
    private JButton btnOK;

    public AboutDialog(Frame frame) throws HeadlessException {
        super(frame, true);
        this.setName("AboutDialog");
        this.volleys = new HashSet<VolleyExplosion>();
        this.volleyScenarios = new HashMap<VolleyExplosion, TimelineScenario>();
        try {
            this.initComponents();
            this.build();
            String string = this.getTitle();
            string = string + ' ' + "0.85u1";
            String string2 = this.readBuildNumber();
            if (string2 != null) {
                string = string + "  build #" + string2;
            }
            this.setTitle(string);
            SwingRepaintTimeline swingRepaintTimeline = new SwingRepaintTimeline((Component)this);
            swingRepaintTimeline.playLoop(Timeline.RepeatBehavior.LOOP);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnOK;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnOK;
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.setAction(this.btnOK, "okBtnAction");
        this.pack();
        this.setResizable(false);
        AboutDialog.locateOnOpticalScreenCenter(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (AboutDialog.this.getWidth() == 0 || AboutDialog.this.getHeight() == 0) {
                    return;
                }
                new Thread(){

                    @Override
                    public void run() {
                        for (int i = 10; i >= 0; --i) {
                            AboutDialog.this.addExplosions(5);
                        }
                    }
                }.start();
            }
        });
    }

    private String readBuildNumber() {
        try {
            String string = AboutDialog.class.getProtectionDomain().getCodeSource().getLocation().toString();
            URL uRL = new URL("jar:" + string + "!/META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(uRL.openStream());
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue("Build");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            return null;
        }
    }

    private void buildGUI() {
        Icon icon = Swinger.getResourceMap().getIcon("splash.iconImage");
        this.xImagePanel.setIcon(icon);
        Dimension dimension = new Dimension(icon.getIconWidth() + 2, icon.getIconHeight() + 2);
        this.xImagePanel.setPreferredSize(dimension);
        this.xImagePanel.setBorder(BorderFactory.createEtchedBorder());
        this.xImagePanel.setLayout(new BoxLayout(this.xImagePanel, 1));
        this.xImagePanel.add(this.infoLabel);
        this.xImagePanel.setCursor(Cursor.getPredefinedCursor(12));
        this.xImagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Browser.showHomepage();
            }
        });
        this.infoLabel.setBorder(BorderFactory.createEmptyBorder(15, 20, 20, 30));
        this.infoLabel.setLocation(30, 30);
    }

    @Override
    protected void windowIsClosing() {
        this.stopSound();
    }

    private void stopSound() {
        if (this.audioClip != null) {
            this.audioClip.stop();
            this.audioClip = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExplosions(int n) {
        final CountDownLatch countDownLatch = new CountDownLatch(n);
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(255.0 * Math.random());
            int n3 = (int)(100.0 + 155.0 * Math.random());
            int n4 = (int)(50.0 + 205.0 * Math.random());
            Color color = new Color(n2, n3, n4);
            int n5 = 60 + (int)((double)(this.xImagePanel.getWidth() - 120) * Math.random());
            int n6 = 60 + (int)((double)(this.xImagePanel.getHeight() - 120) * Math.random());
            final VolleyExplosion volleyExplosion = new VolleyExplosion(n5, n6, color);
            Set<VolleyExplosion> set = this.volleys;
            synchronized (set) {
                this.volleys.add(volleyExplosion);
                TimelineScenario timelineScenario = volleyExplosion.getExplosionScenario();
                timelineScenario.addCallback(new TimelineScenarioCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onTimelineScenarioDone() {
                        Set set = AboutDialog.this.volleys;
                        synchronized (set) {
                            AboutDialog.this.volleys.remove(volleyExplosion);
                            AboutDialog.this.volleyScenarios.remove(volleyExplosion);
                            countDownLatch.countDown();
                        }
                    }
                });
                this.volleyScenarios.put(volleyExplosion, timelineScenario);
                timelineScenario.play();
                continue;
            }
        }
        try {
            countDownLatch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Action
    public void okBtnAction() {
        this.stopSound();
        this.doClose();
    }

    private void initComponents() {
        this.infoLabel = new JLabel();
        this.infoLabel.setName("infoLabel");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.xImagePanel = new JLabel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Set set = AboutDialog.this.volleys;
                synchronized (set) {
                    for (VolleyExplosion volleyExplosion : AboutDialog.this.volleys) {
                        volleyExplosion.paint(graphics);
                    }
                }
            }
        };
        JPanel jPanel3 = new JPanel();
        this.btnOK = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        this.setName("AboutDialog");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        jPanel.setBorder(Borders.DIALOG_BORDER);
        jPanel.setName("dialogPane");
        jPanel.setLayout(new BorderLayout());
        jPanel2.setName("contentPanel");
        this.xImagePanel.setName("xImagePanel");
        jPanel2.add((Component)this.xImagePanel, "Center");
        jPanel2.add(this.infoLabel);
        jPanel.add((Component)jPanel2, "Center");
        jPanel3.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        jPanel3.setName("buttonBar");
        this.btnOK.setName("btnOK");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("default:grow, max(pref;42dlu), default:grow", "pref"), jPanel3);
        panelBuilder.add((Component)this.btnOK, cellConstraints.xy(2, 1));
        jPanel.add((Component)jPanel3, "South");
        container.add((Component)jPanel, "Center");
    }
}

