/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.Swinger;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

final class SpeedCellRenderer
extends DefaultTableCellRenderer {
    private ImageIcon iconImage;
    private ResourceMap map;

    SpeedCellRenderer(ApplicationContext applicationContext) {
        this.map = applicationContext.getResourceMap();
        this.iconImage = Swinger.getIconImage("speedLimitImage");
    }

    @Override
    public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            object = jTable.getValueAt(n, n2);
        }
        DownloadFile downloadFile = (DownloadFile)object;
        this.setIcon(null);
        String string = null;
        if (downloadFile.getState() == DownloadState.DOWNLOADING) {
            if (downloadFile.getSpeed() >= 0L) {
                object = ContentPanel.bytesToAnother(downloadFile.getSpeed()) + "/s";
                if (downloadFile.hasSpeedLimit()) {
                    this.setIcon(this.iconImage);
                    string = this.map.getString("speedLimitIsEnabled", new Object[]{ContentPanel.bytesToAnother((long)downloadFile.getSpeedLimit() * 1024L)});
                }
            } else {
                object = "0 B/s";
            }
        } else {
            object = "";
        }
        this.setToolTipText(string);
        this.getAccessibleContext().setAccessibleName(jTable.getColumnName(n2) + " " + object.toString());
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }
}

