/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

final class ConnectionCellRenderer
extends DefaultTableCellRenderer {
    private final String defaultConnection;
    private static final Logger logger = Logger.getLogger(ConnectionCellRenderer.class.getName());

    ConnectionCellRenderer(ApplicationContext applicationContext) {
        ResourceMap resourceMap = applicationContext.getResourceMap();
        this.defaultConnection = resourceMap.getString("defaultConnection", new Object[0]);
    }

    @Override
    public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        HttpDownloadClient httpDownloadClient;
        if (object == null) {
            object = jTable.getValueAt(n, n2);
        }
        DownloadFile downloadFile = (DownloadFile)object;
        DownloadTask downloadTask = downloadFile.getTask();
        ConnectionSettings connectionSettings = null;
        if (downloadFile.getState() == DownloadState.SLEEPING || downloadFile.getState() == DownloadState.ERROR) {
            connectionSettings = downloadFile.getConnectionSettings();
        }
        if (connectionSettings == null && downloadTask != null && (httpDownloadClient = downloadTask.getClient()) != null) {
            connectionSettings = httpDownloadClient.getSettings();
        }
        if (connectionSettings != null) {
            if (connectionSettings.isProxySet()) {
                object = String.format("%s:%s", connectionSettings.getProxyURL(), connectionSettings.getProxyPort());
                if (connectionSettings.getUserName() != null) {
                    object = connectionSettings.getUserName() + "@" + object;
                }
            } else {
                object = this.defaultConnection;
            }
        } else {
            object = "";
        }
        this.getAccessibleContext().setAccessibleDescription(jTable.getColumnName(n2) + " " + object.toString());
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }
}

