/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.DownloadHistoryDialog;
import cz.vity.freerapid.gui.dialogs.SpeedMeterDialog;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Action;

public class ViewActions
extends AbstractBean {
    private final MainApp app = (MainApp)MainApp.getInstance(MainApp.class);

    public ViewActions() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if ("autoshutdown".equals(preferenceChangeEvent.getKey())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ViewActions.this.updateSelectedAction();
                        }
                    });
                }
            }
        });
    }

    private void updateSelectedAction() {
        String string = this.app.getManagerDirector().getMenuManager().getSelectedShutDownAction();
        this.app.getContext().getActionMap().get((Object)string).putValue("SwingSelectedKey", Boolean.TRUE);
    }

    @Action
    public void showStatusBar() {
        AppPrefs.negateProperty("showStatusbar", true);
    }

    @Action
    public void showToolbar() {
        AppPrefs.negateProperty("showToolbar", true);
    }

    @Action
    public void showDownloadHistoryAction() {
        ManagerDirector managerDirector = this.app.getManagerDirector();
        DownloadHistoryDialog downloadHistoryDialog = new DownloadHistoryDialog(this.app.getMainFrame(), managerDirector);
        this.app.show(downloadHistoryDialog);
    }

    @Action
    public void showSpeedMonitor() {
        ManagerDirector managerDirector = this.app.getManagerDirector();
        SpeedMeterDialog speedMeterDialog = new SpeedMeterDialog(this.app.getMainFrame(), managerDirector);
        this.app.show(speedMeterDialog);
    }

    @Action
    public void showCompletedAction() {
        AppPrefs.negateProperty("removeCompleted", true);
        ManagerDirector managerDirector = this.app.getManagerDirector();
        ContentPanel contentPanel = managerDirector.getContentManager().getContentPanel();
        contentPanel.updateFilters();
    }
}

