/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class RadioButtonMenuItemIcon
implements Icon,
UIResource {
    private int size;
    private JMenuItem menuItem;
    private static LazyResettableHashMap<Icon> iconMap = new LazyResettableHashMap("RadioButtonMenuItemIcon");

    public RadioButtonMenuItemIcon(JMenuItem jMenuItem, int n) {
        this.menuItem = jMenuItem;
        this.size = n;
    }

    private Icon getIconToPaint() {
        if (this.menuItem == null) {
            return null;
        }
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)this.menuItem.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        int n = SubstanceSizeUtils.getComponentFontSize(this.menuItem);
        int n2 = this.size;
        SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(this.menuItem);
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(this.menuItem);
        ComponentState componentState = modelStateInfo.getCurrModelState();
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, ColorSchemeAssociationKind.FILL, componentState);
        SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, ColorSchemeAssociationKind.MARK, componentState);
        SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, ColorSchemeAssociationKind.BORDER, componentState);
        float f = stateTransitionTracker.getFacetStrength(ComponentStateFacet.SELECTION);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), substanceColorScheme3.getDisplayName(), Float.valueOf(f));
        Icon icon = iconMap.get(hashMapKey);
        if (icon == null) {
            icon = new ImageIcon(SubstanceImageCreator.getRadioButton(this.menuItem, substanceFillPainter, substanceBorderPainter, n2, componentState, 0, substanceColorScheme, substanceColorScheme2, substanceColorScheme3, f));
            iconMap.put(hashMapKey, icon);
        }
        if (componentState.isDisabled() || map.size() == 1) {
            return icon;
        }
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(icon.getIconWidth(), icon.getIconHeight());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(this.menuItem, graphics2D, 0, 0);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
            float f2;
            ComponentState componentState2 = entry.getKey();
            if (componentState2 == componentState || !((f2 = entry.getValue().getContribution()) > 0.0f)) continue;
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(f2));
            SubstanceColorScheme substanceColorScheme4 = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, ColorSchemeAssociationKind.FILL, componentState2);
            SubstanceColorScheme substanceColorScheme5 = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, ColorSchemeAssociationKind.MARK, componentState2);
            SubstanceColorScheme substanceColorScheme6 = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, ColorSchemeAssociationKind.BORDER, componentState2);
            HashMapKey hashMapKey2 = SubstanceCoreUtilities.getHashKey(n, n2, substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), substanceColorScheme4.getDisplayName(), substanceColorScheme5.getDisplayName(), substanceColorScheme6.getDisplayName(), Float.valueOf(f));
            Icon icon2 = iconMap.get(hashMapKey2);
            if (icon2 == null) {
                icon2 = new ImageIcon(SubstanceImageCreator.getRadioButton(this.menuItem, substanceFillPainter, substanceBorderPainter, n2, componentState, 0, substanceColorScheme4, substanceColorScheme5, substanceColorScheme6, f));
                iconMap.put(hashMapKey2, icon2);
            }
            icon2.paintIcon(this.menuItem, graphics2D, 0, 0);
        }
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Icon icon = this.getIconToPaint();
        if (icon != null) {
            icon.paintIcon(component, graphics, n, n2);
        }
    }

    @Override
    public int getIconWidth() {
        return this.size + 2;
    }

    @Override
    public int getIconHeight() {
        return this.size + 2;
    }
}

