/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JTabbedPane;
import org.pushingpixels.substance.api.tabbed.BaseTabCloseListener;

public class TabCloseListenerManager {
    private Set<BaseTabCloseListener> generalListeners = new HashSet<BaseTabCloseListener>();
    private Map<JTabbedPane, Set<BaseTabCloseListener>> specificListeners = new HashMap<JTabbedPane, Set<BaseTabCloseListener>>();
    private static TabCloseListenerManager instance = new TabCloseListenerManager();

    public static TabCloseListenerManager getInstance() {
        return instance;
    }

    public synchronized void unregisterTabbedPane(JTabbedPane jTabbedPane) {
        this.specificListeners.remove(jTabbedPane);
    }

    public synchronized void registerListener(BaseTabCloseListener baseTabCloseListener) {
        this.generalListeners.add(baseTabCloseListener);
    }

    public synchronized void unregisterListener(BaseTabCloseListener baseTabCloseListener) {
        this.generalListeners.remove(baseTabCloseListener);
    }

    public synchronized Set<BaseTabCloseListener> getListeners() {
        return Collections.unmodifiableSet(this.generalListeners);
    }

    public synchronized void registerListener(JTabbedPane jTabbedPane, BaseTabCloseListener baseTabCloseListener) {
        if (jTabbedPane == null) {
            this.registerListener(baseTabCloseListener);
        } else {
            Set<BaseTabCloseListener> set = this.specificListeners.get(jTabbedPane);
            if (set == null) {
                set = new HashSet<BaseTabCloseListener>();
                this.specificListeners.put(jTabbedPane, set);
            }
            set.add(baseTabCloseListener);
        }
    }

    public synchronized void unregisterListener(JTabbedPane jTabbedPane, BaseTabCloseListener baseTabCloseListener) {
        if (jTabbedPane == null) {
            this.unregisterListener(baseTabCloseListener);
        } else {
            Set<BaseTabCloseListener> set = this.specificListeners.get(jTabbedPane);
            if (set != null) {
                set.remove(baseTabCloseListener);
            }
        }
    }

    public synchronized Set<BaseTabCloseListener> getListeners(JTabbedPane jTabbedPane) {
        if (jTabbedPane == null) {
            return this.getListeners();
        }
        HashSet<BaseTabCloseListener> hashSet = new HashSet<BaseTabCloseListener>();
        for (BaseTabCloseListener object : this.generalListeners) {
            hashSet.add(object);
        }
        Set<BaseTabCloseListener> set = this.specificListeners.get(jTabbedPane);
        if (set != null) {
            for (BaseTabCloseListener baseTabCloseListener : set) {
                hashSet.add(baseTabCloseListener);
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

