/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ButtonModel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;

public class RolloverControlListener
implements MouseListener,
MouseMotionListener {
    private boolean isMouseInside;
    private ButtonModel model;
    private TransitionAwareUI trackableUI;
    private StateTransitionTracker stateTransitionTracker;

    public RolloverControlListener(TransitionAwareUI transitionAwareUI, ButtonModel buttonModel) {
        this.trackableUI = transitionAwareUI;
        this.model = buttonModel;
        this.isMouseInside = false;
        this.stateTransitionTracker = transitionAwareUI.getTransitionTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean bl;
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            this.isMouseInside = bl = this.trackableUI.isInside(mouseEvent);
            this.model.setRollover(bl);
            this.model.setEnabled(component.isEnabled());
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            this.isMouseInside = false;
            this.model.setRollover(false);
            this.model.setEnabled(component.isEnabled());
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean bl;
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            this.isMouseInside = bl = this.trackableUI.isInside(mouseEvent);
            this.model.setRollover(this.isMouseInside);
            this.model.setPressed(false);
            this.model.setArmed(false);
            this.model.setSelected(false);
            this.model.setEnabled(component.isEnabled());
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean bl;
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            this.isMouseInside = bl = this.trackableUI.isInside(mouseEvent);
            this.model.setRollover(this.isMouseInside);
            if (this.isMouseInside) {
                this.model.setPressed(true);
                this.model.setArmed(true);
                this.model.setSelected(true);
            }
            this.model.setEnabled(component.isEnabled());
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean bl;
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            this.isMouseInside = bl = this.trackableUI.isInside(mouseEvent);
            this.model.setEnabled(component.isEnabled());
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean bl;
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            this.isMouseInside = bl = this.trackableUI.isInside(mouseEvent);
            this.model.setRollover(bl);
            this.model.setEnabled(component.isEnabled());
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

