/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.ColorSchemeTransform;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.FractionBasedBorderPainter;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class DelegateFractionBasedBorderPainter
implements SubstanceBorderPainter {
    protected String displayName;
    protected FractionBasedBorderPainter delegate;
    protected int[] masks;
    protected ColorSchemeTransform transform;
    protected static final LazyResettableHashMap<SubstanceColorScheme> transformMap = new LazyResettableHashMap("DelegateBorderPainter");

    public DelegateFractionBasedBorderPainter(String string, FractionBasedBorderPainter fractionBasedBorderPainter, int[] nArray, ColorSchemeTransform colorSchemeTransform) {
        this.displayName = string;
        this.delegate = fractionBasedBorderPainter;
        this.masks = new int[nArray.length];
        System.arraycopy(nArray, 0, this.masks, 0, nArray.length);
        this.transform = colorSchemeTransform;
    }

    @Override
    public boolean isPaintingInnerContour() {
        return false;
    }

    @Override
    public void paintBorder(Graphics graphics, Component component, int n, int n2, Shape shape, Shape shape2, SubstanceColorScheme substanceColorScheme) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        SubstanceColorScheme substanceColorScheme2 = this.getShiftScheme(substanceColorScheme);
        float[] fArray = this.delegate.getFractions();
        ColorSchemeSingleColorQuery[] colorSchemeSingleColorQueryArray = this.delegate.getColorQueries();
        Color[] colorArray = new Color[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            ColorSchemeSingleColorQuery colorSchemeSingleColorQuery = colorSchemeSingleColorQueryArray[i];
            Color color = colorSchemeSingleColorQuery.query(substanceColorScheme2);
            colorArray[i] = color = new Color(this.masks[i] & color.getRGB(), true);
        }
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(component));
        boolean bl = component instanceof SubstanceInternalArrowButton;
        int n3 = bl ? 0 : 1;
        int n4 = bl ? 2 : 0;
        graphics2D.setStroke(new BasicStroke(f, n4, n3));
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, n2, fArray, colorArray, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.draw(shape);
        graphics2D.dispose();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    private SubstanceColorScheme getShiftScheme(SubstanceColorScheme substanceColorScheme) {
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(substanceColorScheme.getDisplayName(), this.getDisplayName(), this.transform);
        SubstanceColorScheme substanceColorScheme2 = transformMap.get(hashMapKey);
        if (substanceColorScheme2 == null) {
            substanceColorScheme2 = this.transform.transform(substanceColorScheme);
            transformMap.put(hashMapKey, substanceColorScheme2);
        }
        return substanceColorScheme2;
    }
}

