/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.pushingpixels.lafplugin.ComponentPluginManager;
import org.pushingpixels.lafplugin.PluginManager;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.fonts.FontPolicy;
import org.pushingpixels.substance.api.fonts.FontSet;
import org.pushingpixels.substance.api.fonts.SubstanceFontUtilities;
import org.pushingpixels.substance.api.inputmaps.InputMapSet;
import org.pushingpixels.substance.api.inputmaps.SubstanceInputMapUtilities;
import org.pushingpixels.substance.api.skin.SkinChangeListener;
import org.pushingpixels.substance.api.skin.SkinInfo;
import org.pushingpixels.substance.api.tabbed.BaseTabCloseListener;
import org.pushingpixels.substance.internal.contrib.jgoodies.looks.common.ShadowPopupFactory;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.plugin.SubstanceSkinPlugin;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.LocaleChangeListener;
import org.pushingpixels.substance.internal.utils.MemoryAnalyzer;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePane;
import org.pushingpixels.substance.internal.utils.SubstanceWidgetManager;
import org.pushingpixels.substance.internal.utils.SubstanceWidgetSupport;
import org.pushingpixels.substance.internal.utils.TabCloseListenerManager;

public abstract class SubstanceLookAndFeel
extends BasicLookAndFeel {
    public static final String PLUGIN_XML = "META-INF/substance-plugin.xml";
    private static ComponentPluginManager componentPlugins;
    private static PluginManager skinPlugins;
    protected static final Set<SkinChangeListener> skinChangeListeners;
    protected static final Set<LocaleChangeListener> localeChangeListeners;
    private static boolean toUseConstantThemesOnDialogs;
    protected PropertyChangeListener focusOwnerChangeListener;
    protected KeyboardFocusManager currentKeyboardFocusManager;
    public static final AnimationFacet TREE_SMART_SCROLL_ANIMATION_KIND;
    public static final String WATERMARK_VISIBLE = "substancelaf.watermark.visible";
    public static final String BUTTON_NO_MIN_SIZE_PROPERTY = "substancelaf.buttonnominsize";
    public static final String BUTTON_PAINT_NEVER_PROPERTY = "substancelaf.buttonpaintnever";
    public static final String BUTTON_SIDE_PROPERTY = "substancelaf.buttonside";
    public static final String BUTTON_OPEN_SIDE_PROPERTY = "substancelaf.buttonopenSide";
    public static final String CORNER_RADIUS = "substancelaf.cornerRadius";
    public static final String FLAT_PROPERTY = "substancelaf.componentFlat";
    public static final String HEAP_STATUS_TRACE_FILE = "substancelaf.heapStatusTraceFile";
    public static final String WINDOW_MODIFIED = "windowModified";
    public static final String TABBED_PANE_CLOSE_BUTTONS_PROPERTY = "substancelaf.tabbedpanehasclosebuttons";
    public static final String TABBED_PANE_CLOSE_BUTTONS_MODIFIED_ANIMATION = "substancelaf.tabbedpaneclosebuttonsmodifiedanimation";
    public static final String TABBED_PANE_CLOSE_CALLBACK = "substancelaf.tabbedpanecloseCallback";
    public static final String TABBED_PANE_CONTENT_BORDER_KIND = "substancelaf.tabbedPaneContentBorderKind";
    public static final String COMBO_BOX_POPUP_FLYOUT_ORIENTATION = "substancelaf.comboboxpopupFlyoutOrientation";
    public static final String SCROLL_PANE_BUTTONS_POLICY = "substancelaf.scrollPaneButtonsPolicy";
    public static final String SHOW_EXTRA_WIDGETS = "substancelaf.addWidgets";
    public static final String MENU_GUTTER_FILL_KIND = "substancelaf.menuGutterFillKind";
    public static final String FOCUS_KIND = "substancelaf.focusKind";
    public static final String COMBO_POPUP_PROTOTYPE = "substancelaf.comboPopupPrototype";
    public static final String TRACE_FILE = "substancelaf.traceFile";
    public static final String PASSWORD_ECHO_PER_CHAR = "substancelaf.passwordEchoPerChar";
    public static final String USE_THEMED_DEFAULT_ICONS = "substancelaf.useThemedDefaultIcons";
    public static final String COLORIZATION_FACTOR = "substancelaf.colorizationFactor";
    protected static final String SUBSTANCE_FONT_POLICY_KEY = "substancelaf.fontPolicyKey";
    protected static final String SUBSTANCE_INPUT_MAP_SET_KEY = "substancelaf.inputMapSetKey";
    public static final String BUTTON_SHAPER_PROPERTY = "substancelaf.buttonShaper";
    public static final String SKIN_PROPERTY = "substancelaf.skin";
    private static ResourceBundle LABEL_BUNDLE;
    private static ClassLoader labelBundleClassLoader;
    protected SubstanceSkin skin;
    protected String name;
    private static SubstanceSkin currentSkin;

    protected SubstanceLookAndFeel(SubstanceSkin substanceSkin) {
        this.skin = substanceSkin;
        this.name = "Substance " + substanceSkin.getDisplayName();
        SubstanceLookAndFeel.initPluginsIfNecessary();
    }

    protected static void initPluginsIfNecessary() {
        if (skinPlugins != null) {
            return;
        }
        skinPlugins = new PluginManager(PLUGIN_XML, "laf-plugin", "skin-plugin-class");
        componentPlugins = new ComponentPluginManager(PLUGIN_XML);
    }

    public static synchronized ResourceBundle getLabelBundle() {
        if (LABEL_BUNDLE == null) {
            LABEL_BUNDLE = labelBundleClassLoader == null ? ResourceBundle.getBundle("org.pushingpixels.substance.internal.resources.Labels", Locale.getDefault()) : ResourceBundle.getBundle("org.pushingpixels.substance.internal.resources.Labels", Locale.getDefault(), labelBundleClassLoader);
            for (LocaleChangeListener localeChangeListener : localeChangeListeners) {
                localeChangeListener.localeChanged();
            }
        }
        return LABEL_BUNDLE;
    }

    public static synchronized ResourceBundle getLabelBundle(Locale locale) {
        if (labelBundleClassLoader == null) {
            return ResourceBundle.getBundle("org.pushingpixels.substance.internal.resources.Labels", locale);
        }
        return ResourceBundle.getBundle("org.pushingpixels.substance.internal.resources.Labels", locale, labelBundleClassLoader);
    }

    public static synchronized void resetLabelBundle() {
        LABEL_BUNDLE = null;
        LafWidgetRepository.resetLabelBundle();
    }

    public static SubstanceSkin getCurrentSkin() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof SubstanceLookAndFeel) {
            return currentSkin;
        }
        return null;
    }

    public static SubstanceSkin getCurrentSkin(Component component) {
        return SubstanceCoreUtilities.getSkin(component);
    }

    @Override
    public String getDescription() {
        return "Substance Look and Feel by Kirill Grouchnikov";
    }

    @Override
    public String getID() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        String string = "org.pushingpixels.substance.internal.ui.Substance";
        Object[] objectArray = new Object[]{"ButtonUI", string + "ButtonUI", "CheckBoxUI", string + "CheckBoxUI", "ComboBoxUI", string + "ComboBoxUI", "CheckBoxMenuItemUI", string + "CheckBoxMenuItemUI", "DesktopIconUI", string + "DesktopIconUI", "DesktopPaneUI", string + "DesktopPaneUI", "EditorPaneUI", string + "EditorPaneUI", "FileChooserUI", string + "FileChooserUI", "FormattedTextFieldUI", string + "FormattedTextFieldUI", "InternalFrameUI", string + "InternalFrameUI", "LabelUI", string + "LabelUI", "ListUI", string + "ListUI", "MenuUI", string + "MenuUI", "MenuBarUI", string + "MenuBarUI", "MenuItemUI", string + "MenuItemUI", "OptionPaneUI", string + "OptionPaneUI", "PanelUI", string + "PanelUI", "PasswordFieldUI", string + "PasswordFieldUI", "PopupMenuUI", string + "PopupMenuUI", "PopupMenuSeparatorUI", string + "PopupMenuSeparatorUI", "ProgressBarUI", string + "ProgressBarUI", "RadioButtonUI", string + "RadioButtonUI", "RadioButtonMenuItemUI", string + "RadioButtonMenuItemUI", "RootPaneUI", string + "RootPaneUI", "ScrollBarUI", string + "ScrollBarUI", "ScrollPaneUI", string + "ScrollPaneUI", "SeparatorUI", string + "SeparatorUI", "SliderUI", string + "SliderUI", "SpinnerUI", string + "SpinnerUI", "SplitPaneUI", string + "SplitPaneUI", "TabbedPaneUI", string + "TabbedPaneUI", "TableUI", string + "TableUI", "TableHeaderUI", string + "TableHeaderUI", "TextAreaUI", string + "TextAreaUI", "TextFieldUI", string + "TextFieldUI", "TextPaneUI", string + "TextPaneUI", "ToggleButtonUI", string + "ToggleButtonUI", "ToolBarUI", string + "ToolBarUI", "ToolBarSeparatorUI", string + "ToolBarSeparatorUI", "ToolTipUI", string + "ToolTipUI", "TreeUI", string + "TreeUI", "ViewportUI", string + "ViewportUI"};
        uIDefaults.putDefaults(objectArray);
    }

    @Override
    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        this.initFontDefaults(uIDefaults);
        this.skin.addCustomEntriesToTable(uIDefaults);
    }

    public static void setFontPolicy(FontPolicy fontPolicy) {
        UIManager.put(SUBSTANCE_FONT_POLICY_KEY, fontPolicy);
        SubstanceSizeUtils.setControlFontSize(-1);
        SubstanceSizeUtils.resetPointsToPixelsRatio(fontPolicy);
        SubstanceLookAndFeel.setSkin(SubstanceLookAndFeel.getCurrentSkin());
    }

    public static FontPolicy getFontPolicy() {
        FontPolicy fontPolicy = (FontPolicy)UIManager.get(SUBSTANCE_FONT_POLICY_KEY);
        if (fontPolicy != null) {
            return fontPolicy;
        }
        return SubstanceFontUtilities.getDefaultFontPolicy();
    }

    public static void setInputMapSet(InputMapSet inputMapSet) {
        UIManager.put(SUBSTANCE_INPUT_MAP_SET_KEY, inputMapSet);
        SubstanceLookAndFeel.setSkin(SubstanceLookAndFeel.getCurrentSkin());
    }

    public static InputMapSet getInputMapSet() {
        InputMapSet inputMapSet = (InputMapSet)UIManager.get(SUBSTANCE_INPUT_MAP_SET_KEY);
        if (inputMapSet != null) {
            return inputMapSet;
        }
        return SubstanceInputMapUtilities.getSystemInputMapSet();
    }

    private void initFontDefaults(UIDefaults uIDefaults) {
        FontSet fontSet = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null);
        SubstanceLookAndFeel.initFontDefaults(uIDefaults, fontSet);
    }

    private static void initFontDefaults(UIDefaults uIDefaults, FontSet fontSet) {
        FontUIResource fontUIResource = fontSet.getControlFont();
        FontUIResource fontUIResource2 = fontSet.getMenuFont();
        FontUIResource fontUIResource3 = fontSet.getMessageFont();
        FontUIResource fontUIResource4 = fontSet.getSmallFont();
        FontUIResource fontUIResource5 = fontSet.getTitleFont();
        FontUIResource fontUIResource6 = fontSet.getWindowTitleFont();
        Object[] objectArray = new Object[]{"Button.font", fontUIResource, "CheckBox.font", fontUIResource, "ColorChooser.font", fontUIResource, "ComboBox.font", fontUIResource, "EditorPane.font", fontUIResource, "FormattedTextField.font", fontUIResource, "Label.font", fontUIResource, "List.font", fontUIResource, "Panel.font", fontUIResource, "PasswordField.font", fontUIResource, "ProgressBar.font", fontUIResource, "RadioButton.font", fontUIResource, "ScrollPane.font", fontUIResource, "Spinner.font", fontUIResource, "TabbedPane.font", fontUIResource, "Table.font", fontUIResource, "TableHeader.font", fontUIResource, "TextArea.font", fontUIResource, "TextField.font", fontUIResource, "TextPane.font", fontUIResource, "ToolBar.font", fontUIResource, "ToggleButton.font", fontUIResource, "Tree.font", fontUIResource, "Viewport.font", fontUIResource, "InternalFrame.titleFont", fontUIResource6, "DesktopIcon.titleFont", fontUIResource6, "OptionPane.font", fontUIResource3, "OptionPane.messageFont", fontUIResource3, "OptionPane.buttonFont", fontUIResource3, "TitledBorder.font", fontUIResource5, "ToolTip.font", fontUIResource4, "CheckBoxMenuItem.font", fontUIResource2, "CheckBoxMenuItem.acceleratorFont", fontUIResource2, "Menu.font", fontUIResource2, "Menu.acceleratorFont", fontUIResource2, "MenuBar.font", fontUIResource2, "MenuItem.font", fontUIResource2, "MenuItem.acceleratorFont", fontUIResource2, "PopupMenu.font", fontUIResource2, "RadioButtonMenuItem.font", fontUIResource2, "RadioButtonMenuItem.acceleratorFont", fontUIResource2};
        uIDefaults.putDefaults(objectArray);
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults uIDefaults = super.getDefaults();
        componentPlugins.processAllDefaultsEntries(uIDefaults, this.skin);
        return uIDefaults;
    }

    @Override
    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
        SubstanceLookAndFeel.setSkin(this.skin, false);
        String string = SubstanceCoreUtilities.getVmParameter(TRACE_FILE);
        if (string != null) {
            MemoryAnalyzer.commence(1000L, string);
            for (Object e : componentPlugins.getAvailablePlugins(true)) {
                MemoryAnalyzer.enqueueUsage("Has plugin '" + e.getClass().getName() + "'");
            }
        }
        String string2 = SubstanceCoreUtilities.getVmParameter(HEAP_STATUS_TRACE_FILE);
        SubstanceTitlePane.setHeapStatusLogfileName(string2);
        componentPlugins.initializeAll();
        LafWidgetRepository.getRepository().setLafSupport(new SubstanceWidgetSupport());
        this.focusOwnerChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Component component;
                if ("focusOwner".equals(propertyChangeEvent.getPropertyName()) && (component = (Component)propertyChangeEvent.getNewValue()) != null) {
                    JRootPane jRootPane = SwingUtilities.getRootPane(component);
                    if (jRootPane == null) {
                        return;
                    }
                    JButton jButton = jRootPane.getDefaultButton();
                    if (jButton == null) {
                        return;
                    }
                    jButton.repaint();
                }
                if ("managingFocus".equals(propertyChangeEvent.getPropertyName()) && Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                    SubstanceLookAndFeel.this.currentKeyboardFocusManager.removePropertyChangeListener(SubstanceLookAndFeel.this.focusOwnerChangeListener);
                    SubstanceLookAndFeel.this.currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    SubstanceLookAndFeel.this.currentKeyboardFocusManager.addPropertyChangeListener(SubstanceLookAndFeel.this.focusOwnerChangeListener);
                }
            }
        };
        this.currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.currentKeyboardFocusManager.addPropertyChangeListener(this.focusOwnerChangeListener);
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        currentSkin = null;
        ShadowPopupFactory.uninstall();
        SubstanceCoreUtilities.stopThreads();
        if (this.skin.getWatermark() != null) {
            this.skin.getWatermark().dispose();
        }
        componentPlugins.uninitializeAll();
        LafWidgetRepository.getRepository().unsetLafSupport();
        LazyResettableHashMap.reset();
        this.currentKeyboardFocusManager.removePropertyChangeListener(this.focusOwnerChangeListener);
        this.focusOwnerChangeListener = null;
        this.currentKeyboardFocusManager = null;
    }

    public static void registerSkinChangeListener(SkinChangeListener skinChangeListener) {
        skinChangeListeners.add(skinChangeListener);
    }

    public static void unregisterSkinChangeListener(SkinChangeListener skinChangeListener) {
        skinChangeListeners.remove(skinChangeListener);
    }

    public static void registerTabCloseChangeListener(BaseTabCloseListener baseTabCloseListener) {
        TabCloseListenerManager.getInstance().registerListener(baseTabCloseListener);
    }

    public static void registerTabCloseChangeListener(JTabbedPane jTabbedPane, BaseTabCloseListener baseTabCloseListener) {
        TabCloseListenerManager.getInstance().registerListener(jTabbedPane, baseTabCloseListener);
    }

    public static void unregisterTabCloseChangeListener(BaseTabCloseListener baseTabCloseListener) {
        TabCloseListenerManager.getInstance().unregisterListener(baseTabCloseListener);
    }

    public static void unregisterTabCloseChangeListener(JTabbedPane jTabbedPane, BaseTabCloseListener baseTabCloseListener) {
        TabCloseListenerManager.getInstance().unregisterListener(jTabbedPane, baseTabCloseListener);
    }

    public static Set<BaseTabCloseListener> getAllTabCloseListeners() {
        return TabCloseListenerManager.getInstance().getListeners();
    }

    public static Set<BaseTabCloseListener> getAllTabCloseListeners(JTabbedPane jTabbedPane) {
        return TabCloseListenerManager.getInstance().getListeners(jTabbedPane);
    }

    public static void registerLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        localeChangeListeners.add(localeChangeListener);
    }

    public static void unregisterLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        localeChangeListeners.remove(localeChangeListener);
    }

    public static Set<LocaleChangeListener> getLocaleListeners() {
        return Collections.unmodifiableSet(localeChangeListeners);
    }

    public static void setWidgetVisible(JRootPane jRootPane, boolean bl, SubstanceConstants.SubstanceWidgetType ... substanceWidgetTypeArray) {
        SubstanceWidgetManager.getInstance().register(jRootPane, bl, substanceWidgetTypeArray);
        if (jRootPane != null) {
            SwingUtilities.updateComponentTreeUI(jRootPane);
        } else {
            for (Window window : Window.getWindows()) {
                JRootPane jRootPane2 = SwingUtilities.getRootPane(window);
                SwingUtilities.updateComponentTreeUI(jRootPane2);
            }
        }
    }

    public static boolean isToUseConstantThemesOnDialogs() {
        return toUseConstantThemesOnDialogs;
    }

    public static void setToUseConstantThemesOnDialogs(boolean bl) {
        toUseConstantThemesOnDialogs = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Window window : Window.getWindows()) {
                    SwingUtilities.updateComponentTreeUI(window);
                }
            }
        });
    }

    private static boolean setSkin(SubstanceSkin substanceSkin, boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called on the Event Dispatch Thread");
        }
        if (!substanceSkin.isValid()) {
            return false;
        }
        boolean bl2 = UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel;
        if (!bl2) {
            class SkinDerivedLookAndFeel
            extends SubstanceLookAndFeel {
                public SkinDerivedLookAndFeel(SubstanceSkin substanceSkin) {
                    super(substanceSkin);
                }
            }
            SkinDerivedLookAndFeel skinDerivedLookAndFeel = new SkinDerivedLookAndFeel(substanceSkin);
            try {
                UIManager.setLookAndFeel(skinDerivedLookAndFeel);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                return false;
            }
            if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
                return false;
            }
            for (Window window : Window.getWindows()) {
                SwingUtilities.updateComponentTreeUI(window);
            }
            return true;
        }
        try {
            if (!substanceSkin.isValid()) {
                return false;
            }
            if (currentSkin != null && currentSkin.getWatermark() != null) {
                currentSkin.getWatermark().dispose();
            }
            if (substanceSkin.getWatermark() != null && !substanceSkin.getWatermark().updateWatermarkImage(substanceSkin)) {
                return false;
            }
            UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
            UIDefaults uIDefaults2 = uIDefaults;
            if (uIDefaults2 != null) {
                SubstanceLookAndFeel.initFontDefaults(uIDefaults, SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null));
                substanceSkin.addCustomEntriesToTable(uIDefaults);
                componentPlugins.processAllDefaultsEntries(uIDefaults, substanceSkin);
            }
            ResourceBundle resourceBundle = SubstanceLookAndFeel.getLabelBundle();
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                Window[] windowArray = enumeration.nextElement();
                if (windowArray.indexOf("FileChooser") == -1) continue;
                String string = resourceBundle.getString((String)windowArray);
                UIManager.put(windowArray, string);
            }
            if (bl2) {
                LazyResettableHashMap.reset();
            }
            currentSkin = substanceSkin;
            if (bl) {
                for (Window window : Window.getWindows()) {
                    SwingUtilities.updateComponentTreeUI(window);
                }
            }
            for (SkinChangeListener skinChangeListener : skinChangeListeners) {
                skinChangeListener.skinChanged();
            }
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean setSkin(SubstanceSkin substanceSkin) {
        return SubstanceLookAndFeel.setSkin(substanceSkin, true);
    }

    public static boolean setSkin(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz == null) {
                return false;
            }
            Object obj = clazz.newInstance();
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubstanceSkin)) {
                return false;
            }
            return SubstanceLookAndFeel.setSkin((SubstanceSkin)obj);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static Map<String, SkinInfo> getAllSkins() {
        SubstanceLookAndFeel.initPluginsIfNecessary();
        TreeMap<String, SkinInfo> treeMap = new TreeMap<String, SkinInfo>();
        for (Object e : skinPlugins.getAvailablePlugins(true)) {
            for (SkinInfo skinInfo : ((SubstanceSkinPlugin)e).getSkins()) {
                treeMap.put(skinInfo.getDisplayName(), skinInfo);
            }
        }
        return treeMap;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    public static void setLabelBundleClassLoader(ClassLoader classLoader) {
        labelBundleClassLoader = classLoader;
        LafWidgetRepository.setLabelBundleClassLoader(classLoader);
    }

    public static JComponent getTitlePaneComponent(Window window) {
        Object object;
        JRootPane jRootPane = null;
        if (window instanceof JFrame) {
            object = (JFrame)window;
            jRootPane = ((JFrame)object).getRootPane();
        }
        if (window instanceof JDialog) {
            object = (JDialog)window;
            jRootPane = ((JDialog)object).getRootPane();
        }
        if (jRootPane != null) {
            object = (SubstanceRootPaneUI)jRootPane.getUI();
            return ((SubstanceRootPaneUI)object).getTitlePane();
        }
        return null;
    }

    public static void setDecorationType(JComponent jComponent, DecorationAreaType decorationAreaType) {
        DecorationPainterUtils.setDecorationType(jComponent, decorationAreaType);
    }

    public static DecorationAreaType getDecorationType(Component component) {
        return DecorationPainterUtils.getDecorationType(component);
    }

    public static DecorationAreaType getImmediateDecorationType(Component component) {
        return DecorationPainterUtils.getImmediateDecorationType(component);
    }

    public static boolean isCurrentLookAndFeel() {
        return UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel && currentSkin != null;
    }

    @Override
    public Icon getDisabledIcon(JComponent jComponent, Icon icon) {
        if (icon == null) {
            return null;
        }
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jComponent, ComponentState.DISABLED_UNSELECTED);
        BufferedImage bufferedImage = SubstanceImageCreator.getColorSchemeImage(jComponent, icon, substanceColorScheme, 0.5f);
        float f = SubstanceColorSchemeUtilities.getAlpha(jComponent, ComponentState.DISABLED_UNSELECTED);
        if (f < 1.0f) {
            BufferedImage bufferedImage2 = SubstanceCoreUtilities.getBlankImage(bufferedImage.getWidth(), bufferedImage.getHeight());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(f));
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            bufferedImage = bufferedImage2;
        }
        return new IconUIResource(new ImageIcon(bufferedImage));
    }

    static {
        skinChangeListeners = new HashSet<SkinChangeListener>();
        localeChangeListeners = new HashSet<LocaleChangeListener>();
        toUseConstantThemesOnDialogs = true;
        TREE_SMART_SCROLL_ANIMATION_KIND = new AnimationFacet("substancelaf.treeSmartScrollAnimationKind", false);
        LABEL_BUNDLE = null;
        currentSkin = null;
    }
}

