/*
 * Decompiled with CFR 0.152.
 */
package nl.ikarus.nxt.priv.imageio.icoreader.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.MyReader;

public class ICOWriter
extends ImageWriter {
    protected ICOWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        ImageOutputStream stream = (ImageOutputStream)this.getOutput();
        if (stream == null) {
            throw new IllegalStateException("You must specify the output stream");
        }
        if (image == null) {
            throw new IllegalArgumentException("You must specify the image");
        }
        ByteArrayOutputStream icon = new ByteArrayOutputStream(8192);
        ImageOutputStream out = ImageIO.createImageOutputStream(icon);
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        out.writeShort(0);
        out.writeShort(1);
        out.writeShort(1);
        byte[] bmpdata = null;
        Iterator<ImageWriter> it = ImageIO.getImageWritersBySuffix("bmp");
        ByteArrayOutputStream bmpOut = new ByteArrayOutputStream(8192);
        while (it.hasNext()) {
            ImageWriter w = it.next();
            ImageOutputStream iosOut = ImageIO.createImageOutputStream(bmpOut);
            try {
                w.setOutput(iosOut);
                w.write(image);
                iosOut.flush();
            }
            catch (Exception ex) {
                System.err.println("Exception for writer " + w.getClass().getName());
                ex.printStackTrace();
                bmpOut = new ByteArrayOutputStream(8192);
            }
        }
        if (bmpOut.size() == 0) {
            throw new IllegalStateException("Unable to find an ImageIO Encoder that could encode this image to bmp, the ICOWriter depends on this...");
        }
        bmpdata = bmpOut.toByteArray();
        bmpOut = null;
        DataInputStream tmpin2 = new DataInputStream(new ByteArrayInputStream(bmpdata));
        MyReader tmpin = new MyReader(tmpin2);
        tmpin.skip(10);
        int imageoffset = tmpin.readLONG();
        System.err.println("OFFSET = " + imageoffset + "   should I skip some bytes??");
        int headersize = tmpin.readLONG();
        if (headersize < 40) {
            System.err.println("Excpected a header size of 40 but found: " + headersize + " ..... unable to parse the metadata");
        } else {
            if (headersize != 40) {
                System.err.println("Excpected a header size of 40 but found: " + headersize + " ..... but I'll try to parse the metadata anyway");
            }
            int w = tmpin.readLONG();
            int h = tmpin.readLONG();
            int planes = tmpin.readWORD();
            int bcount = tmpin.readWORD();
            tmpin.readLONG();
            int sizeImg = tmpin.readLONG();
            tmpin.readDWORD();
            tmpin.readDWORD();
            int colUsed = tmpin.readDWORD();
            tmpin.readDWORD();
            out.writeByte(w);
            out.writeByte(h);
            out.writeByte(colUsed);
            out.writeByte(0);
            out.writeShort(planes);
            out.writeShort(bcount);
            out.writeInt(sizeImg);
            out.writeInt(22);
            tmpin.reset();
            tmpin.skip(14);
            try {
                int i = tmpin.readLONG();
                byte[] test = new byte[4];
                test[3] = (byte)(i / 0x1000000);
                test[2] = (byte)((i -= test[3]) / 65536);
                test[1] = (byte)((i -= test[2]) / 256);
                test[0] = (byte)(i -= test[1]);
                out.write(test);
                i = tmpin.readLONG();
                test = new byte[4];
                test[3] = (byte)(i / 0x1000000);
                test[2] = (byte)((i -= test[3]) / 65536);
                test[1] = (byte)((i -= test[2]) / 256);
                test[0] = (byte)(i -= test[1]);
                out.write(test);
                i = tmpin.readLONG() * 2;
                test = new byte[4];
                test[3] = (byte)(i / 0x1000000);
                test[2] = (byte)((i -= test[3]) / 65536);
                test[1] = (byte)((i -= test[2]) / 256);
                test[0] = (byte)(i -= test[1]);
                out.write(test);
                while (true) {
                    int tmpbyte = tmpin.readBYTE();
                    out.writeByte(tmpbyte);
                }
            }
            catch (EOFException ex) {
                out.flush();
            }
        }
        System.out.println("Start writing to the output stream");
        byte[] icondata = icon.toByteArray();
        stream.write(icondata);
        stream.flush();
    }
}

