/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.utils.PlatformType;

public class ResourceManager
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(ResourceManager.class.getName());
    private final Map<String, ResourceMap> resourceMaps;
    private final ApplicationContext context;
    private List<String> applicationBundleNames = null;
    private ResourceMap appResourceMap = null;

    protected ResourceManager(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("null context");
        }
        this.context = applicationContext;
        this.resourceMaps = new ConcurrentHashMap<String, ResourceMap>();
    }

    protected final ApplicationContext getContext() {
        return this.context;
    }

    private List<String> allBundleNames(Class clazz, Class clazz2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Class clazz3 = clazz2.getSuperclass();
        for (Class clazz4 = clazz; clazz4 != clazz3; clazz4 = clazz4.getSuperclass()) {
            arrayList.addAll(this.getClassBundleNames(clazz4));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private String bundlePackageName(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? "" : string.substring(0, n);
    }

    private ResourceMap createResourceMapChain(ClassLoader classLoader, ResourceMap resourceMap, ListIterator<String> listIterator) {
        Object object;
        if (!listIterator.hasNext()) {
            return resourceMap;
        }
        String string = listIterator.next();
        String string2 = this.bundlePackageName(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        while (listIterator.hasNext()) {
            object = listIterator.next();
            if (string2.equals(this.bundlePackageName((String)object))) {
                arrayList.add((String)object);
                continue;
            }
            listIterator.previous();
            break;
        }
        object = this.createResourceMapChain(classLoader, resourceMap, listIterator);
        return this.createResourceMap(classLoader, (ResourceMap)object, arrayList);
    }

    private ResourceMap getApplicationResourceMap() {
        if (this.appResourceMap == null) {
            List<String> list = this.getApplicationBundleNames();
            Class<Application> clazz = this.getContext().getApplicationClass();
            if (clazz == null) {
                logger.warning("getApplicationResourceMap(): no Application class");
                clazz = Application.class;
            }
            ClassLoader classLoader = clazz.getClassLoader();
            this.appResourceMap = this.createResourceMapChain(classLoader, null, list.listIterator());
        }
        return this.appResourceMap;
    }

    private ResourceMap getClassResourceMap(Class clazz, Class clazz2) {
        String string = clazz.getName() + clazz2.getName();
        ResourceMap resourceMap = this.resourceMaps.get(string);
        if (resourceMap == null) {
            List<String> list = this.allBundleNames(clazz, clazz2);
            ClassLoader classLoader = clazz.getClassLoader();
            ResourceMap resourceMap2 = this.getResourceMap();
            resourceMap = this.createResourceMapChain(classLoader, resourceMap2, list.listIterator());
            this.resourceMaps.put(string, resourceMap);
        }
        return resourceMap;
    }

    public ResourceMap getResourceMap(Class clazz, Class clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("null startClass");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("null stopClass");
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("startClass is not a subclass, or the same as, stopClass");
        }
        return this.getClassResourceMap(clazz, clazz2);
    }

    public final ResourceMap getResourceMap(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        return this.getResourceMap(clazz, clazz);
    }

    public ResourceMap getResourceMap() {
        return this.getApplicationResourceMap();
    }

    public List<String> getApplicationBundleNames() {
        if (this.applicationBundleNames == null) {
            Class clazz = this.getContext().getApplicationClass();
            if (clazz == null) {
                return this.allBundleNames(Application.class, Application.class);
            }
            this.applicationBundleNames = this.allBundleNames(clazz, Application.class);
        }
        return this.applicationBundleNames;
    }

    public void setApplicationBundleNames(List<String> list) {
        if (list != null) {
            for (String string : list) {
                if (string != null && list.size() != 0) continue;
                throw new IllegalArgumentException("invalid bundle name \"" + string + "\"");
            }
        }
        List<String> list2 = this.applicationBundleNames;
        this.applicationBundleNames = list != null ? Collections.unmodifiableList(new ArrayList<String>(list)) : null;
        this.resourceMaps.clear();
        this.firePropertyChange("applicationBundleNames", list2, this.applicationBundleNames);
    }

    private String classBundleBaseName(Class clazz) {
        String string = clazz.getName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append(".resources.");
            stringBuffer.append(clazz.getSimpleName());
        } else {
            stringBuffer.append("resources.");
            stringBuffer.append(clazz.getSimpleName());
        }
        return stringBuffer.toString();
    }

    protected List<String> getClassBundleNames(Class clazz) {
        String string = this.classBundleBaseName(clazz);
        return Collections.singletonList(string);
    }

    protected ResourceMap createResourceMap(ClassLoader classLoader, ResourceMap resourceMap, List<String> list) {
        return new ResourceMap(resourceMap, classLoader, list);
    }

    public PlatformType getPlatform() {
        return this.getResourceMap().getPlatform();
    }

    public void setPlatform(PlatformType platformType) {
        if (platformType == null) {
            throw new IllegalArgumentException("null platform");
        }
        this.getResourceMap().setPlatform(platformType);
    }
}

