/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.util;

import com.jgoodies.forms.util.UnitConverter;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public abstract class AbstractUnitConverter
implements UnitConverter {
    private static final int DTP_RESOLUTION = 72;
    private static int defaultScreenResolution = -1;

    @Override
    public int inchAsPixel(double d, Component component) {
        return this.inchAsPixel(d, this.getScreenResolution(component));
    }

    @Override
    public int millimeterAsPixel(double d, Component component) {
        return this.millimeterAsPixel(d, this.getScreenResolution(component));
    }

    @Override
    public int centimeterAsPixel(double d, Component component) {
        return this.centimeterAsPixel(d, this.getScreenResolution(component));
    }

    @Override
    public int pointAsPixel(int n, Component component) {
        return this.pointAsPixel(n, this.getScreenResolution(component));
    }

    @Override
    public int dialogUnitXAsPixel(int n, Component component) {
        return this.dialogUnitXAsPixel(n, this.getDialogBaseUnitsX(component));
    }

    @Override
    public int dialogUnitYAsPixel(int n, Component component) {
        return this.dialogUnitYAsPixel(n, this.getDialogBaseUnitsY(component));
    }

    protected abstract double getDialogBaseUnitsX(Component var1);

    protected abstract double getDialogBaseUnitsY(Component var1);

    protected final int inchAsPixel(double d, int n) {
        return (int)Math.round((double)n * d);
    }

    protected final int millimeterAsPixel(double d, int n) {
        return (int)Math.round((double)n * d * 10.0 / 254.0);
    }

    protected final int centimeterAsPixel(double d, int n) {
        return (int)Math.round((double)n * d * 100.0 / 254.0);
    }

    protected final int pointAsPixel(int n, int n2) {
        return Math.round(n2 * n / 72);
    }

    protected int dialogUnitXAsPixel(int n, double d) {
        return (int)Math.round((double)n * d / 4.0);
    }

    protected int dialogUnitYAsPixel(int n, double d) {
        return (int)Math.round((double)n * d / 8.0);
    }

    protected double computeAverageCharWidth(FontMetrics fontMetrics, String string) {
        int n = fontMetrics.stringWidth(string);
        double d = (double)n / (double)string.length();
        return d;
    }

    protected int getScreenResolution(Component component) {
        if (component == null) {
            return this.getDefaultScreenResolution();
        }
        Toolkit toolkit = component.getToolkit();
        return toolkit != null ? toolkit.getScreenResolution() : this.getDefaultScreenResolution();
    }

    protected int getDefaultScreenResolution() {
        if (defaultScreenResolution == -1) {
            defaultScreenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        return defaultScreenResolution;
    }
}

