/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SecurityTokenReference {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$message$token$SecurityTokenReference == null ? (class$org$apache$ws$security$message$token$SecurityTokenReference = SecurityTokenReference.class$("org.apache.ws.security.message.token.SecurityTokenReference")) : class$org$apache$ws$security$message$token$SecurityTokenReference).getName());
    public static final String SECURITY_TOKEN_REFERENCE = "SecurityTokenReference";
    public static final String KEY_NAME = "KeyName";
    public static final String SKI_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
    public static final String THUMB_URI = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1";
    public static final String SAML_ID_URI = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
    public static final String ENC_KEY_SHA1_URI = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1";
    protected Element element = null;
    private XMLX509IssuerSerial issuerSerial = null;
    private byte[] skiBytes = null;
    private static boolean doDebug = false;
    static /* synthetic */ Class class$org$apache$ws$security$message$token$SecurityTokenReference;

    public SecurityTokenReference(Element elem) throws WSSecurityException {
        doDebug = log.isDebugEnabled();
        this.element = elem;
        boolean goodElement = false;
        if (SECURITY_TOKEN_REFERENCE.equals(this.element.getLocalName())) {
            goodElement = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(this.element.getNamespaceURI());
        }
        if (!goodElement) {
            throw new WSSecurityException(0, "badElement", null);
        }
    }

    public SecurityTokenReference(Document doc) {
        doDebug = log.isDebugEnabled();
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
    }

    public void setReference(Reference ref) {
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(ref.getElement(), elem);
        } else {
            this.element.appendChild(ref.getElement());
        }
    }

    public Reference getReference() throws WSSecurityException {
        Element elem = this.getFirstElement();
        return new Reference(elem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element getTokenElement(Document doc, WSDocInfo docInfo, CallbackHandler cb) throws WSSecurityException {
        Reference ref = this.getReference();
        String uri = ref.getURI();
        if (doDebug) {
            log.debug((Object)("Token reference uri: " + uri));
        }
        if (uri == null) {
            throw new WSSecurityException(3, "badReferenceURI");
        }
        Element tokElement = null;
        String tmpS = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertion-1.1";
        String saml10 = SAML_ID_URI;
        if (tmpS.equals(ref.getValueType()) || saml10.equals(ref.getValueType()) || "http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(ref.getValueType())) {
            String id;
            Element sa = docInfo.getAssertion();
            String saID = null;
            if (sa != null) {
                saID = sa.getAttribute("AssertionID");
            }
            if (doDebug) {
                log.debug((Object)("SAML token ID: " + saID));
            }
            if ((id = uri).charAt(0) == '#') {
                id = id.substring(1);
            }
            if (saID == null || !saID.equals(id)) {
                if (cb == null) throw new WSSecurityException(3, "badReferenceURI", new Object[]{"uri:" + uri + ", saID: " + saID});
                WSPasswordCallback pwcb = new WSPasswordCallback(id, 7);
                try {
                    cb.handle(new Callback[]{pwcb});
                }
                catch (Exception e) {
                    throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
                }
                Element assertionElem = pwcb.getCustomToken();
                if (assertionElem == null) throw new WSSecurityException(3, "badReferenceURI", new Object[]{"uri:" + uri + ", saID: " + saID});
                sa = (Element)doc.importNode(assertionElem, true);
            }
            tokElement = sa;
        } else {
            tokElement = WSSecurityUtil.getElementByWsuId(doc, uri);
            if (tokElement == null) {
                tokElement = WSSecurityUtil.getElementByGenId(doc, uri);
            }
        }
        if (tokElement != null) return tokElement;
        throw new WSSecurityException(7, "noToken", new Object[]{uri});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element getKeyIdentifierTokenElement(Document doc, WSDocInfo docInfo, CallbackHandler cb) throws WSSecurityException {
        String value = this.getKeyIdentifierValue();
        String type = this.getKeyIdentifierValueType();
        if (doDebug) {
            log.debug((Object)("Token reference uri: " + value));
        }
        if (value == null) {
            throw new WSSecurityException(3, "badReferenceURI");
        }
        Element tokElement = null;
        String saml10 = SAML_ID_URI;
        if (saml10.equals(type) || "http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(type)) {
            String id;
            Element sa = docInfo.getAssertion();
            String saID = null;
            if (sa != null) {
                saID = sa.getAttribute("AssertionID");
            }
            if (doDebug) {
                log.debug((Object)("SAML token ID: " + saID));
            }
            if ((id = value).charAt(0) == '#') {
                id = id.substring(1);
            }
            if (saID == null || !saID.equals(id)) {
                if (cb == null) throw new WSSecurityException(3, "badReferenceURI", new Object[]{"uri:" + value + ", saID: " + saID});
                WSPasswordCallback pwcb = new WSPasswordCallback(id, 7);
                try {
                    cb.handle(new Callback[]{pwcb});
                }
                catch (Exception e) {
                    throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
                }
                Element assertionElem = pwcb.getCustomToken();
                if (assertionElem == null) throw new WSSecurityException(3, "badReferenceURI", new Object[]{"uri:" + value + ", saID: " + saID});
                sa = (Element)doc.importNode(assertionElem, true);
            }
            tokElement = sa;
        } else {
            tokElement = WSSecurityUtil.getElementByWsuId(doc, value);
            if (tokElement == null) {
                tokElement = WSSecurityUtil.getElementByGenId(doc, value);
            }
        }
        if (tokElement != null) return tokElement;
        throw new WSSecurityException(7, "noToken", new Object[]{value});
    }

    public void setKeyIdentifier(X509Certificate cert) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        byte[] data = null;
        try {
            data = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError", null, e);
        }
        Text text = doc.createTextNode(Base64.encode(data));
        this.createKeyIdentifier(doc, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", text, true);
    }

    public void setKeyIdentifierSKI(X509Certificate cert, Crypto crypto) throws WSSecurityException {
        if (cert.getVersion() != 3) {
            throw new WSSecurityException(1, "invalidCertForSKI", new Object[]{new Integer(cert.getVersion())});
        }
        Document doc = this.element.getOwnerDocument();
        byte[] data = crypto.getSKIBytesFromCert(cert);
        Text text = doc.createTextNode(Base64.encode(data));
        this.createKeyIdentifier(doc, SKI_URI, text, true);
    }

    public void setKeyIdentifierThumb(X509Certificate cert) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new WSSecurityException(0, "noSHA1availabe", null, e1);
        }
        sha.reset();
        try {
            sha.update(cert.getEncoded());
        }
        catch (CertificateEncodingException e1) {
            throw new WSSecurityException(7, "encodeError", null, e1);
        }
        byte[] data = sha.digest();
        Text text = doc.createTextNode(Base64.encode(data));
        this.createKeyIdentifier(doc, THUMB_URI, text, true);
    }

    public void setKeyIdentifierEncKeySHA1(String value) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        Text text = doc.createTextNode(value);
        this.createKeyIdentifier(doc, ENC_KEY_SHA1_URI, text, true);
    }

    public void setSAMLKeyIdentifier(String keyIdVal) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        this.createKeyIdentifier(doc, SAML_ID_URI, doc.createTextNode(keyIdVal), false);
    }

    public void setKeyIdentifier(String valueType, String keyIdVal) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        this.createKeyIdentifier(doc, valueType, doc.createTextNode(keyIdVal), false);
    }

    private void createKeyIdentifier(Document doc, String uri, Node node, boolean base64) {
        Element keyId = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
        keyId.setAttributeNS(null, "ValueType", uri);
        if (base64) {
            keyId.setAttributeNS(null, "EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        }
        keyId.appendChild(node);
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(keyId, elem);
        } else {
            this.element.appendChild(keyId);
        }
    }

    public Element getFirstElement() {
        for (Node currentChild = this.element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!(currentChild instanceof Element)) continue;
            return (Element)currentChild;
        }
        return null;
    }

    public X509Certificate[] getKeyIdentifier(Crypto crypto) throws WSSecurityException {
        Element elem = this.getFirstElement();
        String value = elem.getAttribute("ValueType");
        String alias = null;
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(value)) {
            X509Security token = new X509Security(elem);
            if (token != null) {
                X509Certificate cert = token.getX509Certificate(crypto);
                X509Certificate[] certs = new X509Certificate[]{cert};
                return certs;
            }
        } else if (SKI_URI.equals(value)) {
            alias = this.getX509SKIAlias(crypto);
        } else if (THUMB_URI.equals(value)) {
            Node node = this.getFirstElement().getFirstChild();
            if (node == null) {
                return null;
            }
            if (node.getNodeType() == 3) {
                byte[] thumb = Base64.decode(((Text)node).getData());
                alias = crypto.getAliasForX509CertThumb(thumb);
            }
        }
        if (alias != null) {
            return crypto.getCertificates(alias);
        }
        return null;
    }

    public String getKeyIdentifierValue() {
        if (this.containsKeyIdentifier()) {
            Node node = this.getFirstElement().getFirstChild();
            if (node == null) {
                return null;
            }
            if (node.getNodeType() == 3) {
                return ((Text)node).getData();
            }
        }
        return null;
    }

    public String getKeyIdentifierValueType() {
        if (this.containsKeyIdentifier()) {
            Element elem = this.getFirstElement();
            return elem.getAttribute("ValueType");
        }
        return null;
    }

    public String getX509SKIAlias(Crypto crypto) throws WSSecurityException {
        if (this.skiBytes == null) {
            this.skiBytes = this.getSKIBytes();
            if (this.skiBytes == null) {
                return null;
            }
        }
        String alias = crypto.getAliasForX509Cert(this.skiBytes);
        if (doDebug) {
            log.info((Object)("X509 SKI alias: " + alias));
        }
        return alias;
    }

    public byte[] getSKIBytes() {
        if (this.skiBytes != null) {
            return this.skiBytes;
        }
        Node node = this.getFirstElement().getFirstChild();
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 3) {
            try {
                this.skiBytes = Base64.decode(((Text)node).getData());
            }
            catch (WSSecurityException e) {
                return null;
            }
        }
        return this.skiBytes;
    }

    public void setX509IssuerSerial(X509Data ref) {
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(ref.getElement(), elem);
        } else {
            this.element.appendChild(ref.getElement());
        }
    }

    public X509Certificate[] getX509IssuerSerial(Crypto crypto) throws WSSecurityException {
        String alias = this.getX509IssuerSerialAlias(crypto);
        if (alias != null) {
            return crypto.getCertificates(alias);
        }
        return null;
    }

    public String getX509IssuerSerialAlias(Crypto crypto) throws WSSecurityException {
        if (this.issuerSerial == null) {
            this.issuerSerial = this.getIssuerSerial();
            if (this.issuerSerial == null) {
                return null;
            }
        }
        String alias = crypto.getAliasForX509Cert(this.issuerSerial.getIssuerName(), this.issuerSerial.getSerialNumber());
        if (doDebug) {
            log.info((Object)("X509IssuerSerial alias: " + alias));
        }
        return alias;
    }

    private XMLX509IssuerSerial getIssuerSerial() throws WSSecurityException {
        if (this.issuerSerial != null) {
            return this.issuerSerial;
        }
        Element elem = this.getFirstElement();
        if (elem == null) {
            return null;
        }
        try {
            if ("X509Data".equals(elem.getLocalName())) {
                elem = (Element)WSSecurityUtil.findElement(elem, "X509IssuerSerial", "http://www.w3.org/2000/09/xmldsig#");
            }
            this.issuerSerial = new XMLX509IssuerSerial(elem, "");
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(7, "noToken", new Object[]{"Issuer/Serial data element missing"}, e);
        }
        return this.issuerSerial;
    }

    public boolean containsReference() {
        return this.lengthReference() > 0;
    }

    public int lengthReference() {
        return this.length("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference");
    }

    public boolean containsX509IssuerSerial() {
        return this.lengthX509IssuerSerial() > 0;
    }

    public boolean containsX509Data() {
        return this.lengthX509Data() > 0;
    }

    public int lengthX509IssuerSerial() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
    }

    public int lengthX509Data() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public boolean containsKeyIdentifier() {
        return this.lengthKeyIdentifier() > 0;
    }

    public int lengthKeyIdentifier() {
        return this.length("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
    }

    public int length(String namespace, String localname) {
        NodeList childNodes = this.element.getChildNodes();
        int result = 0;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (n.getNodeType() != 1) continue;
            String ns = n.getNamespaceURI();
            String name = n.getLocalName();
            if ((namespace == null || !namespace.equals(ns)) && (namespace != null || ns != null) || !localname.equals(name)) continue;
            ++result;
        }
        return result;
    }

    public Element getElement() {
        return this.element;
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

