/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.NumericPromoter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class PromoteToDouble
extends NumericPromoter {
    public PromoteToDouble(Expression exp) {
        super(exp);
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.DOUBLE;
    }

    public Expression copy() {
        return new PromoteToDouble(this.getBaseExpression().copy());
    }

    protected AtomicValue promote(AtomicValue value, XPathContext context) throws XPathException {
        if (!(value instanceof NumericValue) && !(value instanceof UntypedAtomicValue)) {
            TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
            XPathException err = new XPathException("Cannot promote non-numeric value to " + this.getItemType(th).toString(), "XPTY0004", context);
            err.setLocator(this);
            throw err;
        }
        return value.convert(BuiltInAtomicType.DOUBLE, true, context).asAtomic();
    }
}

