/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.messages;

import amazon.fws.clicommando.Initializer;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public final class ErrorMessages {
    private static ResourceBundle resourceBundle = null;
    private static final String resourceBundleBaseName = "errorMessages";
    public static final String PANIC_MESSAGE = "Command line tool deployment has error, please re deploy";

    public static final String getMessageFormat(ErrorCode errorCode) {
        String retValue = null;
        Locale.setDefault(Initializer.DEFAULT_LOCALE);
        if (resourceBundle == null) {
            ErrorMessages.setLocale(Locale.getDefault());
        }
        try {
            retValue = resourceBundle.getString(errorCode.name());
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("Command line tool deployment has error, please re deploy(" + errorCode.name() + ")");
        }
        return retValue;
    }

    public static final void setLocale(Locale locale) {
        resourceBundle = PropertyResourceBundle.getBundle(resourceBundleBaseName, locale);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorCode {
        UNKNOWN_ERROR_CODE,
        CALL_SUPPORT,
        VALUE_CANT_BE_NULL,
        BAD_CREDENTIALS_IN_FILE,
        FILE_NOT_FOUND,
        MORE_THAN_ONE_STDIN_OPTION,
        CONFLICTING_OPTIONS,
        CANNOT_READ_FILE,
        FILE_TOO_BIG,
        NEGATIVE_VALUE,
        NOT_NUMBER,
        BAD_INPUT,
        INTERNAL_ERROR,
        ILLEGAL_COMMAND,
        ILLEGAL_MAP_KEYS,
        MISSING_MAP_KEYS,
        MALFORMED_URL,
        EMPTY_ARGUMENT_LIST,
        ALREADY_SELECTED,
        ILLEGAL_ARGUMENT_VALUE,
        MISSING_ARGUMENT,
        UNRECOGNIZED_OPTION,
        PARSE_EXCEPTION,
        BAD_REQUEST,
        CONFLICT_IN_RESOURCE,
        THROTTLED_REQUEST,
        UNAUTHORIZED_REQUEST,
        FORBIDDEN_REQUEST,
        SERVICE_NOT_FOUND,
        INTERNAL_SERVICE_ERROR,
        ERROR_REACHING_AWS,
        NO_COMMAND_SPECIFIED,
        SEPARATOR_MUST_BE_SINGLE_CHARACTER,
        NO_SEPARATOR_FOUND_IN_MAP,
        BAD_CREDENTIALS_CANNOT_SIGN,
        ABORTING_COMMAND,
        COMMAND_TIMEOUT,
        PARTIAL_KEY_DEFINITION_PROVIDED,
        TOO_MANY_SECURITY_KEYS_PROVIDES,
        NO_CREDENTIALS_PROVIDED,
        BAD_X509_CERT_IN_FILE,
        BAD_PRIVATE_KEY_IN_FILE,
        UNKNOWN_TARGET_URL,
        UNSUPPORTED_AUTHENTICATION,
        SERVICE_ERROR,
        CANNOT_REDIRECT,
        CANNOT_REDIRECT_USE_GET,
        SSL_NOT_AUTH;

    }
}

