#ifndef VIEWPORT_H
#define VIEWPORT_H

struct ViewPort {
	int left,top;												// screen coordinates for the viewport
	int width, height;									// screen width/height for the viewport

	int virtual_left, virtual_top;			// virtual coordinates
	int virtual_width, virtual_height;	// these are just width << zoom, height << zoom

	byte zoom;	
};

/* viewport.c */
Point MapXYZToViewport(ViewPort *vp, uint x, uint y, uint z);
void AssignWindowViewport(Window *w, int x, int y, 
	int width, int height, uint32 follow_flags, byte zoom);
void SetViewportPosition(Window *w, int x, int y);
ViewPort *IsPtInWindowViewport(Window *w, int x, int y);
Point GetTileBelowCursor();
Point GetTileZoomCenter(bool in);
void UpdateViewportPosition(Window *w);



void OffsetGroundSprite(int x, int y);
void OffsetGroundSpriteEnd();

void DrawGroundSprite(uint32 image);
void DrawGroundSpriteAt(uint32 image, int x, int y, byte z);
void AddSortableSpriteToDraw(uint32 image, int x, int y, int w, int h, byte dz, byte z);
void *AddStringToDraw(int x, int y, StringID string, uint32 params_1, uint32 params_2);
void AddChildSpriteScreen(uint32 image, int x, int y);

void StartSpriteCombine();
void EndSpriteCombine();

void SetSelectionTilesDirty(int x, int y);

void HandleViewportClicked(ViewPort *vp, int x, int y);
void PlaceObject();
void SetRedErrorSquare(TileIndex tile);
void SetTileSelectSize(int w, int h);
void SetTileSelectBigSize(int ox, int oy, int sx, int sy);

void VpStartPlaceSizing(uint tile, int user);
void VpStartPreSizing();
void VpSetPresizeRange(uint from, uint to);

enum {
	VPM_X_OR_Y = 0,
	VPM_FIX_X = 1,
	VPM_FIX_Y = 2,
};

void VpSelectTilesWithMethod(int x, int y, int method);


typedef struct TileHighlightData {
	Point size;
	Point maxsize;
	Point pos;
	Point offs;

	Point to_place_size;
	Point to_place_maxsize;

	Point select_from;
	Point select_to;

	Point last_station_pos;

	byte flags;
	byte place_mode;
	byte window_class;
	bool make_square_red;
	uint16 window_number;

	int userdata;
	TileIndex redsq;
} TileHighlightData;


/* viewport.c */
VARDEF ViewPort _viewports[8];
VARDEF TileHighlightData _thd;

VARDEF Point _tile_fract_coords;

extern TileHighlightData * const _thd_ptr;

enum {
	THD_RECT = 1<<2,
	THD_DOT = 1<<3,
};


#endif
