#include "stdafx.h"
#include "ttd.h"
#include "vehicle.h"
#include "command.h"
#include "station.h"

/* p1 = vehicle
 * p2 & 0xFF = sel
 * p2 >> 8 = station
 */
int32 CmdInsertTrainOrder(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	Vehicle *v = &_vehicles[p1];
	int sel = (byte)p2;
	int t;

	if ((byte)sel > v->num_orders)
		return_cmd_error(STR_0006);

	if (_ptr_to_next_order == endof(_order_array))
		return_cmd_error(STR_8831_NO_MORE_SPACE_FOR_ORDERS);

	if (v->num_orders >= 40)
		return_cmd_error(STR_8832_TOO_MANY_ORDERS);

	if (v->type == VEH_Ship && (v->owner==_human_player_1 || v->owner==_human_player_2) &&
			sel != 0 && ((t=v->schedule_ptr[sel-1])&0x1F) == OT_GOTO_STATION) {
		
		int dist = GetTileDist(DEREF_STATION(t >> 8)->xy, DEREF_STATION(p2 >> 8)->xy);
		if (dist >= 130)
			return_cmd_error(STR_0210_TOO_FAR_FROM_PREVIOUS_DESTINATIO);
	}

	if (flags & DC_EXEC) {
		uint16 *s1, *s2;
		Vehicle *u;

		v->num_orders++;

		s1 = &v->schedule_ptr[sel];
		s2 = _ptr_to_next_order++;

		do {
			s2[1] = s2[0];
		} while (--s2 >= s1);

		if (p2 & 0x10000) {
			s1[0] = (p2 & 0xFF00) | OT_GOTO_DEPOT | OF_UNLOAD;
		} else {
			s1[0] = (p2 & 0xFF00) | OT_GOTO_STATION;
		}
		
		for(u=_vehicles; u != endof(_vehicles); u++) {
			if (u->type != 0 &&
					u->schedule_ptr != NULL &&
					s1 < u->schedule_ptr)
						u->schedule_ptr++;
		}
		
		if ((byte)sel <= v->cur_order_index) {
			sel++;
			if ((byte)sel < v->num_orders)
				v->cur_order_index = sel;
		}

		InvalidateWindow(WC_VEHICLE_VIEW, v->index);
		InvalidateWindow(WC_VEHICLE_ORDERS, v->index);
	}

	return 0;
}

/* p1 = vehicle
 * p2 = sel
 */
int32 CmdDeleteTrainOrder(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	Vehicle *v = &_vehicles[p1], *u;
	uint sel = (uint)p2;

	_error_message = STR_0006;
	if (sel >= v->num_orders)
		return CMD_ERROR;

	if (flags & DC_EXEC) {
		uint16 *s1,*s2;
		
		v->num_orders--;

		s2 = s1 = &v->schedule_ptr[sel];

		do {
			s1[0] = s1[1];
		} while (++s1 != _ptr_to_next_order);
		_ptr_to_next_order--;

		for(u=_vehicles; u!=endof(_vehicles); u++) {
			if (u->type != 0 && u->schedule_ptr != NULL &&
					s2 < u->schedule_ptr)
						u->schedule_ptr--;
		}

		if ((byte)sel == v->cur_order_index && (v->next_order&(OT_MASK|OF_NON_STOP)) == (OT_LOADING|OF_NON_STOP)) {
			v->next_order = OT_LOADING;
		}

		if ((byte)sel < v->cur_order_index)
			v->cur_order_index--;

		InvalidateWindow(WC_VEHICLE_VIEW, v->index);
		InvalidateWindow(WC_VEHICLE_ORDERS, v->index);
	}
	
	return 0;
}

/* p1 = vehicle */
int32 CmdSkipTrainOrder(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	if (flags & DC_EXEC) {
		Vehicle *v = &_vehicles[p1];

		{
			byte b = v->cur_order_index + 1;
			if (b >= v->num_orders) b = 0;
			v->cur_order_index = b;
		}

		if ((v->next_order&(OT_MASK|OF_NON_STOP)) == (OT_LOADING|OF_NON_STOP))
			v->next_order = OT_LOADING;

		InvalidateWindow(WC_VEHICLE_ORDERS, v->index);
	}
	return 0;
}

/* p1 = vehicle
 * p2&0xFF = sel
 * p2>>8 = mode
 */
int32 CmdModifyTrainOrder(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	Vehicle *v = &_vehicles[p1];
	byte sel = (byte)p2;
	uint16 *sched;

	if (sel >= v->num_orders)
		return CMD_ERROR;

	sched = &v->schedule_ptr[sel];
	if (!((*sched & OT_MASK) == OT_GOTO_STATION || 
			((*sched & OT_MASK) == OT_GOTO_DEPOT && (p2>>8) == 2)))
		return CMD_ERROR;

	if (flags & DC_EXEC) {
		switch(p2 >> 8) {
		case 0: // full load
			*sched ^= OF_FULL_LOAD;
			*sched &= ~OF_UNLOAD;
			break;
		case 1: // unload
			*sched ^= OF_UNLOAD;
			*sched &= ~OF_FULL_LOAD;
			break;
		case 2: // non stop
			*sched ^= OF_NON_STOP;
			break;
		}
		InvalidateWindow(WC_VEHICLE_ORDERS, v->index);
	}
	
	return 0;
}

void BackupVehicleOrders(Vehicle *v, uint16 *bak)
{
	uint16 *sched = v->schedule_ptr;
	uint16 ord;
	do {
		ord = *sched++;
		*bak++ = ord;
	} while (ord != 0);
}

void RestoreVehicleOrders(Vehicle *v, uint16 *bak)
{
	uint16 ord;
	int ind = 0;

	while ((ord = *bak++) != 0) {
		if ((ord & OT_MASK) == OT_GOTO_STATION) {
			
			if (DoCommandByTile(0, v->index, ind | (ord & 0xFF00), DC_EXEC, CMD_INSERT_TRAIN_ORDER) == CMD_ERROR)
				break;

			if (ord & OF_NON_STOP)
				DoCommandByTile(0, v->index, ind | 0x200, DC_EXEC, CMD_MODIFY_TRAIN_ORDER);

			if (ord & OF_FULL_LOAD) 
				DoCommandByTile(0, v->index, ind | 0x000, DC_EXEC, CMD_MODIFY_TRAIN_ORDER);

			if (ord & OF_UNLOAD)
				DoCommandByTile(0, v->index, ind | 0x100, DC_EXEC, CMD_MODIFY_TRAIN_ORDER);

		}
		ind++;
	}
}
