/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.components;

import com.l2fprod.common.swing.JButtonBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;

public class EnhancedToolbar
extends JButtonBar {
    private boolean isCyclic;
    private boolean isGroupSelectionFollowFocus;

    public EnhancedToolbar() {
        this.init();
    }

    private void init() {
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new JXButtonPanelFocusTraversalPolicy());
        ActionHandler actionHandler = new ActionHandler();
        this.registerKeyboardAction(actionHandler, "moveSelectionForward", KeyStroke.getKeyStroke(39, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionForward", KeyStroke.getKeyStroke(9, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionBackward", KeyStroke.getKeyStroke(37, 0), 1);
        this.setGroupSelectionFollowFocus(true);
        this.setCyclic(true);
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean bl) {
        this.isCyclic = bl;
    }

    public boolean isGroupSelectionFollowFocus() {
        return this.isGroupSelectionFollowFocus;
    }

    public void setGroupSelectionFollowFocus(boolean bl) {
        this.isGroupSelectionFollowFocus = bl;
    }

    private static ButtonGroup getButtonGroup(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel instanceof DefaultButtonModel) {
            return ((DefaultButtonModel)buttonModel).getGroup();
        }
        return null;
    }

    private class JXButtonPanelFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private boolean isAlternativeFocusMode;

        private JXButtonPanelFocusTraversalPolicy() {
        }

        public boolean isAlternativeFocusMode() {
            return this.isAlternativeFocusMode;
        }

        public void setAlternativeFocusMode(boolean bl) {
            this.isAlternativeFocusMode = bl;
        }

        @Override
        protected boolean accept(Component component) {
            AbstractButton abstractButton;
            ButtonGroup buttonGroup;
            if (!this.isAlternativeFocusMode() && component instanceof AbstractButton && (buttonGroup = EnhancedToolbar.getButtonGroup(abstractButton = (AbstractButton)component)) != null && buttonGroup.getSelection() != null && !abstractButton.isSelected()) {
                return false;
            }
            return super.accept(component);
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            Component component2 = super.getComponentAfter(container, component);
            if (!this.isAlternativeFocusMode()) {
                return component2;
            }
            if (EnhancedToolbar.this.isCyclic()) {
                return component2 == null ? this.getFirstComponent(container) : component2;
            }
            if (component == this.getLastComponent(container)) {
                return component;
            }
            return component2;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            Component component2 = super.getComponentBefore(container, component);
            if (!this.isAlternativeFocusMode()) {
                return component2;
            }
            if (EnhancedToolbar.this.isCyclic()) {
                return component2 == null ? this.getLastComponent(container) : component2;
            }
            if (component == this.getFirstComponent(container)) {
                return component;
            }
            return component2;
        }
    }

    private class ActionHandler
    implements ActionListener {
        private static final String FORWARD = "moveSelectionForward";
        private static final String BACKWARD = "moveSelectionBackward";

        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FocusTraversalPolicy focusTraversalPolicy = EnhancedToolbar.this.getFocusTraversalPolicy();
            if (focusTraversalPolicy instanceof JXButtonPanelFocusTraversalPolicy) {
                Serializable serializable;
                Component component;
                JXButtonPanelFocusTraversalPolicy jXButtonPanelFocusTraversalPolicy = (JXButtonPanelFocusTraversalPolicy)focusTraversalPolicy;
                String string = actionEvent.getActionCommand();
                Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                jXButtonPanelFocusTraversalPolicy.setAlternativeFocusMode(true);
                if (FORWARD.equals(string)) {
                    component = jXButtonPanelFocusTraversalPolicy.getComponentAfter((Container)((Object)EnhancedToolbar.this), component2);
                } else if (BACKWARD.equals(string)) {
                    component = jXButtonPanelFocusTraversalPolicy.getComponentBefore((Container)((Object)EnhancedToolbar.this), component2);
                } else {
                    throw new AssertionError((Object)("Unexpected action command: " + string));
                }
                jXButtonPanelFocusTraversalPolicy.setAlternativeFocusMode(false);
                if (component2 instanceof AbstractButton) {
                    serializable = (AbstractButton)component2;
                    ((AbstractButton)serializable).getModel().setPressed(false);
                }
                if (component != null && component2 instanceof AbstractButton && component instanceof AbstractButton) {
                    AbstractButton abstractButton;
                    serializable = EnhancedToolbar.getButtonGroup((AbstractButton)component2);
                    if (serializable != EnhancedToolbar.getButtonGroup(abstractButton = (AbstractButton)component)) {
                        return;
                    }
                    if (EnhancedToolbar.this.isGroupSelectionFollowFocus() && serializable != null && ((ButtonGroup)serializable).getSelection() != null && !abstractButton.isSelected()) {
                        abstractButton.doClick();
                    }
                    component.requestFocusInWindow();
                }
            }
        }
    }
}

