/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.binding;

import com.jgoodies.binding.value.AbstractValueModel;
import cz.vity.freerapid.core.AppPrefs;
import java.util.prefs.Preferences;

public class MyPreferencesAdapter
extends AbstractValueModel {
    private static final String ERROR_MSG = "Value must be a Boolean, Double, Float, Integer, Long, or String.";
    protected Preferences prefs;
    protected String key;
    protected Class<?> type;
    protected Object defaultValue;

    public MyPreferencesAdapter(String string, Object object) {
        this(AppPrefs.getPreferences(), string, object);
    }

    protected MyPreferencesAdapter() {
    }

    public String getKey() {
        return this.key;
    }

    public MyPreferencesAdapter(Preferences preferences, String string, Object object) {
        if (preferences == null) {
            throw new NullPointerException("The Preferences must not be null.");
        }
        if (string == null) {
            throw new NullPointerException("The key must not be null.");
        }
        if (object == null) {
            throw new NullPointerException("The default value must not be null.");
        }
        if (!this.isBackedType(object)) {
            throw new IllegalArgumentException("The Default Value must be a Boolean, Double, Float, Integer, Long, or String.");
        }
        this.prefs = preferences;
        this.key = string;
        this.type = object.getClass();
        this.defaultValue = object;
    }

    public Object getValue() {
        if (this.type == Boolean.class) {
            return this.getBoolean();
        }
        if (this.type == Double.class) {
            return this.getDouble();
        }
        if (this.type == Float.class) {
            return Float.valueOf(this.getFloat());
        }
        if (this.type == Integer.class) {
            return this.getInt();
        }
        if (this.type == Long.class) {
            return this.getLong();
        }
        if (this.type == String.class) {
            return this.getString();
        }
        throw new ClassCastException(ERROR_MSG);
    }

    public void setValue(Object object) {
        if (object == null) {
            throw new NullPointerException("The value must not be null.");
        }
        if (object instanceof Boolean) {
            this.setBoolean((Boolean)object);
        } else if (object instanceof Double) {
            this.setDouble((Double)object);
        } else if (object instanceof Float) {
            this.setFloat(((Float)object).floatValue());
        } else if (object instanceof Integer) {
            this.setInt((Integer)object);
        } else if (object instanceof Long) {
            this.setLong((Long)object);
        } else if (object instanceof String) {
            this.setString((String)object);
        }
    }

    public boolean getBoolean() {
        return this.prefs.getBoolean(this.key, (Boolean)this.defaultValue);
    }

    public double getDouble() {
        return this.prefs.getDouble(this.key, ((Number)this.defaultValue).doubleValue());
    }

    public float getFloat() {
        return this.prefs.getFloat(this.key, ((Number)this.defaultValue).floatValue());
    }

    public int getInt() {
        return this.prefs.getInt(this.key, ((Number)this.defaultValue).intValue());
    }

    public long getLong() {
        return this.prefs.getLong(this.key, ((Number)this.defaultValue).longValue());
    }

    public String getString() {
        return this.prefs.get(this.key, (String)this.defaultValue);
    }

    public void setBoolean(boolean bl) {
        boolean bl2 = this.getBoolean();
        this.prefs.putBoolean(this.key, bl);
        this.fireValueChange(bl2, bl);
    }

    public void setDouble(double d) {
        double d2 = this.getDouble();
        this.prefs.putDouble(this.key, d);
        this.fireValueChange(d2, d);
    }

    public void setFloat(float f) {
        float f2 = this.getFloat();
        this.prefs.putFloat(this.key, f);
        this.fireValueChange(f2, f);
    }

    public void setInt(int n) {
        int n2 = this.getInt();
        this.prefs.putInt(this.key, n);
        this.fireValueChange(n2, n);
    }

    public void setLong(long l) {
        long l2 = this.getLong();
        this.prefs.putLong(this.key, l);
        this.fireValueChange(l2, l);
    }

    public void setString(String string) {
        String string2 = this.getString();
        this.prefs.put(this.key, string);
        this.fireValueChange(string2, string);
    }

    private boolean isBackedType(Object object) {
        Class<?> clazz = object.getClass();
        return clazz == Boolean.class || clazz == Double.class || clazz == Float.class || clazz == Integer.class || clazz == Long.class || clazz == String.class;
    }
}

