/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;

public final class TextComponentContextMenuListener
implements AWTEventListener {
    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof MouseEvent)) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        if (mouseEvent.getComponent() == null) {
            return;
        }
        Component component = SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        if (!(component instanceof JTextComponent)) {
            return;
        }
        JTextComponent jTextComponent = (JTextComponent)component;
        jTextComponent.grabFocus();
        ApplicationContext applicationContext = Application.getInstance().getContext();
        ApplicationActionMap applicationActionMap = applicationContext.getActionMap();
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(applicationActionMap.get((Object)"cut"));
        jPopupMenu.add(applicationActionMap.get((Object)"copy"));
        jPopupMenu.add(applicationActionMap.get((Object)"paste"));
        jPopupMenu.add(applicationActionMap.get((Object)"delete"));
        jPopupMenu.addSeparator();
        Action action = applicationActionMap.get((Object)"select-all");
        jPopupMenu.add(action);
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), jTextComponent);
        jPopupMenu.show(jTextComponent, point.x, point.y);
    }
}

