/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugimpl;

import cz.vity.freerapid.plugins.webclient.interfaces.ConfigurationStorageSupport;
import cz.vity.freerapid.utilities.LogUtils;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.util.logging.Logger;
import org.jdesktop.application.ApplicationContext;

public class StandardStorageSupportImpl
implements ConfigurationStorageSupport {
    private static final Logger logger = Logger.getLogger(StandardStorageSupportImpl.class.getName());
    private final ApplicationContext context;

    public StandardStorageSupportImpl(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    @Override
    public boolean configFileExists(String string) {
        File file = new File(this.context.getLocalStorage().getDirectory(), string);
        return file.isFile() && file.exists();
    }

    @Override
    public <E> E loadConfigFromFile(String string, Class<E> clazz) throws Exception {
        Object object;
        XMLDecoder xMLDecoder = null;
        try {
            xMLDecoder = new XMLDecoder(this.context.getLocalStorage().openInputFile(string), null, null, clazz.getClassLoader());
            object = xMLDecoder.readObject();
        }
        catch (RuntimeException runtimeException) {
            LogUtils.processException(logger, runtimeException);
            throw new Exception(runtimeException);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            throw exception;
        }
        finally {
            if (xMLDecoder != null) {
                try {
                    xMLDecoder.close();
                }
                catch (Exception exception) {}
            }
        }
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeConfigToFile(Object object, String string) throws Exception {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(object.getClass().getClassLoader());
            XMLEncoder xMLEncoder = null;
            try {
                xMLEncoder = new XMLEncoder(this.context.getLocalStorage().openOutputFile(string));
                xMLEncoder.writeObject(object);
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
                throw exception;
            }
            finally {
                if (xMLEncoder != null) {
                    try {
                        xMLEncoder.close();
                    }
                    catch (Exception exception) {
                        LogUtils.processException(logger, exception);
                    }
                }
            }
        }
        finally {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }
}

