/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.DelayedReadValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.FileTypeIconProvider;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.AppFrame;
import cz.vity.freerapid.gui.managers.FileHistoryItem;
import cz.vity.freerapid.gui.managers.FileHistoryManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.MenuManager;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.SwingXUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.binding.MyPreferencesAdapter;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.OSDesktop;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.DefaultRowSorter;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;
import org.jdesktop.swingx.JXTable;

public class DownloadHistoryDialog
extends AppFrame
implements ClipboardOwner,
ListSelectionListener {
    private static final Logger logger = Logger.getLogger(DownloadHistoryDialog.class.getName());
    private FileHistoryManager manager;
    private static final int COLUMN_DATE = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_DESCRIPTION = 2;
    private static final int COLUMN_SIZE = 3;
    private static final int COLUMN_URL = 4;
    private static final String SELECTED_ACTION_ENABLED_PROPERTY = "selectedEnabled";
    private boolean selectedEnabled;
    private static final String FILE_EXISTS_ENABLED_PROPERTY = "fileExistsEnabled";
    private boolean fileExistsEnabled;
    private final ManagerDirector director;
    private final String exampleSearchString;
    private JComboBox combobox;
    private JTextField fieldFilter;
    private JXTable table;
    private JButton clearHistoryBtn;
    private JButton okButton;

    public DownloadHistoryDialog(Frame frame, ManagerDirector managerDirector) throws HeadlessException {
        super(frame);
        this.director = managerDirector;
        this.manager = managerDirector.getFileHistoryManager();
        this.setName("DonwloadHistoryDialog");
        this.exampleSearchString = this.getResourceMap().getString("exampleSearchString", new Object[0]);
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            this.doClose();
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.okButton;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.okButton;
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.setAction(this.okButton, "okBtnAction");
        this.setAction(this.clearHistoryBtn, "clearHistoryBtnAction");
        this.registerKeyboardAction("openFileAction");
        this.registerKeyboardAction("deleteFileAction");
        this.registerKeyboardAction("openDirectoryAction");
        this.registerKeyboardAction("openInBrowser");
        this.registerKeyboardAction("removeSelectedAction");
        this.registerKeyboardAction("copyContent");
        this.registerKeyboardAction("copyURL");
        this.updateActions();
        this.pack();
        DownloadHistoryDialog.locateOnOpticalScreenCenter(this);
    }

    private void initTable() {
        this.table.setName("historyTable");
        this.table.setModel((TableModel)new CustomTableModel(this.manager.getItems(), this.getList("columns")));
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setEditable(false);
        this.table.setColumnControlVisible(true);
        this.table.setSortable(true);
        this.table.setColumnMargin(10);
        this.table.setRolloverEnabled(true);
        if (!AppPrefs.getProperty("historySlimLines", false)) {
            this.table.setRowHeight(36);
        }
        this.table.setShowGrid(true, false);
        this.table.setColumnSelectionAllowed(false);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.createDefaultColumnsFromModel();
        Swinger.updateColumn((JTable)this.table, "Date", 0, -1, 40, new DateCellRenderer(this.getResourceMap()));
        Swinger.updateColumn((JTable)this.table, "Name", 1, -1, 150, new FileNameCellRenderer(this.director.getFileTypeIconProvider()));
        Swinger.updateColumn((JTable)this.table, "Description", 2, -1, 170, new DescriptionCellRenderer());
        Swinger.updateColumn((JTable)this.table, "Size", 3, -1, 40, new SizeCellRenderer());
        Swinger.updateColumn((JTable)this.table, "URL", 4, -1, -1, SwingXUtils.getHyperLinkTableCellRenderer());
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!DownloadHistoryDialog.this.table.hasFocus()) {
                    Swinger.inputFocus((JComponent)DownloadHistoryDialog.this.table);
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    DownloadHistoryDialog.this.showPopMenu(mouseEvent);
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() >= 2) {
                    DownloadHistoryDialog.this.openFileAction();
                }
            }
        });
        InputMap inputMap = this.table.getInputMap();
        ActionMap actionMap = this.table.getActionMap();
        ActionMap actionMap2 = this.getActionMap();
        inputMap.put(SwingUtils.getCtrlKeyStroke(67), "copy");
        actionMap.put("copy", actionMap2.get("copyContent"));
        inputMap.put(SwingUtils.getShiftKeyStroke(127), "deleteFileAction");
        actionMap.put("deleteFileAction", actionMap2.get("deleteFileAction"));
        inputMap.put(SwingUtils.getCtrlKeyStroke(10), "openDirectoryAction");
        actionMap.put("openDirectoryAction", actionMap2.get("openDirectoryAction"));
        KeyStroke keyStroke = SwingUtils.getCtrlKeyStroke(70);
        inputMap.put(keyStroke, "getFocusFind");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Swinger.inputFocus(DownloadHistoryDialog.this.fieldFilter);
            }
        };
        actionMap.put("getFocusFind", abstractAction);
        this.table.getParent().setPreferredSize(new Dimension(600, 400));
        inputMap.put(SwingUtils.getShiftKeyStroke(36), "selectFirstRowExtendSelection");
        inputMap.put(SwingUtils.getShiftKeyStroke(35), "selectLastRowExtendSelection");
        this.registerKeyboardAction(abstractAction, keyStroke);
    }

    @Action(enabledProperty="selectedEnabled")
    public void copyContent() {
        int[] nArray = this.getSelectedRows();
        TableModel tableModel = this.table.getModel();
        int n = this.table.convertColumnIndexToModel(this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex());
        StringBuilder stringBuilder = new StringBuilder();
        for (int n2 : nArray) {
            String string;
            if (n == 0) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis((Long)tableModel.getValueAt(n2, n));
                string = String.format("%1$tm %1$tB,%1$tY", calendar);
            } else {
                string = tableModel.getValueAt(n2, n).toString();
            }
            stringBuilder.append(string).append('\n');
        }
        SwingUtils.copyToClipboard(stringBuilder.toString().trim(), this);
    }

    @Action
    public void copyURL() {
        List<FileHistoryItem> list = this.manager.getSelectionToList(this.getSelectedRows());
        StringBuilder stringBuilder = new StringBuilder();
        for (FileHistoryItem fileHistoryItem : list) {
            stringBuilder.append(fileHistoryItem.getUrl().toExternalForm()).append('\n');
        }
        SwingUtils.copyToClipboard(stringBuilder.toString().trim(), this);
    }

    @Action(enabledProperty="fileExistsEnabled")
    public void openFileAction() {
        int[] nArray = this.getSelectedRows();
        List<FileHistoryItem> list = this.manager.getSelectionToList(nArray);
        for (FileHistoryItem fileHistoryItem : list) {
            OSDesktop.openFile(fileHistoryItem.getOutputFile());
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void openInBrowser() {
        List<FileHistoryItem> list = this.manager.getSelectionToList(this.getSelectedRows());
        for (FileHistoryItem fileHistoryItem : list) {
            Browser.openBrowser(fileHistoryItem.getUrl().toExternalForm());
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void openDirectoryAction() {
        int[] nArray = this.getSelectedRows();
        List<FileHistoryItem> list = this.manager.getSelectionToList(nArray);
        for (FileHistoryItem fileHistoryItem : list) {
            OSDesktop.openDirectoryForFile(fileHistoryItem.getOutputFile());
        }
    }

    @Action
    public void cancelBtnAction() {
        this.doClose();
    }

    @Override
    public void doClose() {
        if (AppPrefs.getProperty("containDownloadsFilter", this.exampleSearchString).equals(this.exampleSearchString)) {
            AppPrefs.storeProperty("containDownloadsFilter", "");
        }
        super.doClose();
    }

    private void buildGUI() {
        this.initTable();
        if (AppPrefs.getProperty("containDownloadsFilter", "").equals("Search...")) {
            AppPrefs.storeProperty("containDownloadsFilter", "");
        }
        if ("".equals(AppPrefs.getProperty("containDownloadsFilter", ""))) {
            AppPrefs.storeProperty("containDownloadsFilter", this.exampleSearchString);
        }
        MyPreferencesAdapter myPreferencesAdapter = new MyPreferencesAdapter("containDownloadsFilter", "");
        DelayedReadValueModel delayedReadValueModel = new DelayedReadValueModel((ValueModel)myPreferencesAdapter, 300, true);
        delayedReadValueModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DownloadHistoryDialog.this.updateFilters();
            }
        });
        this.fieldFilter.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (DownloadHistoryDialog.this.exampleSearchString.equals(DownloadHistoryDialog.this.fieldFilter.getText())) {
                    DownloadHistoryDialog.this.fieldFilter.setForeground(Color.BLACK);
                    DownloadHistoryDialog.this.fieldFilter.setText("");
                } else {
                    DownloadHistoryDialog.this.fieldFilter.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (DownloadHistoryDialog.this.fieldFilter.getText().isEmpty()) {
                    DownloadHistoryDialog.this.fieldFilter.setForeground(Color.GRAY);
                    DownloadHistoryDialog.this.fieldFilter.setText(DownloadHistoryDialog.this.exampleSearchString);
                }
            }
        });
        this.fieldFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (27 == n) {
                    if (!"".equals(DownloadHistoryDialog.this.fieldFilter.getText())) {
                        DownloadHistoryDialog.this.fieldFilter.setText("");
                        keyEvent.consume();
                    }
                } else if (10 == n || 40 == n) {
                    if (DownloadHistoryDialog.this.getSelectedRows().length == 0 && DownloadHistoryDialog.this.table.getRowCount() > 0) {
                        DownloadHistoryDialog.this.table.setRowSelectionInterval(0, 0);
                    }
                    Swinger.inputFocus((JComponent)DownloadHistoryDialog.this.table);
                    keyEvent.consume();
                }
            }
        });
        Bindings.bind((JTextField)this.fieldFilter, (ValueModel)delayedReadValueModel);
        this.bindCombobox(this.combobox, "selectedDownloadsFilter", (Object)DownloadsFilters.ALL_DOWNLOADS.ordinal(), "datesFilter");
        this.combobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DownloadHistoryDialog.this.updateFilters();
            }
        });
        if (!this.exampleSearchString.equals(this.fieldFilter.getText())) {
            this.fieldFilter.setForeground(Color.BLACK);
        } else {
            this.fieldFilter.setForeground(Color.GRAY);
        }
        this.updateFilters();
        Swinger.inputFocus((JComponent)this.table);
    }

    @Action
    public void okBtnAction() {
        this.doClose();
    }

    private int[] getSelectedRows() {
        return Swinger.getSelectedRows((JTable)this.table);
    }

    private void bindCombobox(JComboBox jComboBox, String string, Object object, String string2) {
        String[] stringArray = this.getList(string2);
        if (stringArray == null) {
            throw new IllegalArgumentException("Property '" + string2 + "' does not provide any string list from resource map.");
        }
        this.bindCombobox(jComboBox, string, object, stringArray);
    }

    private void bindCombobox(JComboBox jComboBox, String string, Object object, String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("List of combobox values cannot be null!!");
        }
        MyPreferencesAdapter myPreferencesAdapter = new MyPreferencesAdapter(string, object);
        SelectionInList selectionInList = new SelectionInList((Object[])stringArray, (ValueModel)new ValueHolder((Object)stringArray[(Integer)myPreferencesAdapter.getValue()]), (ValueModel)myPreferencesAdapter);
        Bindings.bind((JComboBox)jComboBox, (SelectionInList)selectionInList);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.combobox = new JComboBox();
        JLabel jLabel = new JLabel();
        this.fieldFilter = new JTextField();
        JScrollPane jScrollPane = new JScrollPane();
        this.table = new JXTable();
        JXButtonPanel jXButtonPanel = new JXButtonPanel();
        this.clearHistoryBtn = new JButton();
        this.okButton = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        jPanel.setBorder(Borders.DIALOG_BORDER);
        jPanel.setLayout(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(""));
        jLabel.setName("labelFilter");
        jLabel.setLabelFor(this.fieldFilter);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec("max(pref;80dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)100)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")), jPanel3);
        panelBuilder.add((Component)this.combobox, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.fieldFilter, cellConstraints.xy(5, 1));
        jScrollPane.setViewportView((Component)this.table);
        panelBuilder = new PanelBuilder(new FormLayout(ColumnSpec.decodeSpecs((String)"default:grow"), new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}), jPanel2);
        panelBuilder.add((Component)jPanel3, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jScrollPane, cellConstraints.xy(1, 3));
        jPanel.add((Component)jPanel2, "Center");
        jXButtonPanel.setBorder((Border)new EmptyBorder(12, 0, 0, 0));
        this.clearHistoryBtn.setName("clearHistoryBtn");
        this.okButton.setName("okButton");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec("max(pref;55dlu)")}, RowSpec.decodeSpecs((String)"fill:pref")), (JPanel)jXButtonPanel);
        panelBuilder.add((Component)this.clearHistoryBtn, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.okButton, cellConstraints.xy(5, 1));
        jPanel.add((Component)jXButtonPanel, "South");
        container.add((Component)jPanel, "Center");
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.updateActions();
    }

    private void updateActions() {
        int[] nArray = this.getSelectedRows();
        this.setSelectedEnabled(nArray.length > 0);
        boolean bl = true;
        List<FileHistoryItem> list = this.manager.getSelectionToList(nArray);
        for (FileHistoryItem fileHistoryItem : list) {
            if (fileHistoryItem.getOutputFile().exists()) continue;
            bl = false;
            break;
        }
        this.setFileExistsEnabled(bl);
    }

    public boolean isSelectedEnabled() {
        return this.selectedEnabled;
    }

    public void setSelectedEnabled(boolean bl) {
        boolean bl2 = this.selectedEnabled;
        this.selectedEnabled = bl;
        this.firePropertyChange(SELECTED_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isFileExistsEnabled() {
        return this.fileExistsEnabled;
    }

    public void setFileExistsEnabled(boolean bl) {
        boolean bl2 = this.fileExistsEnabled;
        this.fileExistsEnabled = bl;
        this.firePropertyChange(FILE_EXISTS_ENABLED_PROPERTY, bl2, bl);
    }

    @Action(enabledProperty="selectedEnabled")
    public void deleteFileAction() {
        int n;
        boolean bl;
        int[] nArray = this.getSelectedRows();
        List<FileHistoryItem> list = this.manager.getSelectionToList(nArray);
        String string = this.getFileList(list);
        boolean bl2 = AppPrefs.getProperty("confirmFileDelete", true);
        if (string.isEmpty() || !bl2) {
            bl = false;
            n = 0;
        } else {
            bl = true;
            n = Swinger.getChoiceOKCancel("message.areyousuredelete", string);
        }
        if (n == 0) {
            for (FileHistoryItem fileHistoryItem : list) {
                File file = fileHistoryItem.getOutputFile();
                if (file == null) continue;
                FileUtils.deleteFileWithRecycleBin(file);
            }
            this.removeSelected(nArray, bl);
            this.selectFirstIfNoSelection();
        }
    }

    private String getFileList(List<FileHistoryItem> list) {
        ArrayList<FileHistoryItem> arrayList = new ArrayList<FileHistoryItem>();
        for (FileHistoryItem fileHistoryItem : list) {
            if (fileHistoryItem.getOutputFile() == null || !fileHistoryItem.getOutputFile().exists()) continue;
            arrayList.add(fileHistoryItem);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = Math.min(arrayList.size(), 20);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('\n').append(Utils.shortenFileName(((FileHistoryItem)arrayList.get(i)).getOutputFile()));
        }
        if (arrayList.size() > 20) {
            stringBuilder.append('\n').append(this.getResourceMap().getString("andOtherFiles", new Object[]{arrayList.size() - 20}));
        }
        return stringBuilder.toString();
    }

    private void removeSelected(int[] nArray, boolean bl) {
        int n;
        boolean bl2;
        if (!bl && (bl2 = AppPrefs.getProperty("confirmRemove", true)) && (n = Swinger.getChoiceOKCancel("areYouSureYouWantToRemove", new Object[0])) != 0) {
            return;
        }
        final ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        this.manager.removeSelected(nArray);
        listSelectionModel.setValueIsAdjusting(false);
        n = this.getArrayMin(nArray);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n3 = DownloadHistoryDialog.this.table.getRowCount();
                if (DownloadHistoryDialog.this.table.getRowCount() > 0) {
                    int n2 = Math.min(n3 - 1, n);
                    n2 = DownloadHistoryDialog.this.table.convertRowIndexToView(n2);
                    listSelectionModel.addSelectionInterval(n2, n2);
                    DownloadHistoryDialog.this.scrollToVisible(true);
                }
            }
        });
    }

    private void scrollToVisible(boolean bl) {
        int[] nArray = this.table.getSelectedRows();
        int n = nArray.length;
        if (n > 0) {
            this.table.scrollRowToVisible(bl ? nArray[0] : nArray[n - 1]);
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void removeSelectedAction() {
        int[] nArray = this.getSelectedRows();
        this.removeSelected(nArray, false);
    }

    private void selectFirstIfNoSelection() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0 && this.getVisibleRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private int getVisibleRowCount() {
        return this.table.getRowSorter().getViewRowCount();
    }

    private int getArrayMin(int[] nArray) {
        int n = Integer.MAX_VALUE;
        for (int n2 : nArray) {
            if (n <= n2) continue;
            n = n2;
        }
        return n;
    }

    private void showPopMenu(MouseEvent mouseEvent) {
        int[] nArray = this.getSelectedRows();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n != -1) {
            if (nArray.length <= 0) {
                if (this.getVisibleRowCount() > 0) {
                    listSelectionModel.setSelectionInterval(n, n);
                }
            } else {
                Arrays.sort(nArray);
                if (Arrays.binarySearch(nArray, this.table.convertRowIndexToModel(n)) < 0) {
                    listSelectionModel.setValueIsAdjusting(true);
                    this.table.clearSelection();
                    listSelectionModel.setSelectionInterval(n, n);
                    listSelectionModel.setValueIsAdjusting(false);
                }
            }
        } else {
            this.table.clearSelection();
        }
        MenuManager menuManager = this.director.getMenuManager();
        JPopupMenu jPopupMenu = new JPopupMenu();
        Object[] objectArray = new Object[]{"openFileAction", "deleteFileAction", "openDirectoryAction", "---", "copyContent", "---", "copyURL", "openInBrowser", "---", "removeSelectedAction"};
        menuManager.processMenu(jPopupMenu, "popup", this.getActionMap(), objectArray);
        SwingUtils.showPopMenu(jPopupMenu, mouseEvent, (Component)this.table, this);
    }

    @Action
    public void clearHistoryBtnAction() {
        if (Swinger.getChoiceYesNo(this.getApp().getContext().getResourceMap().getString("confirmClearHistory", new Object[0])) == 0) {
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            listSelectionModel.setValueIsAdjusting(true);
            this.manager.clearHistory();
            listSelectionModel.setValueIsAdjusting(false);
        }
    }

    private void updateFilters() {
        String string = this.fieldFilter.getText();
        if (this.exampleSearchString.equals(string)) {
            string = "";
        }
        int n = this.combobox.getSelectedIndex();
        RowFilter rowFilter = null;
        DownloadsFilters downloadsFilters = n == -1 ? DownloadsFilters.ALL_DOWNLOADS : DownloadsFilters.values()[n];
        if (downloadsFilters != DownloadsFilters.ALL_DOWNLOADS) {
            rowFilter = new DateTimeFilter(downloadsFilters);
        }
        if (!string.isEmpty()) {
            RowFilter rowFilter2 = RowFilter.regexFilter("(?i)" + Pattern.quote(string), new int[0]);
            if (rowFilter != null) {
                ArrayList arrayList = new ArrayList(2);
                arrayList.add(rowFilter);
                arrayList.add(rowFilter2);
                rowFilter = RowFilter.andFilter(arrayList);
            } else {
                rowFilter = rowFilter2;
            }
        }
        ((DefaultRowSorter)this.table.getRowSorter()).setRowFilter(rowFilter);
    }

    private static enum DownloadsFilters {
        ALL_DOWNLOADS,
        TODAY,
        YESTERDAY,
        LAST_WEEK,
        LAST_MONTH,
        THIS_CALENDAR_MONTH;

    }

    private static class SizeCellRenderer
    extends DefaultTableCellRenderer {
        private SizeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            FileHistoryItem fileHistoryItem = (FileHistoryItem)jTable.getValueAt(n, -1);
            long l = fileHistoryItem.getFileSize();
            if (l == -1L) {
                object = "";
                this.setToolTipText(null);
            } else {
                object = ContentPanel.bytesToAnother(l);
                this.setToolTipText(NumberFormat.getIntegerInstance().format(l) + " B");
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private static class DescriptionCellRenderer
    extends DefaultTableCellRenderer {
        private String tooltip = Swinger.getResourceMap().getString("tooltip", new Object[0]);

        private DescriptionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                object = jTable.getValueAt(n, n2);
            }
            if (object != null) {
                if (!((String)object).isEmpty()) {
                    this.setToolTipText(String.format(this.tooltip, object));
                    object = "<html>" + object + "</html>";
                } else {
                    this.setToolTipText(null);
                }
            } else {
                this.setToolTipText(null);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private static class FileNameCellRenderer
    extends DefaultTableCellRenderer {
        private final FileTypeIconProvider iconProvider;
        private final boolean bigIcon;

        public FileNameCellRenderer(FileTypeIconProvider fileTypeIconProvider) {
            this.iconProvider = fileTypeIconProvider;
            this.bigIcon = !AppPrefs.getProperty("historySlimLines", false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            FileHistoryItem fileHistoryItem = (FileHistoryItem)jTable.getValueAt(n, -1);
            String string = (String)object;
            String string2 = fileHistoryItem.getUrl().toExternalForm();
            object = string != null && !string.isEmpty() ? String.format("<html><b>%s</b></html>", string) : string2;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null) {
                this.setToolTipText(string2);
                this.setIconTextGap(6);
                this.setIcon(this.iconProvider.getIconImageByFileType(fileHistoryItem.getFileType(), this.bigIcon));
            }
            return this;
        }
    }

    private static class DateCellRenderer
    extends DefaultTableCellRenderer {
        private String yesterday;

        private DateCellRenderer(ResourceMap resourceMap) {
            this.yesterday = resourceMap.getString("yesterday", new Object[0]);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                object = jTable.getValueAt(n, n2);
            }
            object = this.millisToString((Long)object);
            this.setHorizontalAlignment(0);
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        private String millisToString(long l) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.set(11, 0);
            calendar2.set(12, 0);
            calendar2.set(13, 1);
            if (calendar.after(calendar2)) {
                return String.format("%tH:%tM", l, l);
            }
            calendar2.add(5, -1);
            if (calendar.after(calendar2)) {
                return this.yesterday;
            }
            calendar2.add(5, -6);
            if (calendar.after(calendar2)) {
                return String.format("%tA", l);
            }
            return String.format("%1$tB %1$te", l);
        }
    }

    private static class DateTimeFilter
    extends RowFilter<Object, Object> {
        private final DownloadsFilters filter;

        private DateTimeFilter(DownloadsFilters downloadsFilters) {
            this.filter = downloadsFilters;
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            Long l = (Long)entry.getValue(0);
            if (l == null) {
                return false;
            }
            if (this.filter == DownloadsFilters.ALL_DOWNLOADS) {
                return true;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 1);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTimeInMillis(l);
            switch (this.filter) {
                case TODAY: {
                    if (!calendar2.after(calendar)) break;
                    return true;
                }
                case YESTERDAY: {
                    Calendar calendar3 = Calendar.getInstance();
                    calendar3.add(5, -1);
                    calendar3.set(11, 0);
                    calendar3.set(12, 0);
                    calendar3.set(13, 1);
                    if (!calendar2.after(calendar3) || !calendar2.before(calendar)) break;
                    return true;
                }
                case LAST_WEEK: {
                    Calendar calendar4 = Calendar.getInstance();
                    calendar4.set(11, 0);
                    calendar4.set(12, 0);
                    calendar4.set(13, 1);
                    calendar4.add(5, -7);
                    if (!calendar2.after(calendar4)) break;
                    return true;
                }
                case LAST_MONTH: {
                    Calendar calendar5 = Calendar.getInstance();
                    calendar5.set(11, 0);
                    calendar5.set(12, 0);
                    calendar5.set(13, 1);
                    calendar5.add(5, -31);
                    if (!calendar2.after(calendar5)) break;
                    return true;
                }
                case THIS_CALENDAR_MONTH: {
                    calendar.set(5, 1);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 1);
                    if (!calendar2.after(calendar)) break;
                    return true;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return false;
        }
    }

    private static class CustomTableModel
    extends AbstractTableModel
    implements ListDataListener {
        private final ArrayListModel<FileHistoryItem> model;
        private final String[] columns;

        public CustomTableModel(ArrayListModel<FileHistoryItem> arrayListModel, String[] stringArray) {
            this.model = arrayListModel;
            this.columns = stringArray;
            arrayListModel.addListDataListener((ListDataListener)this);
        }

        @Override
        public int getRowCount() {
            return this.model.getSize();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            FileHistoryItem fileHistoryItem = (FileHistoryItem)this.model.get(n);
            switch (n2) {
                case 0: {
                    return fileHistoryItem.getFinishedTime();
                }
                case 1: {
                    return fileHistoryItem.getFileName();
                }
                case 2: {
                    return fileHistoryItem.getDescription();
                }
                case 3: {
                    return fileHistoryItem.getFileSize();
                }
                case 4: {
                    return SwingXUtils.createLink(fileHistoryItem.getUrl());
                }
                case -1: {
                    return fileHistoryItem;
                }
            }
            assert (false);
            return fileHistoryItem;
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireTableRowsInserted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireTableRowsDeleted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireTableRowsUpdated(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }
    }
}

