/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugimpl.StandardDialogSupportImpl;
import cz.vity.freerapid.plugins.container.ContainerException;
import cz.vity.freerapid.plugins.container.ContainerPlugin;
import cz.vity.freerapid.plugins.container.FileInfo;
import cz.vity.freerapid.plugins.exceptions.ServiceConnectionProblemException;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jdesktop.application.Application;

public class ExportLinksTask
extends CoreTask<Void, Void> {
    private static final Logger logger = Logger.getLogger(ExportLinksTask.class.getName());
    private final MainApp app;
    private final ContainerPlugin plugin;
    private final List<DownloadFile> fileList;
    private final File destination;

    public ExportLinksTask(MainApp mainApp, ContainerPlugin containerPlugin, List<DownloadFile> list, File file) {
        super((Application)mainApp);
        this.app = mainApp;
        this.plugin = containerPlugin;
        this.fileList = list;
        this.destination = file;
        this.setTaskToForeground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground() throws Exception {
        OutputStream outputStream = null;
        try {
            List<ConnectionSettings> list = this.app.getManagerDirector().getClientManager().getAvailableConnections();
            this.plugin.setConnectionSettings(list.isEmpty() ? null : list.get(0));
            this.plugin.setDialogSupport(new StandardDialogSupportImpl(this.app.getContext()));
            this.message("exportingLinks", new Object[]{Utils.shortenFileName(this.destination)});
            ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>(this.fileList.size());
            for (DownloadFile downloadFile : this.fileList) {
                arrayList.add(downloadFile.toFileInfo());
            }
            outputStream = new FileOutputStream(this.destination);
            this.plugin.write(arrayList, outputStream, this.destination.toString());
            Iterator<DownloadFile> iterator = null;
            return iterator;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    LogUtils.processException(logger, exception);
                }
            }
        }
    }

    @Override
    protected void failed(Throwable throwable) {
        LogUtils.processException(logger, throwable);
        if (throwable instanceof ContainerException) {
            Swinger.showErrorMessage(this.getResourceMap(), throwable.getMessage(), new Object[0]);
        } else if (throwable instanceof ServiceConnectionProblemException) {
            if ("noAvailableConnection".equals(throwable.getMessage())) {
                Swinger.showErrorMessage(this.getResourceMap(), "noAvailableConnection", new Object[0]);
            } else {
                Swinger.showErrorMessage(this.getResourceMap(), "connectionProblem", Utils.getThrowableDescription(throwable));
            }
        } else if (throwable instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), "otherProblem", Utils.getThrowableDescription(throwable));
        }
    }

    protected void succeeded(Void void_) {
        Swinger.showInformationDialog(this.getResourceMap().getString("successfullyExported", new Object[]{Utils.shortenFileName(this.destination, 60)}));
    }
}

