/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import java.text.Collator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class SupportedLanguage
implements Comparable<SupportedLanguage> {
    private final String languageCode;
    private final String name;
    private final String icon;
    private final String country;
    private final Map<String, String> flags = new HashMap<String, String>(2);

    public SupportedLanguage(String string, String string2, String string3, String string4) {
        this.languageCode = string;
        this.name = string2;
        this.icon = string3;
        this.country = string4;
    }

    public SupportedLanguage(String string, String string2) {
        this(string, "", null, string2);
    }

    public final String getLanguageCode() {
        return this.languageCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SupportedLanguage supportedLanguage = (SupportedLanguage)object;
        return this.country.equalsIgnoreCase(supportedLanguage.country) && this.languageCode.equalsIgnoreCase(supportedLanguage.languageCode);
    }

    public int hashCode() {
        int n = this.languageCode.hashCode();
        n = 31 * n + this.country.hashCode();
        return n;
    }

    @Override
    public int compareTo(SupportedLanguage supportedLanguage) {
        return Collator.getInstance().compare(this.getName(), supportedLanguage.getName());
    }

    public final String getName() {
        return this.name;
    }

    public final String getIcon() {
        String string = Locale.getDefault().getCountry();
        if (this.flags.containsKey(string)) {
            return this.flags.get(string);
        }
        return this.icon;
    }

    public String getCountry() {
        return this.country;
    }

    public String toString() {
        return this.getLanguageCode();
    }

    public void setFlags(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("\\|")) {
            if (string2.trim().isEmpty()) continue;
            String[] stringArray2 = string2.split("=");
            for (int i = 0; i < stringArray2.length; i += 2) {
                this.flags.put(stringArray2[i], stringArray2[i + 1]);
            }
        }
    }
}

