/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public class FileTypeIconProvider {
    private ResourceMap map;
    private static final Logger logger = Logger.getLogger(FileTypeIconProvider.class.getName());
    private static Pattern pattern;
    private static Pattern fileNamePattern;
    private static Pattern encoded;
    private final Map<String, Icon> systemLargeIcons = new Hashtable<String, Icon>();
    private final Map<String, Icon> systemSmallIcons = new Hashtable<String, Icon>();

    public FileTypeIconProvider(ApplicationContext applicationContext) {
        this.map = applicationContext.getResourceMap();
        String[] stringArray = (String[])this.map.getObject("fileTypes", String[].class);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(\\.|_)(");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            stringBuilder.append(string);
            if (i == stringArray.length - 1) continue;
            stringBuilder.append("|");
        }
        stringBuilder.append(")(\\.?|_?|$)");
        String string = stringBuilder.toString();
        logger.info("Regexp " + string);
        pattern = Pattern.compile(string);
    }

    public static String identifyFileType(String string) {
        if (pattern == null) {
            throw new IllegalStateException("Not initialized yet");
        }
        if (string == null) {
            return "";
        }
        Matcher matcher = pattern.matcher(string = string.toLowerCase());
        String string2 = matcher.find() ? matcher.group(2) : "";
        return string2;
    }

    public static String identifyFileName(String string) {
        Matcher matcher = fileNamePattern.matcher(string);
        if (matcher.find()) {
            return FileTypeIconProvider.checkEncodedFileName(matcher.group(1));
        }
        String[] stringArray = string.split("/");
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string2 = stringArray[i].trim();
            if (string2.isEmpty()) continue;
            return string2;
        }
        String string3 = string.replaceAll("\\:", "_").trim();
        if (string3.startsWith("?")) {
            string3 = string3.substring(1);
        }
        if (string3.isEmpty()) {
            return "?";
        }
        return FileTypeIconProvider.checkEncodedFileName(string3);
    }

    public Icon getIconImageByFileType(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (AppPrefs.getProperty("useSystemIcons", true)) {
            string = string.toLowerCase();
            if (bl) {
                return this.getBigSystemIcon(string);
            }
            return this.getSmallSystemIcon(string);
        }
        string = string.toUpperCase(Locale.ENGLISH);
        String string2 = bl ? "iconFileTypeBig_" + string : "iconFileTypeSmall_" + string;
        if (this.map.containsKey(string2)) {
            return this.map.getImageIcon(string2);
        }
        if (bl) {
            return this.map.getImageIcon("iconFileTypeBig_ISO");
        }
        return this.map.getImageIcon("iconFileTypeSmall_ISO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getSmallSystemIcon(String string) {
        Icon icon;
        if (this.systemSmallIcons.containsKey(string)) {
            return this.systemSmallIcons.get(string);
        }
        File file = null;
        try {
            file = File.createTempFile("icon", "." + string);
            if (file == null) {
                throw new IOException("Creation TMP file failed");
            }
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            icon = fileSystemView.getSystemIcon(file);
            if (icon == null) {
                ImageIcon imageIcon = this.map.getImageIcon("iconFileTypeSmall_UNKNOWN");
                this.systemSmallIcons.put(string, imageIcon);
                ImageIcon imageIcon2 = imageIcon;
                return imageIcon2;
            }
            this.systemSmallIcons.put(string, icon);
            Icon icon2 = icon;
            return icon2;
        }
        catch (IOException iOException) {
            icon = this.map.getImageIcon("iconFileTypeSmall_UNKNOWN");
            return icon;
        }
        catch (NullPointerException nullPointerException) {
            icon = this.map.getImageIcon("iconFileTypeSmall_UNKNOWN");
            return icon;
        }
        catch (ClassFormatError classFormatError) {
            icon = this.map.getImageIcon("iconFileTypeSmall_UNKNOWN");
            return icon;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getBigSystemIcon(String string) {
        if (this.systemLargeIcons.containsKey(string)) {
            return this.systemLargeIcons.get(string);
        }
        File file = null;
        try {
            file = File.createTempFile("icon", "." + string);
            Image image = FileTypeIconProvider.getShellFolderIcon(file);
            if (image == null) {
                ImageIcon imageIcon = this.map.getImageIcon("iconFileTypeBig_UNKNOWN");
                this.systemLargeIcons.put(string, imageIcon);
                ImageIcon imageIcon2 = imageIcon;
                return imageIcon2;
            }
            ImageIcon imageIcon = new ImageIcon(image);
            this.systemLargeIcons.put(string, imageIcon);
            ImageIcon imageIcon3 = imageIcon;
            return imageIcon3;
        }
        catch (IOException iOException) {
            ImageIcon imageIcon = this.map.getImageIcon("iconFileTypeBig_UNKNOWN");
            return imageIcon;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    private static Image getShellFolderIcon(File file) {
        try {
            Method method = Class.forName("sun.awt.shell.ShellFolder").getMethod("getShellFolder", File.class);
            Object object = method.invoke(null, file);
            Method method2 = object.getClass().getMethod("getIcon", Boolean.TYPE);
            method2.setAccessible(true);
            Object object2 = method2.invoke(object, true);
            return (Image)object2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String checkEncodedFileName(String string) {
        if (encoded.matcher(string).find()) {
            return Utils.urlDecode(string);
        }
        return string;
    }

    static {
        fileNamePattern = Pattern.compile("\\/([^/]*?\\.(zip|rar|avi|wmv|mp3))\\.html?", 10);
        encoded = Pattern.compile("%[A-Z0-9]{2}%");
    }
}

