/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.LayoutMap;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.util.FormUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FormSpecParser {
    private static final Pattern MULTIPLIER_PREFIX_PATTERN = Pattern.compile("\\d+\\s*\\*\\s*\\(");
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d+");
    private final String source;
    private final LayoutMap layoutMap;

    private FormSpecParser(String string, String string2, LayoutMap layoutMap, boolean bl) {
        FormUtils.assertNotNull(string, string2);
        FormUtils.assertNotNull(layoutMap, "LayoutMap");
        this.layoutMap = layoutMap;
        this.source = this.layoutMap.expand(string, bl);
    }

    static ColumnSpec[] parseColumnSpecs(String string, LayoutMap layoutMap) {
        FormSpecParser formSpecParser = new FormSpecParser(string, "encoded column specifications", layoutMap, true);
        return formSpecParser.parseColumnSpecs();
    }

    static RowSpec[] parseRowSpecs(String string, LayoutMap layoutMap) {
        FormSpecParser formSpecParser = new FormSpecParser(string, "encoded column specifications", layoutMap, false);
        return formSpecParser.parseRowSpecs();
    }

    private ColumnSpec[] parseColumnSpecs() {
        List list = this.split(this.source, 0);
        int n = list.size();
        ColumnSpec[] columnSpecArray = new ColumnSpec[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            columnSpecArray[i] = ColumnSpec.decodeExpanded(string);
        }
        return columnSpecArray;
    }

    private RowSpec[] parseRowSpecs() {
        List list = this.split(this.source, 0);
        int n = list.size();
        RowSpec[] rowSpecArray = new RowSpec[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            rowSpecArray[i] = RowSpec.decodeExpanded(string);
        }
        return rowSpecArray;
    }

    private List split(String string, int n) {
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        boolean bl = true;
        for (int i = 0; i < n4; ++i) {
            char c = string.charAt(i);
            if (bl && Character.isWhitespace(c)) {
                ++n5;
                continue;
            }
            bl = false;
            if (c == ',' && n2 == 0 && n3 == 0) {
                String string2 = string.substring(n5, i);
                this.addSpec(arrayList, string2, n + n5);
                n5 = i + 1;
                bl = true;
                continue;
            }
            if (c == '(') {
                if (n3 > 0) {
                    this.fail(n + i, "illegal '(' in [...]");
                }
                ++n2;
                continue;
            }
            if (c == ')') {
                if (n3 > 0) {
                    this.fail(n + i, "illegal ')' in [...]");
                }
                if (--n2 >= 0) continue;
                this.fail(n + i, "missing '('");
                continue;
            }
            if (c == '[') {
                if (n3 > 0) {
                    this.fail(n + i, "too many '['");
                }
                ++n3;
                continue;
            }
            if (c != ']' || --n3 >= 0) continue;
            this.fail(n + i, "missing '['");
        }
        if (n2 > 0) {
            this.fail(n + n4, "missing ')'");
        }
        if (n3 > 0) {
            this.fail(n + n4, "missing ']");
        }
        if (n5 < n4) {
            String string3 = string.substring(n5);
            this.addSpec(arrayList, string3, n + n5);
        }
        return arrayList;
    }

    private void addSpec(List list, String string, int n) {
        String string2 = string.trim();
        Multiplier multiplier = this.multiplier(string2, n);
        if (multiplier == null) {
            list.add(string2);
            return;
        }
        List list2 = this.split(multiplier.expression, n + multiplier.offset);
        for (int i = 0; i < multiplier.multiplier; ++i) {
            list.addAll(list2);
        }
    }

    private Multiplier multiplier(String string, int n) {
        Matcher matcher;
        Matcher matcher2 = MULTIPLIER_PREFIX_PATTERN.matcher(string);
        if (!matcher2.find()) {
            return null;
        }
        if (matcher2.start() > 0) {
            this.fail(n + matcher2.start(), "illegal multiplier position");
        }
        if (!(matcher = DIGIT_PATTERN.matcher(string)).find()) {
            return null;
        }
        String string2 = string.substring(0, matcher.end());
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.fail(n, numberFormatException);
        }
        if (n2 <= 0) {
            this.fail(n, "illegal 0 multiplier");
        }
        String string3 = string.substring(matcher2.end(), string.length() - 1);
        return new Multiplier(n2, string3, matcher2.end());
    }

    public static void fail(String string, int n, String string2) {
        throw new FormLayoutParseException(FormSpecParser.message(string, n, string2));
    }

    private void fail(int n, String string) {
        throw new FormLayoutParseException(FormSpecParser.message(this.source, n, string));
    }

    private void fail(int n, NumberFormatException numberFormatException) {
        throw new FormLayoutParseException(FormSpecParser.message(this.source, n, "Invalid multiplier"), numberFormatException);
    }

    private static String message(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append('\n');
        stringBuffer.append(string);
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append('^');
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        throw new FormLayoutParseException(string3);
    }

    static final class Multiplier {
        final int multiplier;
        final String expression;
        final int offset;

        Multiplier(int n, String string, int n2) {
            this.multiplier = n;
            this.expression = string;
            this.offset = n2;
        }
    }

    public static final class FormLayoutParseException
    extends RuntimeException {
        FormLayoutParseException(String string) {
            super(string);
        }

        FormLayoutParseException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

