/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstancePaneBorder
extends AbstractBorder
implements UIResource {
    private static final int BORDER_THICKNESS = 4;
    private static final Insets INSETS = new Insets(4, 4, 4, 4);

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        SubstanceSkin substanceSkin = SubstanceCoreUtilities.getSkin(component);
        if (substanceSkin == null) {
            return;
        }
        SubstanceColorScheme substanceColorScheme = substanceSkin.getBackgroundColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE);
        JComponent jComponent = SubstanceLookAndFeel.getTitlePaneComponent(SwingUtilities.windowForComponent(component));
        SubstanceColorScheme substanceColorScheme2 = substanceSkin.getColorScheme(jComponent, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(substanceColorScheme2.getUltraDarkColor());
        graphics2D.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics2D.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        graphics2D.setColor(substanceColorScheme2.getDarkColor());
        graphics2D.drawLine(n, n2, n + n3 - 2, n2);
        graphics2D.drawLine(n, n2, n, n2 + n4 - 2);
        graphics2D.setColor(substanceColorScheme.getMidColor());
        graphics2D.drawLine(n + 1, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
        graphics2D.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + n4 - 2);
        graphics2D.setColor(substanceColorScheme.getMidColor());
        graphics2D.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
        graphics2D.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 3);
        graphics2D.setColor(substanceColorScheme.getLightColor());
        graphics2D.drawRect(n + 2, n2 + 2, n3 - 5, n4 - 5);
        graphics2D.drawRect(n + 3, n2 + 3, n3 - 7, n4 - 7);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return INSETS;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = SubstancePaneBorder.INSETS.top;
        insets.left = SubstancePaneBorder.INSETS.left;
        insets.bottom = SubstancePaneBorder.INSETS.bottom;
        insets.right = SubstancePaneBorder.INSETS.right;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

