/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.util.EnumSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JRootPane;
import org.pushingpixels.substance.api.SubstanceConstants;

public class SubstanceWidgetManager {
    private static SubstanceWidgetManager instance;
    private Set<SubstanceConstants.SubstanceWidgetType> globalAllowed = EnumSet.noneOf(SubstanceConstants.SubstanceWidgetType.class);
    private Set<SubstanceConstants.SubstanceWidgetType> globalDisallowed = EnumSet.noneOf(SubstanceConstants.SubstanceWidgetType.class);
    private WeakHashMap<JRootPane, Set<SubstanceConstants.SubstanceWidgetType>> specificAllowed = new WeakHashMap();
    private WeakHashMap<JRootPane, Set<SubstanceConstants.SubstanceWidgetType>> specificDisallowed = new WeakHashMap();

    public static synchronized SubstanceWidgetManager getInstance() {
        if (instance == null) {
            instance = new SubstanceWidgetManager();
        }
        return instance;
    }

    private SubstanceWidgetManager() {
    }

    public void register(JRootPane jRootPane, boolean bl, SubstanceConstants.SubstanceWidgetType ... substanceWidgetTypeArray) {
        if (jRootPane == null) {
            for (SubstanceConstants.SubstanceWidgetType substanceWidgetType : substanceWidgetTypeArray) {
                if (bl) {
                    this.globalAllowed.add(substanceWidgetType);
                    this.globalDisallowed.remove((Object)substanceWidgetType);
                    continue;
                }
                this.globalDisallowed.add(substanceWidgetType);
                this.globalAllowed.remove((Object)substanceWidgetType);
            }
        } else {
            Set<SubstanceConstants.SubstanceWidgetType> set = null;
            Set<SubstanceConstants.SubstanceWidgetType> set2 = null;
            if (bl) {
                set = this.specificAllowed.get(jRootPane);
                if (set == null) {
                    set = EnumSet.noneOf(SubstanceConstants.SubstanceWidgetType.class);
                    this.specificAllowed.put(jRootPane, set);
                }
                set2 = this.specificDisallowed.get(jRootPane);
            } else {
                set = this.specificDisallowed.get(jRootPane);
                if (set == null) {
                    set = EnumSet.noneOf(SubstanceConstants.SubstanceWidgetType.class);
                    this.specificDisallowed.put(jRootPane, set);
                }
                set2 = this.specificAllowed.get(jRootPane);
            }
            for (SubstanceConstants.SubstanceWidgetType substanceWidgetType : substanceWidgetTypeArray) {
                set.add(substanceWidgetType);
                if (set2 == null) continue;
                set2.remove((Object)substanceWidgetType);
            }
        }
    }

    public boolean isAllowed(JRootPane jRootPane, SubstanceConstants.SubstanceWidgetType substanceWidgetType) {
        if (this.specificDisallowed.containsKey(jRootPane) && this.specificDisallowed.get(jRootPane).contains((Object)substanceWidgetType)) {
            return false;
        }
        if (this.specificAllowed.containsKey(jRootPane) && this.specificAllowed.get(jRootPane).contains((Object)substanceWidgetType)) {
            return true;
        }
        if (this.globalDisallowed.contains((Object)substanceWidgetType)) {
            return false;
        }
        return this.globalAllowed.contains((Object)substanceWidgetType);
    }

    public boolean isAllowedAnywhere(SubstanceConstants.SubstanceWidgetType substanceWidgetType) {
        if (this.specificAllowed.size() > 0) {
            return true;
        }
        if (this.globalDisallowed.contains((Object)substanceWidgetType)) {
            return false;
        }
        return this.globalAllowed.contains((Object)substanceWidgetType);
    }
}

