/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.MatteFillPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.RectangularButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class PairwiseButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> pairwiseBackgrounds = new LazyResettableHashMap("PairwiseButtonBackgroundDelegate");

    public static void updatePairwiseBackground(Graphics graphics, AbstractButton abstractButton, int n, int n2, SubstanceConstants.Side side, boolean bl) {
        Object object;
        Object object2;
        if (SubstanceCoreUtilities.isButtonNeverPainted(abstractButton)) {
            return;
        }
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(abstractButton);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)abstractButton.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState componentState = modelStateInfo.getCurrModelState();
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(abstractButton, componentState);
        SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(abstractButton, ColorSchemeAssociationKind.BORDER, componentState);
        SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.isSpinnerButton(abstractButton) ? MatteFillPainter.INSTANCE : SubstanceImageCreator.SimplisticSoftBorderReverseFillPainter.INSTANCE;
        BufferedImage bufferedImage = PairwiseButtonBackgroundDelegate.getPairwiseFullAlphaBackground(abstractButton, substanceFillPainter, substanceButtonShaper, n, n2, side, substanceColorScheme, substanceColorScheme2, bl);
        BufferedImage bufferedImage2 = null;
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        if (componentState.isDisabled() || map.size() == 1) {
            bufferedImage2 = bufferedImage;
        } else {
            bufferedImage2 = SubstanceCoreUtilities.getBlankImage(bufferedImage.getWidth(), bufferedImage.getHeight());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                float f;
                object2 = entry.getKey();
                if (object2 == componentState || (f = entry.getValue().getContribution()) == 0.0f) continue;
                object = SubstanceColorSchemeUtilities.getColorScheme(abstractButton, (ComponentState)object2);
                SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.getColorScheme(abstractButton, ColorSchemeAssociationKind.BORDER, (ComponentState)object2);
                BufferedImage bufferedImage3 = PairwiseButtonBackgroundDelegate.getPairwiseFullAlphaBackground(abstractButton, substanceFillPainter, substanceButtonShaper, n, n2, side, (SubstanceColorScheme)object, substanceColorScheme3, bl);
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(f));
                graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
            }
            graphics2D.dispose();
        }
        boolean bl2 = SubstanceCoreUtilities.hasFlatAppearance(abstractButton);
        boolean bl3 = bl2 || !abstractButton.isEnabled();
        float f = 1.0f;
        if (bl3) {
            if (bl2) {
                f = 0.0f;
                for (Map.Entry entry : map.entrySet()) {
                    object = (ComponentState)entry.getKey();
                    if (((ComponentState)object).isDisabled() || object == ComponentState.ENABLED) continue;
                    f += ((StateTransitionTracker.StateContributionInfo)entry.getValue()).getContribution();
                }
            } else if (!abstractButton.isEnabled()) {
                f = SubstanceColorSchemeUtilities.getAlpha(abstractButton, componentState);
            }
        }
        if (f > 0.0f) {
            object2 = (Graphics2D)graphics.create();
            ((Graphics2D)object2).setComposite(LafWidgetUtilities.getAlphaComposite(abstractButton, f, graphics));
            ((Graphics)object2).drawImage(bufferedImage2, 0, 0, null);
            ((Graphics)object2).dispose();
        }
    }

    private static BufferedImage getPairwiseFullAlphaBackground(AbstractButton abstractButton, SubstanceFillPainter substanceFillPainter, SubstanceButtonShaper substanceButtonShaper, int n, int n2, SubstanceConstants.Side side, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2, boolean bl) {
        HashMapKey hashMapKey;
        BufferedImage bufferedImage;
        if (SubstanceCoreUtilities.isButtonNeverPainted(abstractButton)) {
            return null;
        }
        Set<SubstanceConstants.Side> set = bl ? EnumSet.noneOf(SubstanceConstants.Side.class) : SubstanceCoreUtilities.getSides(abstractButton, "substancelaf.buttonopenSide");
        boolean bl2 = abstractButton.isBorderPainted();
        boolean bl3 = abstractButton.isContentAreaFilled();
        float f = 0.0f;
        if (SubstanceCoreUtilities.isSpinnerButton(abstractButton) && substanceButtonShaper instanceof RectangularButtonShaper) {
            f = ((RectangularButtonShaper)((Object)substanceButtonShaper)).getCornerRadius(abstractButton, null);
        }
        if ((bufferedImage = pairwiseBackgrounds.get(hashMapKey = SubstanceCoreUtilities.getHashKey(new Object[]{n, n2, side, set, substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), abstractButton.getClass().getName(), substanceFillPainter.getDisplayName(), substanceButtonShaper.getDisplayName(), bl2, bl3, Float.valueOf(f)}))) == null) {
            int n3 = set != null && set.contains((Object)SubstanceConstants.Side.LEFT) ? 3 : 0;
            int n4 = set != null && set.contains((Object)SubstanceConstants.Side.RIGHT) ? 3 : 0;
            int n5 = set != null && set.contains((Object)SubstanceConstants.Side.TOP) ? 3 : 0;
            int n6 = set != null && set.contains((Object)SubstanceConstants.Side.BOTTOM) ? 3 : 0;
            GeneralPath generalPath = null;
            SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(abstractButton);
            int n7 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(abstractButton)) / 2.0);
            bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.translate(-n3, -n5);
            if (side != null) {
                switch (side) {
                    case TOP: 
                    case BOTTOM: {
                        generalPath = SubstanceOutlineUtilities.getBaseOutline(n2 + n5 + n6, n + n3 + n4, f, null, n7);
                        int n8 = n2;
                        if (SubstanceCoreUtilities.isScrollButton(abstractButton)) {
                            n8 += 1 + (side == SubstanceConstants.Side.BOTTOM ? 1 : -2);
                        }
                        AffineTransform affineTransform = AffineTransform.getTranslateInstance(0.0, n8);
                        affineTransform.rotate(-1.5707963267948966);
                        graphics2D.setTransform(affineTransform);
                        if (bl3) {
                            substanceFillPainter.paintContourBackground(graphics2D, abstractButton, n2 + n5 + n6, n + n3 + n4, generalPath, false, substanceColorScheme, true);
                        }
                        if (!bl2) break;
                        substanceBorderPainter.paintBorder(graphics2D, abstractButton, n2 + n5 + n6, n + n3 + n4, generalPath, null, substanceColorScheme2);
                        break;
                    }
                    case RIGHT: 
                    case LEFT: {
                        generalPath = SubstanceOutlineUtilities.getBaseOutline(n + n3 + n4, n2 + n5 + n6, f, null, n7);
                        if (bl3) {
                            substanceFillPainter.paintContourBackground(graphics2D, abstractButton, n + n3 + n4, n2 + n5 + n6, generalPath, false, substanceColorScheme, true);
                        }
                        if (!bl2) break;
                        substanceBorderPainter.paintBorder(graphics2D, abstractButton, n + n3 + n4, n2 + n5 + n6, generalPath, null, substanceColorScheme2);
                    }
                }
            } else {
                generalPath = SubstanceOutlineUtilities.getBaseOutline(n + n3 + n4, n2 + n5 + n6, f, null, n7);
                substanceFillPainter.paintContourBackground(graphics2D, abstractButton, n + n3 + n4, n2 + n5 + n6, generalPath, false, substanceColorScheme, true);
                if (bl2) {
                    substanceBorderPainter.paintBorder(graphics2D, abstractButton, n + n3 + n4, n2 + n5 + n6, generalPath, null, substanceColorScheme2);
                }
            }
            pairwiseBackgrounds.put(hashMapKey, bufferedImage);
        }
        return bufferedImage;
    }
}

