/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.RolloverButtonListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceRadioButtonUI
extends BasicRadioButtonUI
implements TransitionAwareUI {
    protected Set lafWidgets;
    protected PropertyChangeListener substancePropertyListener;
    protected JToggleButton button;
    private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceRadioButtonUI");
    protected StateTransitionTracker stateTransitionTracker;
    private Rectangle viewRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle textRect = new Rectangle();

    public void __org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners(AbstractButton abstractButton) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__installListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__installDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__uninstallListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__uninstallDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__installListeners(final AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("model".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceRadioButtonUI.this.stateTransitionTracker.setModel((ButtonModel)propertyChangeEvent.getNewValue());
                }
                if ("font".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            abstractButton.updateUI();
                        }
                    });
                }
            }
        };
        abstractButton.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        Border border = abstractButton.getBorder();
        if (border == null || border instanceof UIResource) {
            abstractButton.setBorder(SubstanceSizeUtils.getRadioButtonBorder(SubstanceSizeUtils.getComponentFontSize(abstractButton), abstractButton.getComponentOrientation().isLeftToRight()));
        }
        this.button.setRolloverEnabled(true);
        LookAndFeel.installProperty(abstractButton, "iconTextGap", SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(abstractButton)));
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceRadioButtonUI__uninstallListeners(AbstractButton abstractButton) {
        abstractButton.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        super.uninstallListeners(abstractButton);
    }

    private static Icon getIcon(JToggleButton jToggleButton, StateTransitionTracker stateTransitionTracker) {
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        int n = SubstanceSizeUtils.getComponentFontSize(jToggleButton);
        int n2 = SubstanceSizeUtils.getRadioButtonMarkSize(n);
        SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(jToggleButton);
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(jToggleButton);
        ComponentState componentState = modelStateInfo.getCurrModelState();
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jToggleButton, ColorSchemeAssociationKind.FILL, componentState);
        SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jToggleButton, ColorSchemeAssociationKind.MARK, componentState);
        SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.getColorScheme(jToggleButton, ColorSchemeAssociationKind.BORDER, componentState);
        float f = stateTransitionTracker.getFacetStrength(ComponentStateFacet.SELECTION);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), substanceColorScheme3.getDisplayName(), Float.valueOf(f));
        Icon icon = icons.get(hashMapKey);
        if (icon == null) {
            icon = new ImageIcon(SubstanceImageCreator.getRadioButton(jToggleButton, substanceFillPainter, substanceBorderPainter, n2, componentState, 0, substanceColorScheme, substanceColorScheme2, substanceColorScheme3, f));
            icons.put(hashMapKey, icon);
        }
        if (componentState.isDisabled() || map.size() == 1) {
            return icon;
        }
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(icon.getIconWidth(), icon.getIconHeight());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(jToggleButton, graphics2D, 0, 0);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
            float f2;
            ComponentState componentState2 = entry.getKey();
            if (componentState2 == componentState || !((f2 = entry.getValue().getContribution()) > 0.0f)) continue;
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(f2));
            SubstanceColorScheme substanceColorScheme4 = SubstanceColorSchemeUtilities.getColorScheme(jToggleButton, ColorSchemeAssociationKind.FILL, componentState2);
            SubstanceColorScheme substanceColorScheme5 = SubstanceColorSchemeUtilities.getColorScheme(jToggleButton, ColorSchemeAssociationKind.MARK, componentState2);
            SubstanceColorScheme substanceColorScheme6 = SubstanceColorSchemeUtilities.getColorScheme(jToggleButton, ColorSchemeAssociationKind.BORDER, componentState2);
            HashMapKey hashMapKey2 = SubstanceCoreUtilities.getHashKey(n, n2, substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), substanceColorScheme4.getDisplayName(), substanceColorScheme5.getDisplayName(), substanceColorScheme6.getDisplayName(), Float.valueOf(f));
            Icon icon2 = icons.get(hashMapKey2);
            if (icon2 == null) {
                icon2 = new ImageIcon(SubstanceImageCreator.getRadioButton(jToggleButton, substanceFillPainter, substanceBorderPainter, n2, componentState, 0, substanceColorScheme4, substanceColorScheme5, substanceColorScheme6, f));
                icons.put(hashMapKey2, icon2);
            }
            icon2.paintIcon(jToggleButton, graphics2D, 0, 0);
        }
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceRadioButtonUI((JToggleButton)jComponent);
    }

    public SubstanceRadioButtonUI(JToggleButton jToggleButton) {
        this.button = jToggleButton;
        jToggleButton.setRolloverEnabled(true);
        this.stateTransitionTracker = new StateTransitionTracker(this.button, this.button.getModel());
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new RolloverButtonListener(abstractButton, this.stateTransitionTracker);
    }

    @Override
    public Icon getDefaultIcon() {
        return SubstanceRadioButtonUI.getIcon(this.button, this.stateTransitionTracker);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (SubstanceCoreUtilities.isOpaque(jComponent)) {
            BackgroundPaintingUtils.update(graphics, jComponent, false);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = abstractButton.getInsets();
        this.viewRect.x = insets.left;
        this.viewRect.y = insets.top;
        this.viewRect.width = abstractButton.getWidth() - (insets.right + this.viewRect.x);
        this.viewRect.height = abstractButton.getHeight() - (insets.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        Font font = abstractButton.getFont();
        graphics.setFont(font);
        Icon icon = SubstanceCoreUtilities.getOriginalIcon(abstractButton, this.getDefaultIcon());
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (string != null && !string.equals("")) {
            View view = (View)abstractButton.getClientProperty("html");
            if (view != null) {
                view.paint(graphics2D, this.textRect);
            } else {
                this.paintButtonText(graphics2D, abstractButton, this.textRect, string);
            }
        }
        if (icon != null) {
            icon.paintIcon(jComponent, graphics2D, this.iconRect.x, this.iconRect.y);
        }
        if (abstractButton.isFocusPainted()) {
            int n = SubstanceSizeUtils.getFocusRingPadding(SubstanceSizeUtils.getComponentFontSize(this.button)) / 2;
            SubstanceCoreUtilities.paintFocus(graphics2D, this.button, this.button, this, null, this.textRect, 1.0f, n);
        }
        graphics2D.dispose();
    }

    public static String getMemoryUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubstanceRadioButtonUI: \n");
        stringBuffer.append("\t" + icons.size() + " icons");
        return stringBuffer.toString();
    }

    protected void paintButtonText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        SubstanceTextUtilities.paintText(graphics, abstractButton, rectangle, string, abstractButton.getDisplayedMnemonicIndex());
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        return true;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }
}

