/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.pushingpixels.substance.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationAware;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationInfo;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;

public class SubstanceListUI
extends BasicListUI
implements UpdateOptimizationAware {
    protected Set lafWidgets;
    protected Map<Integer, Object> selectedIndices = new HashMap<Integer, Object>();
    protected int rolledOverIndex = -1;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected ListSelectionListener substanceListSelectionListener;
    protected RolloverFadeListener substanceFadeRolloverListener;
    private ComponentListener substanceComponentListener;
    private StateTransitionMultiTracker<Integer> stateTransitionMultiTracker = new StateTransitionMultiTracker();
    private ListDataListener substanceListDataListener;
    private UpdateOptimizationInfo updateInfo;

    public void __org__pushingpixels__substance__internal__ui__SubstanceListUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceListUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceListUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceListUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceListUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceListUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    @Override
    protected void uninstallDefaults() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceListUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceListUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceListUI();
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceListUI__installDefaults() {
        super.installDefaults();
        if (SubstanceCoreUtilities.toDrawWatermark(this.list)) {
            this.list.setOpaque(false);
        }
        this.syncModelContents();
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceListUI__uninstallDefaults() {
        this.selectedIndices.clear();
        super.uninstallDefaults();
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceListUI__uninstallUI(JComponent jComponent) {
        this.stateTransitionMultiTracker.clear();
        super.uninstallUI(jComponent);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceListUI__installListeners() {
        super.installListeners();
        this.substanceListSelectionListener = new SubstanceListSelectionListener();
        this.list.getSelectionModel().addListSelectionListener(this.substanceListSelectionListener);
        this.substanceFadeRolloverListener = new RolloverFadeListener();
        this.list.addMouseMotionListener(this.substanceFadeRolloverListener);
        this.list.addMouseListener(this.substanceFadeRolloverListener);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                if ("substancelaf.watermark.visible".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceListUI.this.list.setOpaque(!SubstanceCoreUtilities.toDrawWatermark(SubstanceListUI.this.list));
                }
                if ("model".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ListModel listModel = (ListModel)propertyChangeEvent.getOldValue();
                            if (listModel != null) {
                                listModel.removeListDataListener(SubstanceListUI.this.substanceListDataListener);
                            }
                            ListModel listModel2 = (ListModel)propertyChangeEvent.getNewValue();
                            SubstanceListUI.this.substanceListDataListener = new SubstanceListDataListener();
                            listModel2.addListDataListener(SubstanceListUI.this.substanceListDataListener);
                            SubstanceListUI.this.syncModelContents();
                        }
                    });
                }
                if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                            if (listSelectionModel != null) {
                                listSelectionModel.removeListSelectionListener(SubstanceListUI.this.substanceListSelectionListener);
                            }
                            ListSelectionModel listSelectionModel2 = (ListSelectionModel)propertyChangeEvent.getNewValue();
                            SubstanceListUI.this.substanceListSelectionListener = new SubstanceListSelectionListener();
                            listSelectionModel2.addListSelectionListener(SubstanceListUI.this.substanceListSelectionListener);
                            SubstanceListUI.this.syncModelContents();
                        }
                    });
                }
            }
        };
        this.list.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceComponentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                SubstanceListUI.this.fadeOutRolloverIndication();
                SubstanceListUI.this.resetRolloverIndex();
            }
        };
        this.list.addComponentListener(this.substanceComponentListener);
        this.substanceListDataListener = new SubstanceListDataListener();
        this.list.getModel().addListDataListener(this.substanceListDataListener);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceListUI__uninstallListeners() {
        this.list.getModel().removeListDataListener(this.substanceListDataListener);
        this.substanceListDataListener = null;
        this.list.getSelectionModel().removeListSelectionListener(this.substanceListSelectionListener);
        this.substanceListSelectionListener = null;
        this.list.removeMouseMotionListener(this.substanceFadeRolloverListener);
        this.list.removeMouseListener(this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        this.list.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.list.removeComponentListener(this.substanceComponentListener);
        this.substanceComponentListener = null;
        super.uninstallListeners();
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object object;
        Object object2;
        Object object3;
        Object e = listModel.getElementAt(n);
        boolean bl = this.list.hasFocus() && n == n2;
        boolean bl2 = listSelectionModel.isSelectedIndex(n);
        Component component = listCellRenderer.getListCellRendererComponent(this.list, e, n, bl2, bl);
        if (!(component instanceof SubstanceDefaultListCellRenderer)) {
            super.paintCell(graphics, n, rectangle, listCellRenderer, listModel, listSelectionModel, n2);
            return;
        }
        boolean bl3 = this.updateInfo.toDrawWatermark;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.list, graphics));
        if (!bl3) {
            object3 = component.getBackground();
            if (object3 != null && (!this.list.getBackground().equals(object3) || this.updateInfo.isInDecorationArea)) {
                graphics2D.setColor((Color)object3);
                graphics2D.fillRect(n3, n4, n5, n6);
            }
        } else {
            BackgroundPaintingUtils.fillAndWatermark(graphics2D, this.list, component.getBackground(), new Rectangle(n3, n4, n5, n6));
        }
        object3 = this.getModelStateInfo(n, component);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = object3 == null ? null : ((StateTransitionTracker.ModelStateInfo)object3).getStateContributionMap();
        ComponentState componentState = object3 == null ? this.getCellState(n, component) : ((StateTransitionTracker.ModelStateInfo)object3).getCurrModelState();
        boolean bl4 = false;
        if (component.isEnabled()) {
            if (map != null) {
                object2 = map.entrySet().iterator();
                while (object2.hasNext() && !(bl4 = this.updateInfo.getHighlightAlpha((ComponentState)(object = (Map.Entry)object2.next()).getKey()) * ((StateTransitionTracker.StateContributionInfo)object.getValue()).getContribution() > 0.0f)) {
                }
            } else {
                boolean bl5 = bl4 = this.updateInfo.getHighlightAlpha(componentState) > 0.0f;
            }
        }
        if ((object2 = this.list.getDropLocation()) != null && !((JList.DropLocation)object2).isInsert() && ((JList.DropLocation)object2).getIndex() == n) {
            object = SubstanceColorSchemeUtilities.getColorScheme(this.list, ColorSchemeAssociationKind.TEXT_HIGHLIGHT, componentState);
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.list, ColorSchemeAssociationKind.BORDER, componentState);
            Rectangle rectangle2 = new Rectangle(n3, n4, n5, n6);
            HighlightPainterUtils.paintHighlight(graphics2D, this.rendererPane, component, rectangle2, 0.8f, null, (SubstanceColorScheme)object, substanceColorScheme);
        } else if (bl4) {
            object = new Rectangle(n3, n4, n5, n6);
            if (map == null) {
                float f = this.updateInfo.getHighlightAlpha(componentState);
                if (f > 0.0f) {
                    SubstanceColorScheme substanceColorScheme = this.updateInfo.getHighlightColorScheme(componentState);
                    SubstanceColorScheme substanceColorScheme2 = this.updateInfo.getHighlightBorderColorScheme(componentState);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(this.list, f, graphics));
                    HighlightPainterUtils.paintHighlight(graphics2D, this.rendererPane, component, (Rectangle)object, 0.8f, null, substanceColorScheme, substanceColorScheme2);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.list, graphics));
                }
            } else {
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                    ComponentState componentState2 = entry.getKey();
                    float f = this.updateInfo.getHighlightAlpha(componentState2) * entry.getValue().getContribution();
                    if (f == 0.0f) continue;
                    SubstanceColorScheme substanceColorScheme = this.updateInfo.getHighlightColorScheme(componentState2);
                    SubstanceColorScheme substanceColorScheme3 = this.updateInfo.getHighlightBorderColorScheme(componentState2);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(this.list, f, graphics));
                    HighlightPainterUtils.paintHighlight(graphics2D, this.rendererPane, component, (Rectangle)object, 0.8f, null, substanceColorScheme, substanceColorScheme3);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.list, graphics));
                }
            }
        }
        this.rendererPane.paintComponent(graphics2D, component, this.list, n3, n4, n5, n6, true);
        graphics2D.dispose();
    }

    public StateTransitionTracker getStateTransitionTracker(int n) {
        return this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n);
    }

    public ComponentState getCellState(int n, Component component) {
        StateTransitionTracker stateTransitionTracker;
        boolean bl = this.list.isEnabled();
        if (component != null) {
            boolean bl2 = bl = bl && component.isEnabled();
        }
        if ((stateTransitionTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n)) == null) {
            boolean bl3 = this.rolledOverIndex >= 0 && this.rolledOverIndex == n;
            boolean bl4 = this.selectedIndices.containsKey(n);
            return ComponentState.getState(bl, bl3, bl4);
        }
        ComponentState componentState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
        return ComponentState.getState(bl, componentState.isFacetActive(ComponentStateFacet.ROLLOVER), componentState.isFacetActive(ComponentStateFacet.SELECTION));
    }

    public StateTransitionTracker.ModelStateInfo getModelStateInfo(int n, Component component) {
        if (this.stateTransitionMultiTracker.size() == 0) {
            return null;
        }
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n);
        if (stateTransitionTracker == null) {
            return null;
        }
        return stateTransitionTracker.getModelStateInfo();
    }

    public void resetRolloverIndex() {
        this.rolledOverIndex = -1;
    }

    private void fadeOutRolloverIndication() {
        if (this.rolledOverIndex < 0) {
            return;
        }
        StateTransitionTracker stateTransitionTracker = this.getTracker(this.rolledOverIndex, true, this.list.isSelectedIndex(this.rolledOverIndex));
        stateTransitionTracker.getModel().setRollover(false);
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceListUI__update(Graphics graphics, JComponent jComponent) {
        BackgroundPaintingUtils.updateIfOpaque(graphics, jComponent);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        SubstanceStripingUtils.setup(jComponent);
        this.updateInfo = new UpdateOptimizationInfo(jComponent);
        this.paint(graphics2D, jComponent);
        SubstanceStripingUtils.tearDown(jComponent);
        graphics2D.dispose();
        this.updateInfo = null;
    }

    private void syncModelContents() {
        if (this.list == null) {
            return;
        }
        this.stateTransitionMultiTracker.clear();
        this.selectedIndices.clear();
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            if (!this.list.isSelectedIndex(i)) continue;
            this.selectedIndices.put(i, this.list.getModel().getElementAt(i));
        }
        this.list.repaint();
    }

    private StateTransitionTracker getTracker(final int n, boolean bl, boolean bl2) {
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n);
        if (stateTransitionTracker == null) {
            DefaultButtonModel defaultButtonModel = new DefaultButtonModel();
            defaultButtonModel.setSelected(bl2);
            defaultButtonModel.setRollover(bl);
            stateTransitionTracker = new StateTransitionTracker(this.list, defaultButtonModel);
            stateTransitionTracker.registerModelListeners();
            stateTransitionTracker.setRepaintCallback(new StateTransitionTracker.RepaintCallback(){

                @Override
                public TimelineCallback getRepaintCallback() {
                    return new CellRepaintCallback(SubstanceListUI.this.list, n);
                }
            });
            stateTransitionTracker.setName("row " + n);
            this.stateTransitionMultiTracker.addTracker((Comparable<Integer>)n, stateTransitionTracker);
        }
        return stateTransitionTracker;
    }

    @Override
    public UpdateOptimizationInfo getUpdateOptimizationInfo() {
        return this.updateInfo;
    }

    protected class CellRepaintCallback
    extends UIThreadTimelineCallbackAdapter {
        protected JList list;
        protected int cellIndex;

        public CellRepaintCallback(JList jList, int n) {
            this.list = jList;
            this.cellIndex = n;
        }

        public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
            this.repaintCell();
        }

        public void onTimelinePulse(float f, float f2) {
            this.repaintCell();
        }

        private void repaintCell() {
            if (SubstanceListUI.this.list == null) {
                return;
            }
            try {
                SubstanceListUI.this.maybeUpdateLayoutState();
                int n = this.list.getModel().getSize();
                if (n > 0 && this.cellIndex < n) {
                    Rectangle rectangle = SubstanceListUI.this.getCellBounds(this.list, this.cellIndex, this.cellIndex);
                    this.list.repaint(rectangle);
                }
            }
            catch (RuntimeException runtimeException) {
                return;
            }
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            SubstanceListUI.this.fadeOutRolloverIndication();
            SubstanceListUI.this.resetRolloverIndex();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!SubstanceListUI.this.list.isEnabled()) {
                return;
            }
            this.handleMove(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!SubstanceListUI.this.list.isEnabled()) {
                return;
            }
            this.handleMove(mouseEvent);
        }

        private void handleMove(MouseEvent mouseEvent) {
            if (!(SubstanceListUI.this.list.getCellRenderer() instanceof SubstanceDefaultListCellRenderer)) {
                SubstanceListUI.this.fadeOutRolloverIndication();
                SubstanceListUI.this.resetRolloverIndex();
                return;
            }
            int n = SubstanceListUI.this.list.locationToIndex(mouseEvent.getPoint());
            if (n >= 0 && n < SubstanceListUI.this.list.getModel().getSize() && !SubstanceListUI.this.list.getCellBounds(n, n).contains(mouseEvent.getPoint())) {
                n = -1;
            }
            if (n < 0 || n >= SubstanceListUI.this.list.getModel().getSize()) {
                SubstanceListUI.this.fadeOutRolloverIndication();
                SubstanceListUI.this.resetRolloverIndex();
            } else {
                if (SubstanceListUI.this.rolledOverIndex >= 0 && SubstanceListUI.this.rolledOverIndex == n) {
                    return;
                }
                SubstanceListUI.this.fadeOutRolloverIndication();
                StateTransitionTracker stateTransitionTracker = SubstanceListUI.this.getTracker(n, false, SubstanceListUI.this.list.isSelectedIndex(n));
                stateTransitionTracker.getModel().setRollover(true);
                SubstanceListUI.this.rolledOverIndex = n;
            }
        }
    }

    private final class SubstanceListDataListener
    implements ListDataListener {
        private SubstanceListDataListener() {
        }

        private void _syncModelContents() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubstanceListUI.this.syncModelContents();
                }
            });
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this._syncModelContents();
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this._syncModelContents();
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this._syncModelContents();
        }
    }

    private class SubstanceListSelectionListener
    implements ListSelectionListener {
        private SubstanceListSelectionListener() {
        }

        @Override
        public void valueChanged(final ListSelectionEvent listSelectionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubstanceListSelectionListener.this.handleListSelectionChange(listSelectionEvent);
                    SubstanceListUI.this.list.repaint();
                }
            });
        }

        private void handleListSelectionChange(ListSelectionEvent listSelectionEvent) {
            if (SubstanceListUI.this.list == null) {
                return;
            }
            if (LafWidgetUtilities.hasNoAnimations(SubstanceListUI.this.list, AnimationFacet.SELECTION)) {
                return;
            }
            if (!(SubstanceListUI.this.list.getCellRenderer() instanceof SubstanceDefaultListCellRenderer)) {
                SubstanceListUI.this.syncModelContents();
                return;
            }
            HashSet<StateTransitionTracker> hashSet = new HashSet<StateTransitionTracker>();
            boolean bl = false;
            for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
                StateTransitionTracker stateTransitionTracker;
                if (i >= SubstanceListUI.this.list.getModel().getSize()) continue;
                if (SubstanceListUI.this.list.isSelectedIndex(i)) {
                    if (SubstanceListUI.this.selectedIndices.containsKey(i)) continue;
                    SubstanceListUI.this.selectedIndices.put(i, SubstanceListUI.this.list.getModel().getElementAt(i));
                    if (bl) continue;
                    stateTransitionTracker = SubstanceListUI.this.getTracker(i, i == SubstanceListUI.this.rolledOverIndex, false);
                    stateTransitionTracker.getModel().setSelected(true);
                    hashSet.add(stateTransitionTracker);
                    if (hashSet.size() <= 25) continue;
                    SubstanceListUI.this.stateTransitionMultiTracker.clear();
                    hashSet.clear();
                    bl = true;
                    continue;
                }
                if (!SubstanceListUI.this.selectedIndices.containsKey(i)) continue;
                if (SubstanceListUI.this.selectedIndices.get(i) == SubstanceListUI.this.list.getModel().getElementAt(i) && !bl) {
                    stateTransitionTracker = SubstanceListUI.this.getTracker(i, i == SubstanceListUI.this.rolledOverIndex, true);
                    stateTransitionTracker.getModel().setSelected(false);
                    hashSet.add(stateTransitionTracker);
                    if (hashSet.size() > 25) {
                        SubstanceListUI.this.stateTransitionMultiTracker.clear();
                        hashSet.clear();
                        bl = true;
                    }
                }
                SubstanceListUI.this.selectedIndices.remove(i);
            }
        }
    }
}

