/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.image.BufferedImage;
import java.util.Collection;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SeparatorPainterUtils {
    private static LazyResettableHashMap<BufferedImage> cached = new LazyResettableHashMap("SeparatorPainterUtils");

    public static void paintSeparator(Component component, Graphics graphics, int n, int n2, int n3) {
        SeparatorPainterUtils.paintSeparator(component, graphics, n, n2, n3, true, 10);
    }

    public static void paintSeparator(Component component, Graphics graphics, int n, int n2, int n3, boolean bl, int n4) {
        SeparatorPainterUtils.paintSeparator(component, graphics, n, n2, n3, bl, n4, n4, false);
    }

    public static void paintSeparator(Component component, Graphics graphics, int n, int n2, int n3, boolean bl, int n4, int n5, boolean bl2) {
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        SeparatorPainterUtils.paintSeparator(component, graphics, substanceColorScheme, n, n2, n3, bl, n4, n5, bl2);
    }

    public static void paintSeparator(Component component, Graphics graphics, SubstanceColorScheme substanceColorScheme, int n, int n2, int n3, boolean bl, int n4, int n5, boolean bl2) {
        Graphics2D graphics2D;
        DecorationAreaType decorationAreaType = SubstanceLookAndFeel.getDecorationType(component);
        SubstanceSkin substanceSkin = SubstanceCoreUtilities.getSkin(component);
        boolean bl3 = decorationAreaType == null || decorationAreaType == DecorationAreaType.NONE ? false : substanceSkin.isRegisteredAsDecorationArea(decorationAreaType) || substanceSkin.getOverlayPainters(decorationAreaType).size() > 0;
        bl3 = bl3 || bl2;
        Color color = SubstanceColorUtilities.getBackgroundFillColor(component);
        int n6 = SubstanceSizeUtils.getComponentFontSize(component);
        float f = SubstanceSizeUtils.getBorderStrokeWidth(n6);
        if (n3 == 0 && n2 == 0) {
            n2 = (int)Math.ceil(2.0 * (double)f);
        }
        if (n3 == 1 && n == 0) {
            n = (int)Math.ceil(2.0 * (double)f);
        }
        if (n == 0 || n2 == 0) {
            return;
        }
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n6, substanceColorScheme.getDisplayName(), n, n2, n3, bl, n4, n5, bl3, color.getRGB());
        BufferedImage bufferedImage = cached.get(hashMapKey);
        if (bufferedImage == null) {
            bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
            graphics2D = bufferedImage.createGraphics();
            Color color2 = SeparatorPainterUtils.getSeparatorLightColor(substanceColorScheme);
            Color color3 = SeparatorPainterUtils.getSeparatorDarkColor(substanceColorScheme);
            Color color4 = SeparatorPainterUtils.getSeparatorShadowColor(substanceColorScheme);
            Color color5 = bl3 ? SubstanceColorUtilities.getAlphaColor(color2, 32) : SubstanceColorUtilities.getInterpolatedColor(color2, color, 0.12);
            Color color6 = bl3 ? SubstanceColorUtilities.getAlphaColor(color3, 240) : SubstanceColorUtilities.getInterpolatedColor(color3, color, 0.95);
            Color color7 = bl3 ? SubstanceColorUtilities.getAlphaColor(color4, 32) : SubstanceColorUtilities.getInterpolatedColor(color4, color, 0.12);
            Color color8 = bl3 ? SubstanceColorUtilities.getAlphaColor(color4, 240) : SubstanceColorUtilities.getInterpolatedColor(color4, color, 0.95);
            graphics2D.setStroke(new BasicStroke(f, 0, 1));
            if (n3 == 1) {
                int n7 = Math.min(n4, n2 / 2);
                int n8 = Math.min(n5, n2 / 2);
                graphics2D.translate(Math.max(0, n / 2 - 1), 0);
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color5, 0.0f, n7, color6));
                graphics2D.drawLine(0, 0, 0, n7);
                graphics2D.setColor(color6);
                graphics2D.drawLine(0, n7, 0, n2 - n8);
                graphics2D.setPaint(new GradientPaint(0.0f, n2 - n8, color6, 0.0f, n2, color5));
                graphics2D.drawLine(0, n2 - n8, 0, n2);
                if (bl) {
                    int n9 = (int)f;
                    graphics2D.setPaint(new GradientPaint(n9, 0.0f, color7, n9, n7, color8));
                    graphics2D.drawLine(n9, 0, n9, n7);
                    graphics2D.setColor(color8);
                    graphics2D.drawLine(n9, n7, n9, n2 - n8);
                    graphics2D.setPaint(new GradientPaint(n9, n2 - n8, color8, n9, n2, color7));
                    graphics2D.drawLine(n9, n2 - n8, n9, n2);
                }
            } else {
                int n10 = Math.min(n4, n / 2);
                int n11 = Math.min(n5, n / 2);
                graphics2D.translate(0, Math.max(0, n2 / 2 - 1));
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color5, n10, 0.0f, color6));
                graphics2D.drawLine(0, 0, n10, 0);
                graphics2D.setColor(color6);
                graphics2D.drawLine(n10, 0, n - n11, 0);
                graphics2D.setPaint(new GradientPaint(n - n11, 0.0f, color6, n, 0.0f, color5));
                graphics2D.drawLine(n - n11, 0, n, 0);
                if (bl) {
                    int n12 = (int)f;
                    graphics2D.setPaint(new GradientPaint(0.0f, n12, color7, n10, n12, color8));
                    graphics2D.drawLine(0, n12, n10, n12);
                    graphics2D.setColor(color8);
                    graphics2D.drawLine(n10, n12, n - n11, n12);
                    graphics2D.setPaint(new GradientPaint(n - n11, n12, color8, n, n12, color7));
                    graphics2D.drawLine(n - n11, n12, n, n12);
                }
            }
            graphics2D.dispose();
            cached.put(hashMapKey, bufferedImage);
        }
        graphics2D = (Graphics2D)graphics.create();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
    }

    public static Color getSeparatorShadowColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.isDark() ? substanceColorScheme.getDarkColor() : substanceColorScheme.getUltraLightColor();
    }

    public static Color getSeparatorDarkColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.isDark() ? substanceColorScheme.getExtraLightColor() : SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getMidColor(), substanceColorScheme.getDarkColor(), 0.4);
    }

    public static Color getSeparatorLightColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.isDark() ? substanceColorScheme.getLightColor() : SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getLightColor(), substanceColorScheme.getDarkColor(), 0.8);
    }

    public static void paintVerticalLines(Graphics graphics, Component component, SubstanceColorScheme substanceColorScheme, int n, Collection<Integer> collection, int n2, float f) {
        Object object;
        Graphics2D graphics2D;
        int n3 = SubstanceSizeUtils.getComponentFontSize(component);
        Color color = SubstanceColorUtilities.getBackgroundFillColor(component);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n3, substanceColorScheme.getDisplayName(), 0, n2, 1, true, 0.0, Float.valueOf(f), color.getRGB());
        float f2 = SubstanceSizeUtils.getBorderStrokeWidth(n3);
        int n4 = (int)f2;
        BufferedImage bufferedImage = cached.get(hashMapKey);
        if (bufferedImage == null) {
            bufferedImage = SubstanceCoreUtilities.getBlankImage(Math.max(2, (int)Math.ceil(2.0 * (double)f2)), n2);
            graphics2D = bufferedImage.createGraphics();
            object = SeparatorPainterUtils.getSeparatorLightColor(substanceColorScheme);
            Color color2 = SeparatorPainterUtils.getSeparatorDarkColor(substanceColorScheme);
            Color color3 = SeparatorPainterUtils.getSeparatorShadowColor(substanceColorScheme);
            graphics2D.setStroke(new BasicStroke(f2, 0, 1));
            Color color4 = SubstanceColorUtilities.getInterpolatedColor((Color)object, color, 0.12);
            Color color5 = SubstanceColorUtilities.getInterpolatedColor(color2, color, 0.95);
            Color color6 = SubstanceColorUtilities.getInterpolatedColor(color3, color, 0.12);
            Color color7 = SubstanceColorUtilities.getInterpolatedColor(color3, color, 0.95);
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, n2, new float[]{0.0f, f, 1.0f}, new Color[]{color5, color5, color4});
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.translate(f2 / 2.0f, 0.0);
            graphics2D.drawLine(0, 0, 0, n2);
            LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(0.0f, 0.0f, 0.0f, n2, new float[]{0.0f, f, 1.0f}, new Color[]{color7, color7, color6});
            graphics2D.setPaint(linearGradientPaint2);
            graphics2D.drawLine(n4, 0, n4, n2);
            graphics2D.dispose();
            cached.put(hashMapKey, bufferedImage);
        }
        graphics2D = (Graphics2D)graphics.create();
        object = collection.iterator();
        while (object.hasNext()) {
            int n5 = object.next();
            graphics2D.drawImage((Image)bufferedImage, n5 - n4 / 2, n, null);
        }
        graphics2D.dispose();
    }

    public static void paintHorizontalLines(Graphics graphics, Component component, SubstanceColorScheme substanceColorScheme, int n, Collection<Integer> collection, int n2, float f, boolean bl) {
        Object object;
        Graphics2D graphics2D;
        int n3 = SubstanceSizeUtils.getComponentFontSize(component);
        Color color = SubstanceColorUtilities.getBackgroundFillColor(component);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n3, substanceColorScheme.getDisplayName(), n2, 0, 1, true, 0.0, Float.valueOf(f), bl, color.getRGB());
        float f2 = SubstanceSizeUtils.getBorderStrokeWidth(n3);
        int n4 = (int)f2;
        BufferedImage bufferedImage = cached.get(hashMapKey);
        if (bufferedImage == null) {
            bufferedImage = SubstanceCoreUtilities.getBlankImage(n2, Math.max(2, (int)Math.ceil(2.0 * (double)f2)));
            graphics2D = bufferedImage.createGraphics();
            object = SeparatorPainterUtils.getSeparatorLightColor(substanceColorScheme);
            Color color2 = SeparatorPainterUtils.getSeparatorDarkColor(substanceColorScheme);
            Color color3 = SeparatorPainterUtils.getSeparatorShadowColor(substanceColorScheme);
            graphics2D.setStroke(new BasicStroke(f2, 0, 1));
            Color color4 = SubstanceColorUtilities.getInterpolatedColor((Color)object, color, 0.12);
            Color color5 = SubstanceColorUtilities.getInterpolatedColor(color2, color, 0.95);
            Color color6 = SubstanceColorUtilities.getInterpolatedColor(color3, color, 0.12);
            Color color7 = SubstanceColorUtilities.getInterpolatedColor(color3, color, 0.95);
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, n2, 0.0f, new float[]{0.0f, f, 1.0f}, new Color[]{bl ? color5 : color4, color5, bl ? color4 : color5});
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.drawLine(0, 0, n2, 0);
            LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(0.0f, 9.0f, n2, 0.0f, new float[]{0.0f, f, 1.0f}, new Color[]{bl ? color7 : color6, color7, bl ? color6 : color7});
            graphics2D.setPaint(linearGradientPaint2);
            graphics2D.drawLine(0, n4, n2, n4);
            graphics2D.dispose();
            cached.put(hashMapKey, bufferedImage);
        }
        graphics2D = (Graphics2D)graphics.create();
        object = collection.iterator();
        while (object.hasNext()) {
            int n5 = object.next();
            graphics2D.drawImage((Image)bufferedImage, n, n5 - n4 / 2, null);
        }
        graphics2D.dispose();
    }
}

