/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class DecorationPainterUtils {
    private static final String DECORATION_AREA_TYPE = "substancelaf.internal.painter.decorationAreaType";

    public static void setDecorationType(JComponent jComponent, DecorationAreaType decorationAreaType) {
        jComponent.putClientProperty(DECORATION_AREA_TYPE, decorationAreaType);
    }

    public static void clearDecorationType(JComponent jComponent) {
        if (jComponent != null) {
            jComponent.putClientProperty(DECORATION_AREA_TYPE, null);
        }
    }

    public static DecorationAreaType getDecorationType(Component component) {
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            JComponent jComponent;
            Object object;
            if (!(component2 instanceof JComponent) || !((object = (jComponent = (JComponent)component2).getClientProperty(DECORATION_AREA_TYPE)) instanceof DecorationAreaType)) continue;
            return (DecorationAreaType)object;
        }
        return DecorationAreaType.NONE;
    }

    public static DecorationAreaType getImmediateDecorationType(Component component) {
        JComponent jComponent;
        Object object;
        Component component2 = component;
        if (component2 instanceof JComponent && (object = (jComponent = (JComponent)component2).getClientProperty(DECORATION_AREA_TYPE)) instanceof DecorationAreaType) {
            return (DecorationAreaType)object;
        }
        return null;
    }

    public static void paintDecorationBackground(Graphics graphics, Component component, boolean bl) {
        DecorationAreaType decorationAreaType = SubstanceLookAndFeel.getDecorationType(component);
        DecorationPainterUtils.paintDecorationBackground(graphics, component, decorationAreaType, bl);
    }

    private static void paintDecorationBackground(Graphics graphics, Component component, DecorationAreaType decorationAreaType, boolean bl) {
        boolean bl2 = SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null;
        boolean bl3 = false;
        if (component instanceof JComponent) {
            bl3 = Boolean.TRUE.equals(((JComponent)component).getClientProperty("lafwidgets.internal.previewMode"));
        }
        if (!(bl || bl3 || component.isShowing() || bl2)) {
            return;
        }
        if (component.getHeight() == 0 || component.getWidth() == 0) {
            return;
        }
        SubstanceSkin substanceSkin = SubstanceCoreUtilities.getSkin(component);
        SubstanceDecorationPainter substanceDecorationPainter = substanceSkin.getDecorationPainter();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        substanceDecorationPainter.paintDecorationArea(graphics2D, component, decorationAreaType, component.getWidth(), component.getHeight(), substanceSkin);
        SubstanceWatermark substanceWatermark = SubstanceCoreUtilities.getSkin(component).getWatermark();
        if (substanceWatermark != null && !bl3 && !bl2 && component.isShowing() && SubstanceCoreUtilities.toDrawWatermark(component)) {
            substanceWatermark.drawWatermarkImage(graphics2D, component, 0, 0, component.getWidth(), component.getHeight());
            graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(component, 0.5f, graphics));
            substanceDecorationPainter.paintDecorationArea(graphics2D, component, decorationAreaType, component.getWidth(), component.getHeight(), substanceSkin);
        }
        graphics2D.dispose();
    }
}

