/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.socks;

import java.net.InetSocketAddress;
import org.apache.mina.proxy.handlers.ProxyRequest;
import org.apache.mina.proxy.handlers.socks.SocksProxyConstants;

public class SocksProxyRequest
extends ProxyRequest {
    private byte protocolVersion;
    private byte commandCode;
    private String userName;
    private String password;
    private String host;
    private int port;
    private String serviceKerberosName;

    public SocksProxyRequest(byte by, byte by2, InetSocketAddress inetSocketAddress, String string) {
        super(inetSocketAddress);
        this.protocolVersion = by;
        this.commandCode = by2;
        this.userName = string;
    }

    public SocksProxyRequest(byte by, String string, int n, String string2) {
        this.protocolVersion = (byte)4;
        this.commandCode = by;
        this.userName = string2;
        this.host = string;
        this.port = n;
    }

    public byte[] getIpAddress() {
        if (this.getEndpointAddress() == null) {
            return SocksProxyConstants.FAKE_IP;
        }
        return this.getEndpointAddress().getAddress().getAddress();
    }

    public byte[] getPort() {
        byte[] byArray = new byte[2];
        int n = this.getEndpointAddress() == null ? this.port : this.getEndpointAddress().getPort();
        byArray[1] = (byte)n;
        byArray[0] = (byte)(n >> 8);
        return byArray;
    }

    public byte getCommandCode() {
        return this.commandCode;
    }

    public byte getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getUserName() {
        return this.userName;
    }

    public final synchronized String getHost() {
        InetSocketAddress inetSocketAddress;
        if (this.host == null && (inetSocketAddress = this.getEndpointAddress()) != null && !inetSocketAddress.isUnresolved()) {
            this.host = this.getEndpointAddress().getHostName();
        }
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getServiceKerberosName() {
        return this.serviceKerberosName;
    }

    public void setServiceKerberosName(String string) {
        this.serviceKerberosName = string;
    }
}

