/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.polling;

import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.DefaultConnectFuture;
import org.apache.mina.core.service.AbstractIoConnector;
import org.apache.mina.core.service.AbstractIoService;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.SimpleIoProcessorPool;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.util.ExceptionMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPollingIoConnector<T extends AbstractIoSession, H>
extends AbstractIoConnector {
    private final Object lock = new Object();
    private final Queue<ConnectionRequest> connectQueue = new ConcurrentLinkedQueue<ConnectionRequest>();
    private final Queue<ConnectionRequest> cancelQueue = new ConcurrentLinkedQueue<ConnectionRequest>();
    private final IoProcessor<T> processor;
    private final boolean createdProcessor;
    private final AbstractIoService.ServiceOperationFuture disposalFuture = new AbstractIoService.ServiceOperationFuture();
    private volatile boolean selectable;
    private Connector connector;

    protected AbstractPollingIoConnector(IoSessionConfig ioSessionConfig, Class<? extends IoProcessor<T>> clazz) {
        this(ioSessionConfig, null, new SimpleIoProcessorPool(clazz), true);
    }

    private AbstractPollingIoConnector(IoSessionConfig ioSessionConfig, Executor executor, IoProcessor<T> ioProcessor, boolean bl) {
        super(ioSessionConfig, executor);
        if (ioProcessor == null) {
            throw new IllegalArgumentException("processor");
        }
        this.processor = ioProcessor;
        this.createdProcessor = bl;
        try {
            this.init();
            this.selectable = true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeIoException("Failed to initialize.", exception);
        }
        finally {
            if (!this.selectable) {
                try {
                    this.destroy();
                }
                catch (Exception exception) {
                    ExceptionMonitor.getInstance().exceptionCaught(exception);
                }
            }
        }
    }

    protected abstract void init() throws Exception;

    protected abstract void destroy() throws Exception;

    protected abstract H newHandle(SocketAddress var1) throws Exception;

    protected abstract boolean connect(H var1, SocketAddress var2) throws Exception;

    protected abstract boolean finishConnect(H var1) throws Exception;

    protected abstract T newSession(IoProcessor<T> var1, H var2) throws Exception;

    protected abstract void close(H var1) throws Exception;

    protected abstract void wakeup();

    protected abstract int select(int var1) throws Exception;

    protected abstract Iterator<H> selectedHandles();

    protected abstract Iterator<H> allHandles();

    protected abstract void register(H var1, ConnectionRequest var2) throws Exception;

    protected abstract ConnectionRequest getConnectionRequest(H var1);

    @Override
    protected final void dispose0() throws Exception {
        this.startupWorker();
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final ConnectFuture connect0(SocketAddress socketAddress, SocketAddress socketAddress2, IoSessionInitializer<? extends ConnectFuture> ioSessionInitializer) {
        H h = null;
        boolean bl = false;
        try {
            h = this.newHandle(socketAddress2);
            if (this.connect(h, socketAddress)) {
                DefaultConnectFuture defaultConnectFuture = new DefaultConnectFuture();
                T t = this.newSession(this.processor, h);
                this.initSession((IoSession)t, defaultConnectFuture, ioSessionInitializer);
                ((AbstractIoSession)t).getProcessor().add(t);
                bl = true;
                DefaultConnectFuture defaultConnectFuture2 = defaultConnectFuture;
                return defaultConnectFuture2;
            }
            bl = true;
        }
        catch (Exception exception) {
            ConnectFuture connectFuture = DefaultConnectFuture.newFailedFuture(exception);
            return connectFuture;
        }
        finally {
            if (!bl && h != null) {
                try {
                    this.close(h);
                }
                catch (Exception exception) {
                    ExceptionMonitor.getInstance().exceptionCaught(exception);
                }
            }
        }
        ConnectionRequest connectionRequest = new ConnectionRequest(h, ioSessionInitializer);
        this.connectQueue.add(connectionRequest);
        this.startupWorker();
        this.wakeup();
        return connectionRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() {
        if (!this.selectable) {
            this.connectQueue.clear();
            this.cancelQueue.clear();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.connector == null) {
                this.connector = new Connector();
                this.executeWorker(this.connector);
            }
        }
    }

    private int registerNew() {
        ConnectionRequest connectionRequest;
        int n = 0;
        while ((connectionRequest = this.connectQueue.poll()) != null) {
            Object object = connectionRequest.handle;
            try {
                this.register(object, connectionRequest);
                ++n;
            }
            catch (Exception exception) {
                connectionRequest.setException(exception);
                try {
                    this.close(object);
                }
                catch (Exception exception2) {
                    ExceptionMonitor.getInstance().exceptionCaught(exception2);
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cancelKeys() {
        ConnectionRequest connectionRequest;
        int n = 0;
        while ((connectionRequest = this.cancelQueue.poll()) != null) {
            Object object = connectionRequest.handle;
            try {
                this.close(object);
            }
            catch (Exception exception) {
                ExceptionMonitor.getInstance().exceptionCaught(exception);
            }
            finally {
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processConnections(Iterator<H> iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            H h = iterator.next();
            iterator.remove();
            ConnectionRequest connectionRequest = this.getConnectionRequest(h);
            if (connectionRequest == null) continue;
            boolean bl = false;
            try {
                if (this.finishConnect(h)) {
                    T t = this.newSession(this.processor, h);
                    this.initSession((IoSession)t, connectionRequest, connectionRequest.getSessionInitializer());
                    ((AbstractIoSession)t).getProcessor().add(t);
                    ++n;
                }
                bl = true;
            }
            catch (Throwable throwable) {
                connectionRequest.setException(throwable);
            }
            finally {
                if (bl) continue;
                this.cancelQueue.offer(connectionRequest);
            }
        }
        return n;
    }

    private void processTimedOutSessions(Iterator<H> iterator) {
        long l = System.currentTimeMillis();
        while (iterator.hasNext()) {
            H h = iterator.next();
            ConnectionRequest connectionRequest = this.getConnectionRequest(h);
            if (connectionRequest == null || l < connectionRequest.deadline) continue;
            connectionRequest.setException(new ConnectException("Connection timed out."));
            this.cancelQueue.offer(connectionRequest);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ConnectionRequest
    extends DefaultConnectFuture {
        private final H handle;
        private final long deadline;
        private final IoSessionInitializer<? extends ConnectFuture> sessionInitializer;

        public ConnectionRequest(H h, IoSessionInitializer<? extends ConnectFuture> ioSessionInitializer) {
            this.handle = h;
            long l = AbstractPollingIoConnector.this.getConnectTimeoutMillis();
            this.deadline = l <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + l;
            this.sessionInitializer = ioSessionInitializer;
        }

        public IoSessionInitializer<? extends ConnectFuture> getSessionInitializer() {
            return this.sessionInitializer;
        }

        @Override
        public void cancel() {
            if (!this.isDone()) {
                super.cancel();
                AbstractPollingIoConnector.this.cancelQueue.add(this);
                AbstractPollingIoConnector.this.startupWorker();
                AbstractPollingIoConnector.this.wakeup();
            }
        }
    }

    private class Connector
    implements Runnable {
        private Connector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int n = 0;
            while (AbstractPollingIoConnector.this.selectable) {
                try {
                    int n2 = (int)Math.min(AbstractPollingIoConnector.this.getConnectTimeoutMillis(), 1000L);
                    int n3 = AbstractPollingIoConnector.this.select(n2);
                    n += AbstractPollingIoConnector.this.registerNew();
                    if (n3 > 0) {
                        n -= AbstractPollingIoConnector.this.processConnections(AbstractPollingIoConnector.this.selectedHandles());
                    }
                    AbstractPollingIoConnector.this.processTimedOutSessions(AbstractPollingIoConnector.this.allHandles());
                    if ((n -= AbstractPollingIoConnector.this.cancelKeys()) != 0) continue;
                    Object object = AbstractPollingIoConnector.this.lock;
                    synchronized (object) {
                        if (AbstractPollingIoConnector.this.connectQueue.isEmpty()) {
                            AbstractPollingIoConnector.this.connector = null;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    ExceptionMonitor.getInstance().exceptionCaught(throwable);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        ExceptionMonitor.getInstance().exceptionCaught(interruptedException);
                    }
                }
            }
            if (!AbstractPollingIoConnector.this.selectable) return;
            if (!AbstractPollingIoConnector.this.isDisposing()) return;
            AbstractPollingIoConnector.this.selectable = false;
            try {
                if (!AbstractPollingIoConnector.this.createdProcessor) return;
                AbstractPollingIoConnector.this.processor.dispose();
                return;
            }
            finally {
                try {
                    Object object = AbstractPollingIoConnector.this.disposalLock;
                    synchronized (object) {
                        if (AbstractPollingIoConnector.this.isDisposing()) {
                            AbstractPollingIoConnector.this.destroy();
                        }
                    }
                }
                catch (Exception exception) {
                    ExceptionMonitor.getInstance().exceptionCaught(exception);
                }
                finally {
                    AbstractPollingIoConnector.this.disposalFuture.setDone();
                }
            }
        }
    }
}

