/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.util;

import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.MapConfig;
import amazon.fws.clicommando.config.MapKeyConfig;
import amazon.fws.clicommando.config.OptionConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpUtils {
    public static String getSynopsis(CommandConfig cmdConfig) {
        ArrayList<String> printables = new ArrayList<String>();
        for (ParamConfig arg : cmdConfig.getArgumentsSortedByIndex()) {
            String argRepresentation;
            if (arg.isUndocumented()) continue;
            String string = argRepresentation = arg.getType().singleValue() ? HelpUtils.singleValueSynopsisRep(arg.getName()) : HelpUtils.multiValueSynopsisRep(arg.getName());
            if (arg.isRequired().booleanValue()) {
                printables.add(" " + argRepresentation + "");
                continue;
            }
            printables.add("[" + argRepresentation + "]");
        }
        boolean hasGenOptions = false;
        ArrayList<String> optionCategories = new ArrayList<String>();
        for (ParamConfig opt : cmdConfig.getOptParamsSortedByRequired()) {
            if (!opt.isDirective().booleanValue() && !opt.isUndocumented()) {
                List<String> value = HelpUtils.getValueForOpt(opt);
                if (opt.isRequired().booleanValue()) {
                    printables.add(" " + HelpUtils.printLongOrShortValueOption("", opt) + "");
                    printables.addAll(value);
                } else {
                    printables.add("[" + HelpUtils.printLongOrShortValueOption("", opt));
                    printables.addAll(value);
                    printables.add("]");
                }
            }
            if (!optionCategories.contains(opt.getContextTitle())) {
                optionCategories.add(opt.getContextTitle());
            }
            if (!opt.getContextTitle().equals("GENERAL OPTIONS")) continue;
            hasGenOptions = true;
        }
        if (hasGenOptions) {
            printables.add(" [General Options]");
        }
        String[] strArr = new String[printables.size()];
        printables.toArray(strArr);
        return cmdConfig.getName() + "\n" + StringUtils.formatTextColumn(strArr, "      ");
    }

    public static String printLongOrShortValueOption(String valueSet, ParamConfig param) {
        String ret = "";
        if (param.getType() == ParamConfig.Type.SWITCH) {
            ret = "--";
            StringBuffer optList = new StringBuffer();
            for (OptionConfig opt : param.getOptions()) {
                String longOpt = opt.getLongOpt();
                String shortOpt = opt.getShortOpt();
                if (StringUtils.notEmpty(longOpt)) {
                    optList.append(longOpt + "/");
                    continue;
                }
                if (!StringUtils.notEmpty(shortOpt)) continue;
                optList.append(shortOpt + "/");
            }
            if ((ret = ret + optList.toString()).endsWith("/")) {
                ret = ret.substring(0, ret.length() - 1);
            }
        } else {
            OptionConfig option = param.getFirstOption();
            String longOpt = option.getLongOpt();
            String shortOpt = option.getShortOpt();
            if (StringUtils.notEmpty(longOpt)) {
                ret = "--" + longOpt + " " + valueSet;
            } else if (StringUtils.notEmpty(shortOpt)) {
                ret = "-" + shortOpt + " " + valueSet;
            }
        }
        return ret;
    }

    public static List<String> getValueForOpt(ParamConfig pc) {
        Vector<String> ret = new Vector<String>();
        switch (pc.getType()) {
            case SIMPLE: {
                ret.add("value");
                break;
            }
            case SWITCH: {
                ret.add("");
                break;
            }
            case MULTIPLE: {
                OptionConfig optionConfig = pc.getFirstOption();
                String valueSeparator = "";
                if (optionConfig != null) {
                    valueSeparator = optionConfig.getValueSeparator();
                }
                ret.add("value[" + valueSeparator + "value...]");
                break;
            }
            case MAP: {
                ret = HelpUtils.getMapValueForOpt(pc);
                break;
            }
            default: {
                ret.add("value");
            }
        }
        return ret;
    }

    public static List<String> getMapValueForOpt(ParamConfig pc) {
        OptionConfig opt = pc.getFirstOption();
        String eq = opt.getKeyValueSeparator();
        String mapSep = opt.getValueSeparator();
        String mapEntrySep = opt.getMapEntrySeparator();
        boolean isMultiMap = mapSep != null && !mapSep.equals("");
        Vector<String> required = new Vector<String>();
        Vector<String> optional = new Vector<String>();
        MapConfig mapConfig = pc.getMapConfig();
        String noKeysDefined = mapConfig.getKey("*") == null && mapConfig.getKeys().size() > 0 ? "" : "key1" + eq + "value1" + mapEntrySep + "key2" + eq + "value2...";
        for (String keyName : mapConfig.getKeys().keySet()) {
            MapKeyConfig key = mapConfig.getKey(keyName);
            if (key.isRequired()) {
                required.add(key.getName() + eq + "value");
                continue;
            }
            if ("*".equals(key.getName())) continue;
            optional.add("[" + key.getName() + eq + "value" + "]");
        }
        Vector<String> retVal = new Vector<String>();
        for (String entry : required) {
            retVal.add(entry);
            HelpUtils.addSepar(retVal, mapEntrySep);
        }
        for (String entry : optional) {
            retVal.add(entry);
            HelpUtils.addSepar(retVal, mapEntrySep);
        }
        if (StringUtils.notEmpty(noKeysDefined)) {
            if (retVal.size() > 0) {
                retVal.add("[" + noKeysDefined + "]");
            } else {
                retVal.add(noKeysDefined);
            }
            HelpUtils.addSepar(retVal, mapEntrySep);
        }
        if (retVal.size() > 0) {
            String firstEntry = (String)retVal.get(0);
            retVal.set(0, "\"" + firstEntry.trim());
            int lastEntryIndex = retVal.size() - 1;
            String lastEntry = (String)retVal.get(lastEntryIndex);
            retVal.set(lastEntryIndex, lastEntry.trim() + "\"");
        }
        if (isMultiMap) {
            String longOpt = opt.getLongOpt();
            String shortOpt = opt.getShortOpt();
            if (StringUtils.isEmpty(longOpt) && StringUtils.isEmpty(shortOpt)) {
                throw new ConfigurationErrorException("No option defined for parameter: " + pc.getName());
            }
            retVal.add("[" + mapSep + (StringUtils.notEmpty(longOpt) ? "--" + longOpt : "-" + shortOpt));
            int lim = retVal.size() - 1;
            for (int i = 0; i < lim; ++i) {
                retVal.add((String)retVal.get(i));
            }
            retVal.add("...]");
        }
        return retVal;
    }

    private static void addSepar(List<String> values, String separ) {
        int previous = values.size() - 2;
        if (previous >= 0) {
            values.set(previous, values.get(previous) + separ);
        }
    }

    public static String printLongOrShortValueOption(ParamConfig param) {
        return HelpUtils.printLongOrShortValueOption(null, param);
    }

    private static String singleValueSynopsisRep(String arg) {
        return arg;
    }

    private static String multiValueSynopsisRep(String arg) {
        return arg + " [" + arg + " ...] ";
    }
}

