/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmEnvironment;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.project.ProjectInternal;

final class JavaEcosystemAttributesDescriber
implements AttributeDescriber {
    private final ImmutableSet<Attribute<?>> describableAttributes = ImmutableSet.of((Object)Usage.USAGE_ATTRIBUTE, (Object)Category.CATEGORY_ATTRIBUTE, (Object)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)Bundling.BUNDLING_ATTRIBUTE, (Object)TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, (Object)TargetJvmEnvironment.TARGET_JVM_ENVIRONMENT_ATTRIBUTE, (Object[])new Attribute[]{DocsType.DOCS_TYPE_ATTRIBUTE, ProjectInternal.STATUS_ATTRIBUTE});

    JavaEcosystemAttributesDescriber() {
    }

    public boolean isDescribable(Attribute<?> attribute) {
        return this.describableAttributes.stream().anyMatch(describableAttribute -> JavaEcosystemAttributesDescriber.haveSameName(attribute, describableAttribute));
    }

    public ImmutableSet<Attribute<?>> getDescribableAttributes() {
        return this.describableAttributes;
    }

    public String describeAttributeSet(Map<Attribute<?>, ?> attributes) {
        Object category = JavaEcosystemAttributesDescriber.extractAttributeValue(attributes, Category.CATEGORY_ATTRIBUTE);
        Object usage = JavaEcosystemAttributesDescriber.extractAttributeValue(attributes, Usage.USAGE_ATTRIBUTE);
        Object le = JavaEcosystemAttributesDescriber.extractAttributeValue(attributes, LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE);
        Object bundling = JavaEcosystemAttributesDescriber.extractAttributeValue(attributes, Bundling.BUNDLING_ATTRIBUTE);
        Object targetJvmEnvironment = JavaEcosystemAttributesDescriber.extractAttributeValue(attributes, TargetJvmEnvironment.TARGET_JVM_ENVIRONMENT_ATTRIBUTE);
        Object targetJvm = JavaEcosystemAttributesDescriber.extractAttributeValue(attributes, TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE);
        Object docsType = JavaEcosystemAttributesDescriber.extractAttributeValue(attributes, DocsType.DOCS_TYPE_ATTRIBUTE);
        Object status = JavaEcosystemAttributesDescriber.extractAttributeValue(attributes, ProjectInternal.STATUS_ATTRIBUTE);
        StringBuilder sb = new StringBuilder();
        if (category != null) {
            if (docsType != null && JavaEcosystemAttributesDescriber.toName(category).equals("documentation")) {
                JavaEcosystemAttributesDescriber.describeDocsType(docsType, sb);
            } else {
                JavaEcosystemAttributesDescriber.describeCategory(category, sb);
            }
        } else if (docsType != null && category == null) {
            JavaEcosystemAttributesDescriber.describeDocsType(docsType, sb);
        } else {
            sb.append("a component");
        }
        if (usage != null) {
            sb.append(" for use during ");
            JavaEcosystemAttributesDescriber.describeUsage(usage, sb);
        }
        if (status != null) {
            sb.append(", with a ");
            JavaEcosystemAttributesDescriber.describeStatus(status, sb);
        }
        if (targetJvm != null) {
            sb.append(", compatible with ");
            JavaEcosystemAttributesDescriber.describeTargetJvm(targetJvm, sb);
        }
        if (le != null) {
            sb.append(", ");
            JavaEcosystemAttributesDescriber.describeLibraryElements(le, sb);
        }
        if (targetJvmEnvironment != null) {
            sb.append(", preferably optimized for ");
            JavaEcosystemAttributesDescriber.describeTargetJvmEnvironment(targetJvmEnvironment, sb);
        }
        if (bundling != null) {
            sb.append(", and ");
            JavaEcosystemAttributesDescriber.describeBundling(bundling, sb);
        }
        this.processExtraAttributes(attributes, sb);
        return sb.toString();
    }

    private static void describeStatus(Object status, StringBuilder sb) {
        sb.append(JavaEcosystemAttributesDescriber.toName(status)).append(" status");
    }

    @Nullable
    private static <T> Object extractAttributeValue(Map<Attribute<?>, ?> attributes, Attribute<T> attribute) {
        return attributes.entrySet().stream().filter(e -> JavaEcosystemAttributesDescriber.haveSameName((Attribute)e.getKey(), attribute)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    private void processExtraAttributes(Map<Attribute<?>, ?> attributes, StringBuilder sb) {
        List describableAttributes = attributes.keySet().stream().filter(a -> !this.isDescribable((Attribute<?>)a)).sorted(Comparator.comparing(Attribute::getName)).collect(Collectors.toList());
        if (!describableAttributes.isEmpty()) {
            sb.append(", as well as ");
            boolean comma = false;
            for (Attribute attribute : describableAttributes) {
                if (comma) {
                    sb.append(", ");
                }
                JavaEcosystemAttributesDescriber.describeGenericAttribute(sb, attribute, JavaEcosystemAttributesDescriber.extractAttributeValue(attributes, attribute));
                comma = true;
            }
        }
    }

    @Nullable
    public String describeMissingAttribute(Attribute<?> attribute, Object consumerValue) {
        StringBuilder sb = new StringBuilder();
        if (JavaEcosystemAttributesDescriber.haveSameName(Usage.USAGE_ATTRIBUTE, attribute)) {
            sb.append("its usage (required ");
            JavaEcosystemAttributesDescriber.describeUsage(consumerValue, sb);
            sb.append(")");
        } else if (JavaEcosystemAttributesDescriber.haveSameName(TargetJvmEnvironment.TARGET_JVM_ENVIRONMENT_ATTRIBUTE, attribute)) {
            sb.append("its target Java environment (preferred optimized for ");
            JavaEcosystemAttributesDescriber.describeTargetJvmEnvironment(consumerValue, sb);
            sb.append(")");
        } else if (JavaEcosystemAttributesDescriber.haveSameName(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, attribute)) {
            sb.append("its target Java version (required compatibility with ");
            JavaEcosystemAttributesDescriber.describeTargetJvm(consumerValue, sb);
            sb.append(")");
        } else if (JavaEcosystemAttributesDescriber.haveSameName(Category.CATEGORY_ATTRIBUTE, attribute)) {
            sb.append("its component category (required ");
            JavaEcosystemAttributesDescriber.describeCategory(consumerValue, sb);
            sb.append(")");
        } else if (JavaEcosystemAttributesDescriber.haveSameName(Bundling.BUNDLING_ATTRIBUTE, attribute)) {
            sb.append("how its dependencies are found (required ");
            JavaEcosystemAttributesDescriber.describeBundling(consumerValue, sb);
            sb.append(")");
        } else if (JavaEcosystemAttributesDescriber.haveSameName(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, attribute)) {
            sb.append("its elements (required them ");
            JavaEcosystemAttributesDescriber.describeLibraryElements(consumerValue, sb);
            sb.append(")");
        } else if (JavaEcosystemAttributesDescriber.haveSameName(DocsType.DOCS_TYPE_ATTRIBUTE, attribute)) {
            sb.append("the documentation type (required ");
            JavaEcosystemAttributesDescriber.describeDocsType(consumerValue, sb);
            sb.append(")");
        } else if (JavaEcosystemAttributesDescriber.haveSameName(ProjectInternal.STATUS_ATTRIBUTE, attribute)) {
            sb.append("its status (required ");
            JavaEcosystemAttributesDescriber.describeStatus(consumerValue, sb);
            sb.append(")");
        } else {
            return null;
        }
        return sb.toString();
    }

    private static void describeGenericAttribute(StringBuilder sb, Attribute<?> attribute, @Nullable Object value) {
        sb.append("attribute '").append(attribute.getName()).append("' with value '").append(value).append("'");
    }

    public String describeExtraAttribute(Attribute<?> attribute, Object producerValue) {
        StringBuilder sb = new StringBuilder();
        if (JavaEcosystemAttributesDescriber.haveSameName(Usage.USAGE_ATTRIBUTE, attribute)) {
            JavaEcosystemAttributesDescriber.describeUsage(producerValue, sb);
        } else if (JavaEcosystemAttributesDescriber.haveSameName(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, attribute)) {
            sb.append("compatibility with ");
            JavaEcosystemAttributesDescriber.describeTargetJvm(producerValue, sb);
        } else if (JavaEcosystemAttributesDescriber.haveSameName(Category.CATEGORY_ATTRIBUTE, attribute)) {
            JavaEcosystemAttributesDescriber.describeCategory(producerValue, sb);
        } else if (JavaEcosystemAttributesDescriber.haveSameName(DocsType.DOCS_TYPE_ATTRIBUTE, attribute)) {
            JavaEcosystemAttributesDescriber.describeDocsType(producerValue, sb);
        } else if (JavaEcosystemAttributesDescriber.haveSameName(ProjectInternal.STATUS_ATTRIBUTE, attribute)) {
            JavaEcosystemAttributesDescriber.describeStatus(producerValue, sb);
        } else if (JavaEcosystemAttributesDescriber.haveSameName(Bundling.BUNDLING_ATTRIBUTE, attribute)) {
            JavaEcosystemAttributesDescriber.describeBundling(producerValue, sb);
        } else if (JavaEcosystemAttributesDescriber.haveSameName(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, attribute)) {
            sb.append("its elements ");
            JavaEcosystemAttributesDescriber.describeLibraryElements(producerValue, sb);
        } else {
            JavaEcosystemAttributesDescriber.describeGenericAttribute(sb, attribute, producerValue);
        }
        return sb.toString();
    }

    private static void describeBundling(Object bundling, StringBuilder sb) {
        String name;
        switch (name = JavaEcosystemAttributesDescriber.toName(bundling)) {
            case "external": {
                sb.append("its dependencies declared externally");
                break;
            }
            case "embedded": {
                sb.append("its dependencies bundled (fat jar)");
                break;
            }
            case "shadowed": {
                sb.append("its dependencies repackaged (shadow jar)");
                break;
            }
            default: {
                sb.append("its dependencies found as '").append(name).append("'");
            }
        }
    }

    private static void describeLibraryElements(Object le, StringBuilder sb) {
        String name;
        switch (name = JavaEcosystemAttributesDescriber.toName(le)) {
            case "jar": {
                sb.append("packaged as a jar");
                break;
            }
            case "classes": {
                sb.append("preferably in the form of class files");
                break;
            }
            case "resources": {
                sb.append("preferably only the resources files");
                break;
            }
            case "classes+resources": {
                sb.append("preferably not packaged as a jar");
                break;
            }
            default: {
                sb.append("with the library elements '").append(name).append("'");
            }
        }
    }

    private static void describeUsage(Object usage, StringBuilder sb) {
        String str;
        switch (str = JavaEcosystemAttributesDescriber.toName(usage)) {
            case "java-api": 
            case "java-api-jars": 
            case "java-api-classes": {
                sb.append("compile-time");
                break;
            }
            case "java-runtime": 
            case "java-runtime-jars": 
            case "java-runtime-classes": {
                sb.append("runtime");
                break;
            }
            default: {
                sb.append("'").append(str).append("'");
            }
        }
    }

    private static void describeTargetJvm(Object targetJvm, StringBuilder sb) {
        if (targetJvm.equals(Integer.MAX_VALUE)) {
            sb.append("any Java version");
        } else {
            sb.append("Java ").append(targetJvm);
        }
    }

    private static void describeTargetJvmEnvironment(Object targetJvmEnvironment, StringBuilder sb) {
        String name;
        switch (name = JavaEcosystemAttributesDescriber.toName(targetJvmEnvironment)) {
            case "standard-jvm": {
                sb.append("standard JVMs");
                break;
            }
            case "android": {
                sb.append("Android");
                break;
            }
            default: {
                sb.append(name);
            }
        }
    }

    private static void describeCategory(Object category, StringBuilder sb) {
        String name;
        switch (name = JavaEcosystemAttributesDescriber.toName(category)) {
            case "library": {
                sb.append("a library");
                break;
            }
            case "platform": {
                sb.append("a platform");
                break;
            }
            case "enforced-platform": {
                sb.append("an enforced platform");
                break;
            }
            case "documentation": {
                sb.append("documentation");
                break;
            }
            default: {
                sb.append("a component of category '").append(name).append("'");
            }
        }
    }

    private static void describeDocsType(Object docsType, StringBuilder sb) {
        String name;
        switch (name = JavaEcosystemAttributesDescriber.toName(docsType)) {
            case "javadoc": {
                sb.append("javadocs");
                break;
            }
            case "sources": {
                sb.append("sources");
                break;
            }
            case "user-manual": {
                sb.append("a user manual");
                break;
            }
            case "samples": {
                sb.append("samples");
                break;
            }
            case "doxygen": {
                sb.append("doxygen documentation");
                break;
            }
            default: {
                sb.append("documentation of type '").append(name).append("'");
            }
        }
    }

    private static String toName(Object attributeValue) {
        return attributeValue instanceof Category ? ((Named)attributeValue).getName() : String.valueOf(attributeValue);
    }

    private static boolean haveSameName(Attribute<?> a, Attribute<?> b) {
        return Objects.equals(a.getName(), b.getName());
    }
}

