/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.GEF;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.gantt2.gefext.FreeformRootEditPart;
import org.xmind.ui.gantt2.gefext.IConnectionManager;
import org.xmind.ui.gantt2.gefext.IConnectionRouter;
import org.xmind.ui.gantt2.viewer.BackgroundLayout;
import org.xmind.ui.gantt2.viewer.DependencyConnectionManager;
import org.xmind.ui.gantt2.viewer.DependencyPathRouter;
import org.xmind.ui.gantt2.viewer.OffsetVerticalToolbarLayout;
import org.xmind.ui.gantt2.viewer.ShadowAndLineLayer;
import org.xmind.ui.gantt2.viewer.TaskBarBackgroundLayout;
import org.xmind.ui.gantt2.viewer.TaskBarViewer;

public class TaskBarRootPart
extends FreeformRootEditPart
implements AncestorListener {
    private IConnectionRouter dependencyRouter = new DependencyPathRouter();
    private IConnectionManager connectionManager = new DependencyConnectionManager(this, this, this.dependencyRouter);

    protected void addLayers(LayeredPane layeredPane) {
        layeredPane.add((IFigure)new ShadowAndLineLayer(), TaskBarViewer.LAYER_BACKGROUND_SHADOW);
        layeredPane.add(this.createBackgroundLayer(), GEF.LAYER_BACKGROUND);
        layeredPane.add((IFigure)new ShadowAndLineLayer(), TaskBarViewer.LAYER_BACKGROUND_LINE);
        layeredPane.add((IFigure)new FreeformLayer(), TaskBarViewer.LAYER_DEPENDENCIES);
        layeredPane.add((IFigure)this.createContentsLayer(), GEF.LAYER_CONTENTS);
        layeredPane.add((IFigure)new FreeformLayer(), GEF.LAYER_FEEDBACK);
        layeredPane.add((IFigure)new ShadowAndLineLayer(), TaskBarViewer.LAYER_TIMELINE);
        layeredPane.add((IFigure)new FreeformLayer(), GEF.LAYER_HANDLE);
    }

    private IFigure createBackgroundLayer() {
        FreeformLayer layer = new FreeformLayer();
        layer.setLayoutManager((LayoutManager)new TaskBarBackgroundLayout());
        layer.add(this.createPinFigure(), TaskBarBackgroundLayout.CONSTRAINT_TOP_LEFT);
        layer.add(this.createPinFigure(), TaskBarBackgroundLayout.CONSTRAINT_TOP_RIGHT);
        return layer;
    }

    private IFigure createPinFigure() {
        return new Figure();
    }

    private Layer createContentsLayer() {
        FreeformLayer layer = new FreeformLayer();
        layer.setLayoutManager((LayoutManager)new ContentsLayout());
        return layer;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IConnectionRouter.class) {
            return this.dependencyRouter;
        }
        if (adapter == IConnectionManager.class) {
            return this.connectionManager;
        }
        if (adapter == ITopic.class) {
            return this.getViewer().getInput();
        }
        if (adapter == IWorkbook.class) {
            return ((ITopic)this.getViewer().getInput()).getOwnedWorkbook();
        }
        if (adapter == ISheet.class) {
            return ((ITopic)this.getViewer().getInput()).getOwnedSheet();
        }
        return super.getAdapter(adapter);
    }

    protected void addChildView(IPart child, int index) {
        super.addChildView(child, index);
        IFigure contentsFigure = ((IGraphicalPart)child).getFigure();
        contentsFigure.addAncestorListener((AncestorListener)this);
        this.getBackgroundLayout().setContents(contentsFigure);
    }

    private BackgroundLayout getBackgroundLayout() {
        return (BackgroundLayout)this.getLayer(GEF.LAYER_BACKGROUND).getLayoutManager();
    }

    protected void removeChildView(IPart child) {
        IFigure contentsFigure = ((IGraphicalPart)child).getFigure();
        contentsFigure.removeAncestorListener((AncestorListener)this);
        if (contentsFigure == this.getBackgroundLayout().getContents()) {
            this.getBackgroundLayout().setContents(null);
        }
        super.removeChildView(child);
    }

    public void ancestorAdded(IFigure ancestor) {
    }

    public void ancestorMoved(IFigure ancestor) {
        this.getLayer(GEF.LAYER_BACKGROUND).revalidate();
    }

    public void ancestorRemoved(IFigure ancestor) {
    }

    private static class ContentsLayout
    extends OffsetVerticalToolbarLayout {
        private ContentsLayout() {
        }

        protected int getVerticalOrigin(IFigure container, Rectangle clientArea) {
            return 0;
        }
    }
}

