/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.tabfolder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.tabfolder.MTabBarItem;
import org.xmind.ui.util.IStyleProvider;
import org.xmind.ui.util.StyleProvider;

public class MTabBar
extends Composite {
    public static final String MARGIN = "margin";
    public static final String BORDER = "border";
    public static final String PADDING = "padding";
    public static final String SEPARATOR = "separator";
    public static final String CORNER = "corner";
    private List<MTabBarItem> items;
    private int selectedIndex = -1;
    private boolean vertical = false;
    private IStyleProvider styleProvider = new StyleProvider();
    private boolean usingDefaultStyles = true;
    private MTabBarItem trackedItem = null;
    private int marginWidth = 0;
    private int marginHeight = 0;
    private int borderWidth = 0;
    private int paddingWidth = 0;
    private int paddingHeight = 0;
    private int hSpacing = 0;
    private int vSpacing = 0;
    private int cornerWidth = 0;
    private int cornerHeight = 0;
    private Rectangle[] separators = null;
    private Listener listener;
    private boolean inDispose;
    private ResourceManager resources;

    public MTabBar(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.items = new ArrayList<MTabBarItem>();
        super.setLayout((Layout)new MTabBarLayout());
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        MTabBar.this.onDispose(event);
                        break;
                    }
                    case 11: {
                        MTabBar.this.onResize(event);
                        break;
                    }
                    case 9: {
                        MTabBar.this.onPaint(event);
                        break;
                    }
                    case 6: {
                        MTabBar.this.onMouseEnter(event);
                        break;
                    }
                    case 7: {
                        MTabBar.this.onMouseExit(event);
                        break;
                    }
                    case 5: {
                        MTabBar.this.onMouseMove(event);
                        break;
                    }
                    case 3: {
                        MTabBar.this.onMouseDown(event);
                        break;
                    }
                    case 4: {
                        MTabBar.this.onMouseUp(event);
                    }
                }
            }
        };
        this.addListener(12, this.listener);
        this.addListener(11, this.listener);
        this.addListener(9, this.listener);
        this.addListener(6, this.listener);
        this.addListener(7, this.listener);
        this.addListener(5, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public MTabBarItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new MTabBarItem[this.items.size()]);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public MTabBarItem getSelection() {
        this.checkWidget();
        return this.selectedIndex < 0 ? null : this.items.get(this.selectedIndex);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.selectedIndex;
    }

    public int indexOf(MTabBarItem item) {
        this.checkWidget();
        if (item == null) {
            return -1;
        }
        return this.items.indexOf((Object)item);
    }

    public MTabBarItem getItem(int index) {
        this.checkWidget();
        return index < 0 || index >= this.items.size() ? null : this.items.get(index);
    }

    public MTabBarItem getItem(Point pt) {
        this.checkWidget();
        return this.getItem(pt.x, pt.y);
    }

    private MTabBarItem getItem(int x, int y) {
        for (MTabBarItem item : this.items) {
            if (!item.getVisible() || !item.getBounds().contains(x, y)) continue;
            return item;
        }
        return null;
    }

    public void setSelection(MTabBarItem item) {
        this.checkWidget();
        if (item != null && !item.isRadioButton()) {
            return;
        }
        MTabBarItem oldItem = this.getSelection();
        this.selectedIndex = this.indexOf(item);
        if (oldItem != null) {
            oldItem.setSelected(false);
        }
        if (item != null) {
            item.setSelected(true);
        }
    }

    public boolean isVertical() {
        this.checkWidget();
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.checkWidget();
        if (vertical == this.vertical) {
            return;
        }
        this.vertical = vertical;
        this.updateTabBar();
    }

    public IStyleProvider getStyleProvider() {
        this.checkWidget();
        return this.styleProvider;
    }

    public void setStyleProvider(IStyleProvider styleProvider) {
        IStyleProvider oldStyleProvider;
        this.checkWidget();
        IStyleProvider iStyleProvider = oldStyleProvider = this.usingDefaultStyles ? null : this.styleProvider;
        if (styleProvider == oldStyleProvider) {
            return;
        }
        if (styleProvider != null) {
            this.styleProvider = styleProvider;
            this.usingDefaultStyles = false;
        } else {
            this.styleProvider = new StyleProvider();
            this.usingDefaultStyles = true;
        }
        this.reskin(0);
        this.pack(false);
        this.updateTabBar();
    }

    protected void createItem(MTabBarItem item, int index) {
        this.items.add(index, item);
        if (item.isRadioButton()) {
            boolean isPrimary = true;
            for (MTabBarItem it : this.items) {
                if (it == item || !it.isRadioButton()) continue;
                isPrimary = false;
                break;
            }
            if (isPrimary) {
                this.selectedIndex = this.items.indexOf((Object)item);
                item.setSelected(true);
            }
        }
        this.layout(true);
        this.redraw();
    }

    protected void destroyItem(MTabBarItem item) {
        if (this.inDispose) {
            return;
        }
        int index = this.indexOf(item);
        if (index < 0) {
            return;
        }
        if (index == this.selectedIndex) {
            int nextIndex = -1;
            MTabBarItem next = null;
            int j = index + 1;
            while (j < this.items.size()) {
                next = this.items.get(j);
                if (next.isRadioButton()) {
                    nextIndex = j;
                    break;
                }
                ++j;
            }
            if (nextIndex < 0) {
                j = index - 1;
                while (j >= 0) {
                    next = this.items.get(j);
                    if (next.isRadioButton()) {
                        nextIndex = j;
                        break;
                    }
                    --j;
                }
            }
            if (nextIndex >= 0) {
                next.setSelected(true);
            }
            this.selectedIndex = nextIndex;
        }
        this.items.remove(index);
        this.layout(true);
        this.redraw();
    }

    protected void updateItem(MTabBarItem item) {
        this.layout(true);
        this.redraw();
    }

    protected Point computeTabBarSize(int wHint, int hHint) {
        Point size;
        if (wHint != -1 && hHint != -1) {
            size = new Point(wHint, hHint);
        } else {
            boolean tabBarVertical = this.isVertical();
            IStyleProvider styles = this.getStyleProvider();
            int marginWidth = styles.getWidth((Object)this, MARGIN, 0);
            int marginHeight = styles.getHeight((Object)this, MARGIN, 0);
            int borderWidth = Math.max(styles.getWidth((Object)this, BORDER, 0), styles.getHeight((Object)this, BORDER, 0));
            int paddingWidth = styles.getWidth((Object)this, PADDING, 0);
            int paddingHeight = styles.getHeight((Object)this, PADDING, 0);
            int trimWidth = marginWidth + borderWidth + paddingWidth + marginWidth + borderWidth + paddingWidth;
            int trimHeight = marginHeight + borderWidth + paddingHeight + marginHeight + borderWidth + paddingHeight;
            if (wHint != -1) {
                wHint = Math.max(0, wHint - trimWidth);
            }
            if (hHint != -1) {
                hHint = Math.max(0, hHint - trimHeight);
            }
            int hSpacing = styles.getWidth((Object)this, SEPARATOR, 0);
            int vSpacing = styles.getHeight((Object)this, SEPARATOR, 0);
            int itemCount = this.getItemCount();
            int width = 0;
            int height = 0;
            int i = 0;
            while (i < itemCount) {
                MTabBarItem item = this.getItem(i);
                if (item.getVisible()) {
                    Point itemSize = this.computeItemSize(item, styles, tabBarVertical, tabBarVertical ? wHint : -1, tabBarVertical ? -1 : hHint, false);
                    if (tabBarVertical) {
                        if (i > 0) {
                            height += vSpacing;
                        }
                        width = Math.max(width, itemSize.x);
                        height += itemSize.y;
                    } else {
                        if (i > 0) {
                            width += hSpacing;
                        }
                        width += itemSize.x;
                        height = Math.max(height, itemSize.y);
                    }
                }
                ++i;
            }
            size = new Point(width + trimWidth, height + trimHeight);
        }
        Rectangle trimmed = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trimmed.width, trimmed.height);
    }

    private Point computeItemSize(MTabBarItem item, IStyleProvider styles, boolean tabBarVertical, int wHint, int hHint, boolean cache) {
        int itemHeight;
        int itemWidth;
        Point textAreaSize;
        boolean separator = item.isSeparator();
        Image image = item.getImage();
        String text = item.getText();
        boolean imageVisible = !separator && image != null && styles.getVisibility((Object)item, "image", true);
        boolean textVisible = !separator && text != null && !"".equals(text) && styles.getVisibility((Object)item, "text", true);
        int textPosition = styles.getPosition((Object)item, "text", 1024);
        boolean itemVertical = (textPosition & 0x480) != 0;
        int marginWidth = styles.getWidth((Object)item, MARGIN, 0);
        int marginHeight = styles.getHeight((Object)item, MARGIN, 0);
        int hSpacing = styles.getWidth((Object)item, SEPARATOR, 0);
        int vSpacing = styles.getHeight((Object)item, SEPARATOR, 0);
        Font font = styles.getFont((Object)item, "text");
        if (font == null) {
            font = this.getFont();
        }
        if (cache) {
            item.marginWidth = marginWidth;
            item.marginHeight = marginHeight;
            item.hSpacing = hSpacing;
            item.vSpacing = vSpacing;
            item.textPosition = textPosition;
            item.imageVisible = imageVisible;
            item.textVisible = textVisible;
            item.font = font;
        }
        wHint = styles.getWidth((Object)item, null, itemVertical ? wHint : -1);
        hHint = styles.getHeight((Object)item, null, itemVertical ? -1 : hHint);
        if (separator) {
            int separatorWidth = item.getWidth();
            if (separatorWidth == -2) {
                return new Point(0, 0);
            }
            return tabBarVertical ? new Point(wHint, separatorWidth) : new Point(separatorWidth, hHint);
        }
        int width = item.getWidth();
        if (width > 0 && width != 24 && itemVertical) {
            hHint = width;
        }
        if (wHint >= 0) {
            wHint = Math.max(0, wHint - marginWidth - marginWidth);
        }
        if (hHint >= 0) {
            hHint = Math.max(0, hHint - marginHeight - marginHeight);
        }
        int imageWHint = styles.getWidth((Object)item, "image", itemVertical ? wHint : -1);
        int imageHHint = styles.getHeight((Object)item, "image", itemVertical ? -1 : hHint);
        int textWHint = styles.getWidth((Object)item, "text", itemVertical ? wHint : -1);
        int textHHint = styles.getHeight((Object)item, "text", itemVertical ? -1 : hHint);
        Point imageSize = imageVisible ? this.computeImageSize(item.getImage()) : new Point(0, 0);
        Point textSize = textVisible ? this.computeTextSize(item.getText(), font) : new Point(0, 0);
        Point imageAreaSize = imageVisible ? MTabBar.computePreferredSize(imageSize.x, imageSize.y, imageWHint, imageHHint) : new Point(0, 0);
        Point point = textAreaSize = textVisible ? MTabBar.computePreferredSize(textSize.x, textSize.y, textWHint, textHHint) : new Point(0, 0);
        if (itemVertical) {
            int n = itemWidth = wHint < 0 ? Math.max(imageAreaSize.x, textAreaSize.x) : wHint;
            itemHeight = hHint < 0 ? (imageVisible && textVisible ? imageAreaSize.y + vSpacing + textAreaSize.y : (imageVisible ? imageAreaSize.y : (textVisible ? textAreaSize.y : 0))) : hHint;
        } else {
            itemWidth = wHint < 0 ? (imageVisible && textVisible ? imageAreaSize.x + hSpacing + textAreaSize.x : (imageVisible ? imageAreaSize.x : (textVisible ? textAreaSize.x : 0))) : wHint;
            itemHeight = hHint < 0 ? Math.max(imageAreaSize.y, textAreaSize.y) : hHint;
        }
        return new Point(itemWidth + marginWidth + marginWidth, itemHeight + marginHeight + marginHeight);
    }

    private Point computeImageSize(Image image) {
        if (image == null) {
            return new Point(0, 0);
        }
        Rectangle b = image.getBounds();
        return new Point(b.width, b.height);
    }

    private Point computeTextSize(String text, Font font) {
        Point textSize;
        if (text == null || "".equals(text)) {
            return new Point(0, 0);
        }
        GC gc = new GC((Drawable)this);
        try {
            gc.setFont(font);
            textSize = gc.textExtent(text);
        }
        finally {
            gc.dispose();
        }
        return textSize;
    }

    private static Point computePreferredSize(int srcWidth, int srcHeight, int wHint, int hHint) {
        if (wHint == 0 || hHint == 0) {
            return new Point(0, 0);
        }
        if (wHint > 0 && hHint > 0) {
            return new Point(wHint, hHint);
        }
        if (srcWidth == 0 || srcHeight == 0) {
            return new Point(0, 0);
        }
        if (wHint < 0 && hHint < 0) {
            return new Point(srcWidth, srcHeight);
        }
        if (wHint < 0) {
            if (srcHeight <= hHint) {
                return new Point(srcWidth, hHint);
            }
            int width = srcWidth * hHint / srcHeight;
            if (width <= 0) {
                return new Point(0, 0);
            }
            return new Point(width, hHint);
        }
        if (srcWidth <= wHint) {
            return new Point(wHint, srcHeight);
        }
        int height = srcHeight * wHint / srcWidth;
        if (height <= 0) {
            return new Point(0, 0);
        }
        return new Point(wHint, height);
    }

    private static Point computeConstrainedSize(int srcWidth, int srcHeight, int wHint, int hHint) {
        float scaleX = wHint < 0 || srcWidth <= wHint ? 1.0f : (float)wHint / (float)srcWidth;
        float scaleY = hHint < 0 || srcHeight <= hHint ? 1.0f : (float)hHint / (float)srcHeight;
        float scale = Math.min(scaleX, scaleY);
        int destWidth = (int)Math.ceil((float)srcWidth * scale);
        int destHeight = (int)Math.ceil((float)srcHeight * scale);
        return new Point(destWidth, destHeight);
    }

    protected void layoutTabBar() {
        IStyleProvider styles = this.getStyleProvider();
        this.marginWidth = styles.getWidth((Object)this, MARGIN, 0);
        this.marginHeight = styles.getHeight((Object)this, MARGIN, 0);
        this.borderWidth = Math.max(styles.getWidth((Object)this, BORDER, 0), styles.getHeight((Object)this, BORDER, 0));
        this.paddingWidth = styles.getWidth((Object)this, PADDING, 0);
        this.paddingHeight = styles.getHeight((Object)this, PADDING, 0);
        this.hSpacing = styles.getWidth((Object)this, SEPARATOR, 0);
        this.vSpacing = styles.getHeight((Object)this, SEPARATOR, 0);
        this.cornerWidth = styles.getWidth((Object)this, CORNER, 0);
        this.cornerHeight = styles.getHeight((Object)this, CORNER, 0);
        this.layoutItems(styles);
        this.layoutChildren(styles);
    }

    protected void layoutChildren(IStyleProvider styles) {
    }

    protected void layoutItems(IStyleProvider styles) {
        Point contentSize;
        MTabBarItem item;
        int itemCount = this.getItemCount();
        if (itemCount == 0) {
            this.separators = null;
            return;
        }
        Rectangle area = this.getClientArea();
        boolean tabBarVertical = this.isVertical();
        int contentWidth = Math.max(0, area.width - this.marginWidth - this.marginWidth - this.borderWidth - this.borderWidth - this.paddingWidth - this.paddingWidth);
        int contentHeight = Math.max(0, area.height - this.marginHeight - this.marginHeight - this.borderWidth - this.borderWidth - this.paddingHeight - this.paddingHeight);
        int contentX = area.x + this.marginWidth + this.borderWidth + this.paddingWidth;
        int contentY = area.y + this.marginHeight + this.borderWidth + this.paddingHeight;
        boolean itemBoundsChanged = false;
        Point[] contentSizes = new Point[itemCount];
        int expansion = 0;
        int expandingItemCount = 0;
        int i = 0;
        while (i < itemCount) {
            item = this.getItem(i);
            if (item.getVisible()) {
                contentSizes[i] = contentSize = this.computeItemSize(item, styles, tabBarVertical, contentWidth, contentHeight, true);
                if (expansion > 0) {
                    expansion += tabBarVertical ? this.vSpacing : this.hSpacing;
                }
                expansion += tabBarVertical ? contentSize.y : contentSize.x;
                if (item.isSeparator() && item.getWidth() == -2) {
                    ++expandingItemCount;
                }
            }
            ++i;
        }
        if (expansion > 0) {
            expansion = Math.max(0, tabBarVertical ? contentHeight - expansion : contentWidth - expansion);
        }
        this.separators = new Rectangle[itemCount - 1];
        int i2 = 0;
        while (i2 < itemCount) {
            item = this.getItem(i2);
            if (item.getVisible()) {
                contentSize = contentSizes[i2];
                if (i2 > 0) {
                    if (tabBarVertical) {
                        contentY += this.vSpacing;
                    } else {
                        contentX += this.hSpacing;
                    }
                }
                if (expansion > 0 && item.isSeparator() && item.getWidth() == -2) {
                    int itemExpansion = expansion / expandingItemCount;
                    expansion -= itemExpansion;
                    --expandingItemCount;
                    if (tabBarVertical) {
                        contentSize.y += itemExpansion;
                    } else {
                        contentSize.x += itemExpansion;
                    }
                }
                int itemX = contentX;
                int itemY = contentY;
                int itemWidth = contentSize.x;
                int itemHeight = contentSize.y;
                item.contentBounds.x = contentX;
                item.contentBounds.y = contentY;
                item.contentBounds.width = contentSize.x;
                item.contentBounds.height = contentSize.y;
                if (!item.isSeparator()) {
                    this.layoutItem(item, styles);
                }
                if (tabBarVertical) {
                    contentY += contentSize.y;
                    itemX -= this.borderWidth + this.paddingWidth;
                    itemWidth += this.borderWidth + this.borderWidth + this.paddingWidth + this.paddingWidth;
                    if (i2 == 0) {
                        itemY -= this.borderWidth + this.paddingHeight;
                        itemHeight += this.borderWidth + this.paddingHeight;
                    }
                    if (i2 == itemCount - 1) {
                        itemHeight += this.borderWidth + this.paddingHeight;
                    }
                } else {
                    contentX += contentSize.x;
                    itemY -= this.borderWidth + this.paddingHeight;
                    itemHeight += this.borderWidth + this.borderWidth + this.paddingHeight + this.paddingHeight;
                    if (i2 == 0) {
                        itemX -= this.borderWidth + this.paddingWidth;
                        itemWidth += this.borderWidth + this.paddingWidth;
                    }
                    if (i2 == itemCount - 1) {
                        itemWidth += this.borderWidth + this.paddingWidth;
                    }
                }
                itemBoundsChanged |= item.setBounds(itemX, itemY, itemWidth, itemHeight);
                if (i2 < itemCount - 1) {
                    this.separators[i2] = tabBarVertical ? new Rectangle(contentX - this.borderWidth - this.paddingWidth, contentY, contentWidth + this.borderWidth + this.borderWidth + this.paddingWidth + this.paddingWidth, this.vSpacing) : new Rectangle(contentX, contentY - this.borderWidth - this.paddingWidth, this.hSpacing, contentHeight + this.borderWidth + this.borderWidth + this.paddingHeight + this.paddingHeight);
                }
            }
            ++i2;
        }
        if (itemBoundsChanged) {
            this.redraw();
        }
    }

    private void layoutItem(MTabBarItem item, IStyleProvider styles) {
        int contentX = item.contentBounds.x + item.marginWidth;
        int contentY = item.contentBounds.y + item.marginHeight;
        int contentWidth = item.contentBounds.width - item.marginWidth - item.marginWidth;
        int contentHeight = item.contentBounds.height - item.marginHeight - item.marginHeight;
        if (item.imageVisible && item.textVisible) {
            Point textAreaSize;
            boolean itemVertical = (item.textPosition & 0x480) != 0;
            boolean imageLeading = (item.textPosition & 0x20400) != 0;
            Point imageSize = item.imageVisible ? this.computeImageSize(item.getImage()) : new Point(0, 0);
            Point textSize = item.textVisible ? this.computeTextSize(item.getText(), item.font) : new Point(0, 0);
            int imageWHint = styles.getWidth((Object)item, "image", itemVertical ? contentWidth : -1);
            int imageHHint = styles.getHeight((Object)item, "image", itemVertical ? -1 : contentHeight);
            int textWHint = styles.getWidth((Object)item, "text", itemVertical ? contentWidth : -1);
            int textHHint = styles.getHeight((Object)item, "text", itemVertical ? -1 : contentHeight);
            Point imageAreaSize = item.imageVisible ? MTabBar.computePreferredSize(imageSize.x, imageSize.y, imageWHint, imageHHint) : new Point(0, 0);
            Point point = textAreaSize = item.textVisible ? MTabBar.computePreferredSize(textSize.x, textSize.y, textWHint, textHHint) : new Point(0, 0);
            if (itemVertical) {
                if (imageHHint > 0 && textHHint < 0) {
                    textAreaSize.y = Math.max(0, contentHeight - imageAreaSize.y - item.vSpacing);
                } else if (imageHHint < 0 && textHHint > 0) {
                    imageAreaSize.y = Math.max(0, contentHeight - textAreaSize.y - item.vSpacing);
                }
            } else if (imageWHint > 0 && textWHint < 0) {
                textAreaSize.x = Math.max(0, contentWidth - imageAreaSize.x - item.hSpacing);
            } else if (imageWHint < 0 && textWHint > 0) {
                imageAreaSize.x = Math.max(0, contentWidth - textAreaSize.x - item.hSpacing);
            }
            imageSize = MTabBar.computeConstrainedSize(imageSize.x, imageSize.y, imageAreaSize.x, imageAreaSize.y);
            textSize = MTabBar.computeConstrainedSize(textSize.x, textSize.y, textAreaSize.x, textAreaSize.y);
            if (itemVertical) {
                item.imageBounds.x = contentX + (contentWidth - imageSize.x) / 2;
                item.imageBounds.y = contentY + (imageAreaSize.y - imageSize.y) / 2;
                item.textBounds.x = contentX + (contentWidth - textSize.x) / 2;
                item.textBounds.y = contentY + (textAreaSize.y - textSize.y) / 2;
                if (imageLeading) {
                    item.textBounds.y += imageAreaSize.y + item.vSpacing;
                } else {
                    item.imageBounds.y += textAreaSize.y + item.vSpacing;
                }
            } else {
                if (imageLeading) {
                    item.imageBounds.x = contentX;
                    item.imageBounds.y = contentY + (contentHeight - imageSize.y) / 2;
                    item.imageBounds.width = imageAreaSize.x;
                    item.imageBounds.height = imageSize.y;
                    item.textBounds.x = contentX + item.imageBounds.width + item.hSpacing;
                    item.textBounds.y = item.imageBounds.y;
                    item.textBounds.width = item.contentBounds.width - item.imageBounds.width - item.hSpacing;
                    item.textBounds.height = item.imageBounds.height;
                } else {
                    item.textBounds.x = contentX;
                    item.textBounds.y = contentY;
                    item.textBounds.width = imageAreaSize.x;
                    item.textBounds.height = item.contentBounds.height;
                    item.imageBounds.x = contentX + item.textBounds.width + item.hSpacing;
                    item.imageBounds.y = contentY;
                    item.imageBounds.width = item.contentBounds.width - item.imageBounds.width - item.hSpacing;
                    item.imageBounds.height = item.contentBounds.height;
                }
                return;
            }
            item.imageBounds.width = imageSize.x;
            item.imageBounds.height = imageSize.y;
            item.textBounds.width = textSize.x;
            item.textBounds.height = textSize.y;
        } else if (item.imageVisible) {
            Point imageSize = this.computeImageSize(item.getImage());
            Point constrainedSize = MTabBar.computeConstrainedSize(imageSize.x, imageSize.y, contentWidth, contentHeight);
            item.imageBounds.x = contentX + (contentWidth - constrainedSize.x) / 2;
            item.imageBounds.y = contentY + (contentHeight - constrainedSize.y) / 2;
            item.imageBounds.width = constrainedSize.x;
            item.imageBounds.height = constrainedSize.y;
            item.textBounds.x = 0;
            item.textBounds.y = 0;
            item.textBounds.width = 0;
            item.textBounds.height = 0;
        } else if (item.textVisible) {
            Point textSize = this.computeTextSize(item.getText(), item.font);
            Point constrainedSize = MTabBar.computeConstrainedSize(textSize.x, textSize.y, contentWidth, contentHeight);
            item.imageBounds.x = 0;
            item.imageBounds.y = 0;
            item.imageBounds.width = 0;
            item.imageBounds.height = 0;
            item.textBounds.x = contentX + (contentWidth - constrainedSize.x) / 2;
            item.textBounds.y = contentY + (contentHeight - constrainedSize.y) / 2;
            item.textBounds.width = constrainedSize.x;
            item.textBounds.height = constrainedSize.y;
        } else {
            item.imageBounds.x = 0;
            item.imageBounds.y = 0;
            item.imageBounds.width = 0;
            item.imageBounds.height = 0;
            item.textBounds.x = 0;
            item.textBounds.y = 0;
            item.textBounds.width = 0;
            item.textBounds.height = 0;
        }
    }

    protected void updateTabBar() {
        this.layout(true);
        this.redraw();
    }

    private void paintTabBar(GC gc) {
        MTabBarItem item;
        int itemCount = this.getItemCount();
        if (itemCount == 0) {
            return;
        }
        Rectangle borderArea = this.getClientArea();
        borderArea.x += this.marginWidth;
        borderArea.y += this.marginHeight;
        borderArea.width -= this.marginWidth + this.marginWidth;
        borderArea.height -= this.marginHeight + this.marginHeight;
        Rectangle borderFillArea = new Rectangle(borderArea.x + this.borderWidth, borderArea.y + this.borderWidth, borderArea.width - this.borderWidth - this.borderWidth, borderArea.height - this.borderWidth - this.borderWidth);
        int i = 0;
        while (i < itemCount) {
            item = this.getItem(i);
            if (item.getVisible()) {
                this.paintItemFill(gc, item, borderFillArea, i == 0, i == itemCount - 1);
            }
            ++i;
        }
        this.paintBorderAndSeparators(gc, borderArea);
        i = 0;
        while (i < itemCount) {
            item = this.getItem(i);
            if (item.getVisible()) {
                this.paintItem(gc, item);
            }
            ++i;
        }
    }

    private void paintBorderAndSeparators(GC gc, Rectangle borderArea) {
        IStyleProvider styles = this.getStyleProvider();
        Color borderColor = styles.getColor((Object)this, BORDER);
        if (borderColor == null || borderColor.getAlpha() <= 0) {
            return;
        }
        int borderAlpha = styles.getAlpha((Object)this, BORDER, 255);
        if (borderAlpha <= 0) {
            return;
        }
        Color oldForeground = gc.getForeground();
        Color oldBackground = gc.getBackground();
        int oldAlpha = gc.getAlpha();
        int oldLineWidth = gc.getLineWidth();
        int oldLineStyle = gc.getLineStyle();
        int oldLineCap = gc.getLineCap();
        gc.setForeground(borderColor);
        gc.setBackground(borderColor);
        gc.setAlpha(borderAlpha);
        gc.setLineWidth(this.borderWidth);
        gc.setLineStyle(1);
        gc.setLineCap(3);
        if (this.cornerWidth > 0 && this.cornerHeight > 0) {
            gc.drawRoundRectangle(borderArea.x + this.borderWidth / 2, borderArea.y + this.borderWidth / 2, borderArea.width - this.borderWidth, borderArea.height - this.borderWidth, this.cornerWidth + this.cornerWidth, this.cornerHeight + this.cornerHeight);
        } else {
            gc.drawRectangle(borderArea.x + this.borderWidth / 2, borderArea.y + this.borderWidth / 2, borderArea.width - this.borderWidth, borderArea.height - this.borderWidth);
        }
        boolean tabBarVertical = this.isVertical();
        if (this.separators != null && this.separators.length > 0) {
            int i = 0;
            while (i < this.separators.length) {
                Rectangle sep = this.separators[i];
                if (tabBarVertical) {
                    gc.fillRectangle(sep.x + this.borderWidth, sep.y, sep.width - this.borderWidth - this.borderWidth, sep.height);
                } else {
                    gc.fillRectangle(sep.x, sep.y + this.borderWidth, sep.width, sep.height - this.borderWidth - this.borderWidth);
                }
                ++i;
            }
        }
        gc.setLineCap(oldLineCap);
        gc.setLineStyle(oldLineStyle);
        gc.setLineWidth(oldLineWidth);
        gc.setAlpha(oldAlpha);
        gc.setBackground(oldBackground);
        gc.setForeground(oldForeground);
    }

    private void paintItem(GC gc, MTabBarItem item) {
        if (item.contentBounds.width <= 0 || item.contentBounds.height <= 0) {
            return;
        }
        if (!item.imageVisible && !item.textVisible) {
            return;
        }
        Rectangle oldClipping = gc.getClipping();
        gc.setClipping(item.bounds);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        if (item.imageVisible) {
            this.paintItemImage(gc, item);
        }
        if (item.textVisible) {
            this.paintItemText(gc, item);
        }
        gc.setClipping(oldClipping);
    }

    private void paintItemImage(GC gc, MTabBarItem item) {
        Image image = item.getImage();
        if (image == null) {
            return;
        }
        Rectangle dest = item.imageBounds;
        if (dest.width <= 0 || dest.height <= 0) {
            return;
        }
        Rectangle src = image.getBounds();
        gc.drawImage(image, src.x, src.y, src.width, src.height, dest.x, dest.y, dest.width, dest.height);
    }

    private void paintItemText(GC gc, MTabBarItem item) {
        String text = item.getText();
        if (text == null || "".equals(text)) {
            return;
        }
        Rectangle dest = item.textBounds;
        if (dest.width <= 0 || dest.height <= 0) {
            return;
        }
        Color textColor = this.getStyleProvider().getColor((Object)item, "text");
        if (textColor == null) {
            textColor = this.getForeground();
        }
        Color oldForeground = gc.getForeground();
        gc.setForeground(textColor);
        gc.setFont(item.font);
        Point textSize = gc.textExtent(text);
        IStyleProvider styles = this.getStyleProvider();
        int textAlign = styles.getTextAlign((Object)item, "textAlign", 0x1000000);
        Transform t = new Transform(gc.getDevice());
        float scaleX = Math.min(1.0f, (float)dest.width / (float)textSize.x);
        float scaleY = Math.min(1.0f, (float)dest.height / (float)textSize.y);
        float scale = Math.min(scaleX, scaleY);
        float offsetX = (float)dest.x + (float)dest.width / 2.0f;
        float offsetY = (float)dest.y + (float)dest.height / 2.0f;
        float offsetX2 = 0.0f;
        float offsetY2 = -((float)textSize.y) / 2.0f;
        switch (textAlign) {
            case 16384: {
                offsetX2 = -dest.width / 2 + item.hSpacing * 5;
                break;
            }
            case 0x1000000: {
                offsetX2 = -((float)textSize.x) / 2.0f;
                break;
            }
            case 131072: {
                offsetX2 = -dest.width / 2 + (dest.width - textSize.x) / 2;
            }
        }
        t.translate(offsetX, offsetY);
        t.scale(scale, scale);
        t.translate(offsetX2, offsetY2 / scale);
        Transform oldTransform = new Transform(gc.getDevice());
        try {
            gc.getTransform(oldTransform);
            try {
                gc.setTransform(t);
                gc.drawText(text, 0, 0, true);
            }
            finally {
                t.dispose();
            }
            gc.setTransform(oldTransform);
        }
        finally {
            oldTransform.dispose();
        }
        gc.setForeground(oldForeground);
    }

    private void paintItemFill(GC gc, MTabBarItem item, Rectangle borderArea, boolean first, boolean last) {
        IStyleProvider styles = this.getStyleProvider();
        Color fillColor = null;
        String color = item.getColor();
        if (color != null && !"".equals(color)) {
            RGB rgb = ColorUtils.toRGB(color);
            fillColor = this.resources.createColor(rgb);
        }
        if (fillColor == null) {
            fillColor = styles.getColor((Object)item, "fill");
        }
        if (fillColor == null || fillColor.getAlpha() <= 0) {
            return;
        }
        int alpha = styles.getAlpha((Object)item, "fill", 255);
        if (alpha <= 0) {
            return;
        }
        Rectangle oldClipping = gc.getClipping();
        int oldAlpha = gc.getAlpha();
        Color oldBackground = gc.getBackground();
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        gc.setClipping(item.bounds);
        gc.setAlpha(alpha);
        gc.setBackground(fillColor);
        if (this.cornerWidth > 0 && this.cornerHeight > 0) {
            gc.fillRoundRectangle(borderArea.x, borderArea.y, borderArea.width, borderArea.height, this.cornerWidth + this.cornerWidth - this.borderWidth, this.cornerWidth + this.cornerWidth - this.borderWidth);
        } else {
            gc.fillRectangle(borderArea);
        }
        gc.setBackground(oldBackground);
        gc.setAlpha(oldAlpha);
        gc.setClipping(oldClipping);
    }

    private void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        for (MTabBarItem item : this.items) {
            if (item.isDisposed()) continue;
            item.dispose();
        }
    }

    private void onResize(Event event) {
        if (this.inDispose) {
            return;
        }
        this.layout(true);
    }

    private void onPaint(Event event) {
        if (this.inDispose) {
            return;
        }
        this.paintTabBar(event.gc);
    }

    private void onMouseEnter(Event event) {
        MTabBarItem item = this.getItem(event.x, event.y);
        if (item != null) {
            item.setPreselected(true);
        }
    }

    private void onMouseExit(Event event) {
        for (MTabBarItem item : this.items) {
            item.setPreselected(false);
        }
    }

    private void onMouseMove(Event event) {
        MTabBarItem newTarget = null;
        MTabBarItem oldTarget = null;
        for (MTabBarItem item : this.items) {
            if (item.getBounds().contains(event.x, event.y)) {
                newTarget = item;
            }
            if (!item.isPreselected()) continue;
            oldTarget = item;
        }
        if (newTarget == oldTarget) {
            return;
        }
        if (oldTarget != null) {
            oldTarget.setPreselected(false);
            if (oldTarget == this.trackedItem) {
                oldTarget.setSelected(false);
            }
        }
        if (newTarget != null) {
            newTarget.setPreselected(true);
            if (newTarget == this.trackedItem) {
                newTarget.setSelected(true);
            }
        }
    }

    private void onMouseDown(Event event) {
        this.trackedItem = null;
        MTabBarItem item = this.getItem(event.x, event.y);
        if (item != null && (item.isPushButton() || item.isRadioButton())) {
            item.setSelected(true);
            if (item.isRadioButton()) {
                this.mouseSelect(item, event);
            } else {
                this.trackedItem = item;
            }
        }
    }

    private void onMouseUp(Event event) {
        MTabBarItem item = this.getItem(event.x, event.y);
        if (item != null && item.isPushButton()) {
            item.setSelected(false);
            if (item == this.trackedItem) {
                this.update();
                this.mouseSelect(item, event);
            }
        }
        this.trackedItem = null;
    }

    private void mouseSelect(MTabBarItem item, Event event) {
        Object target;
        if (item.isSeparator()) {
            return;
        }
        int index = this.indexOf(item);
        if (item.isPushButton()) {
            target = item;
        } else {
            this.setSelection(item);
            target = this;
        }
        Event e = new Event();
        e.item = item;
        e.index = index;
        e.detail = event.detail;
        e.x = event.x;
        e.y = event.y;
        target.notifyListeners(13, e);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    private class MTabBarLayout
    extends Layout {
        private MTabBarLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return MTabBar.this.computeTabBarSize(wHint, hHint);
        }

        protected void layout(Composite composite, boolean flushCache) {
            MTabBar.this.layoutTabBar();
        }
    }
}

