/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.internal.presentation.slide.PresentationStory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteSlideCommand
extends SourceCommand {
    private PresentationStory story;
    private PresentationSlide slide;
    private List<PresentationSlide> slides;
    private Map<PresentationSlide, Integer> indexMap;
    private int oldIndex = -1;

    public DeleteSlideCommand(PresentationStory story, PresentationSlide slide) {
        super((Object)slide);
        this.story = story;
        this.slide = slide;
        this.oldIndex = slide.getIndex();
    }

    public DeleteSlideCommand(PresentationStory story, List<PresentationSlide> slides) {
        super(slides);
        this.story = story;
        this.slides = slides;
        this.indexMap = new HashMap<PresentationSlide, Integer>();
    }

    public void redo() {
        if (this.slide != null) {
            this.story.deleteSlide(this.slide);
        } else if (!this.slides.isEmpty()) {
            for (PresentationSlide s : this.slides) {
                int i = s.getIndex();
                this.indexMap.put(s, new Integer(i));
                this.story.deleteSlide(s);
            }
        }
        super.redo();
    }

    public void undo() {
        if (this.slide != null) {
            this.story.addSlide(this.slide, this.oldIndex);
        } else if (!this.slides.isEmpty()) {
            int i = this.slides.size();
            while (i > 0) {
                PresentationSlide s = this.slides.get(i - 1);
                int index = this.indexMap.get(s);
                this.story.addSlide(s, index);
                this.indexMap.remove(s);
                --i;
            }
        }
        super.undo();
    }
}

