/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.decorations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.decoration.AbstractDecoration;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionLine;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.decorations.IBranchDecoration;
import org.xmind.ui.decorations.ITopicDecoration;
import org.xmind.ui.internal.spreadsheet.structures.Chart;
import org.xmind.ui.internal.spreadsheet.structures.Column;
import org.xmind.ui.internal.spreadsheet.structures.ColumnHead;
import org.xmind.ui.internal.spreadsheet.structures.Row;
import org.xmind.ui.internal.spreadsheet.structures.SpreadsheetStructure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITitleTextPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetBranchDecoration
extends AbstractDecoration
implements IBranchDecoration {
    private static final Rectangle CLIP_RECT = new Rectangle();
    private static final int INSERTION_ALPHA = 96;
    private IBranchPart branch;
    private PrecisionRectangle bounds;
    private List<Block> blocks;
    private List<PrecisionLine> lines;
    private PrecisionRectangle insertedCellBounds;
    private List<Text> columnHeads;

    public SpreadsheetBranchDecoration(IBranchPart branch, String id) {
        super(id);
        this.branch = branch;
    }

    public void validate(IFigure figure) {
        super.validate(figure);
        IStyleSelector ss = StyleUtils.getStyleSelector((IGraphicalPart)this.branch);
        String decorationId = StyleUtils.getString((IGraphicalPart)this.branch, (IStyleSelector)ss, (String)"shape-class", null);
        int lineWidth = StyleUtils.getInteger((IGraphicalPart)this.branch, (IStyleSelector)ss, (String)"line-width", (String)decorationId, (int)1);
        double halfLineWidth1 = (double)lineWidth / 2.0;
        double halfLineWidth2 = (double)lineWidth - halfLineWidth1;
        this.bounds = new PrecisionRectangle(this.branch.getFigure().getBounds()).shrink((double)lineWidth, (double)lineWidth);
        double left = this.bounds.x;
        double right = this.bounds.right();
        double top = this.bounds.y;
        double bottom = this.bounds.bottom();
        Chart chart = this.getChart();
        if (chart != null) {
            boolean ignoreFirstLine;
            double y;
            int titleHeight = chart.getTitleAreaHeight();
            if (titleHeight > 0) {
                y = top + (double)titleHeight;
                ignoreFirstLine = false;
                top = y + halfLineWidth1;
            } else {
                y = top - halfLineWidth1;
                ignoreFirstLine = true;
            }
            IInsertion ins = (IInsertion)MindMapUtils.getCache((IPart)this.branch, (String)"org.xmind.ui.branchCache.insertion");
            int insHeight = ins == null ? 0 : ins.getSize().height + chart.getMajorSpacing();
            int numRows = chart.getNumRows();
            int numCols = numRows > 0 ? chart.getNumColumns() : 0;
            int numLines = Math.max(0, numCols) + Math.max(0, numRows);
            if (ins != null) {
                ++numLines;
            }
            if (numLines > 0) {
                double colHeadHeight;
                double colHeadTop;
                this.lines = new ArrayList<PrecisionLine>(numLines);
                if (chart.hasColumns()) {
                    if (!ignoreFirstLine) {
                        this.addHorizontalLine(left, right, y + halfLineWidth1);
                    }
                    ignoreFirstLine = false;
                    colHeadTop = y + (double)lineWidth;
                    colHeadHeight = chart.getColumnHeadHeight() + chart.getMajorSpacing();
                    y += (double)lineWidth + colHeadHeight;
                } else {
                    colHeadTop = 0.0;
                    colHeadHeight = 0.0;
                }
                int minorSpacing = chart.getMinorSpacing();
                ColumnHead insertionColHead = null;
                boolean insertionInRow = false;
                int i = 0;
                while (i < numRows) {
                    Row row = chart.getRow(i);
                    if (insertionColHead == null && (insertionColHead = (ColumnHead)MindMapUtils.getCache((IPart)row.getHead(), (String)"org.xmind.ui.spreadsheet.cache.insertionColumnHead")) != null) {
                        insertionInRow = true;
                        this.insertedCellBounds = new PrecisionRectangle();
                    }
                    if (!ignoreFirstLine) {
                        this.addHorizontalLine(left, right, y + halfLineWidth1);
                        if (insertionInRow) {
                            this.insertedCellBounds.y = y + halfLineWidth1;
                        }
                    }
                    ignoreFirstLine = false;
                    y += (double)lineWidth;
                    if (ins != null && i == ins.getIndex()) {
                        Block block = this.addBlock(null, new PrecisionRectangle(left, y, right - left, (double)insHeight));
                        block.alpha = 96;
                        this.addHorizontalLine(left, right, (y += (double)insHeight) + halfLineWidth1);
                        y += (double)lineWidth;
                        ins = null;
                    }
                    int rowHeight = i == numRows - 1 && ins == null ? (int)Math.ceil(bottom - y) : row.getHead().getFigure().getBounds().height + minorSpacing;
                    this.addBlock((IGraphicalPart)row.getHead(), new PrecisionRectangle(left, y, right - left, (double)rowHeight));
                    y += (double)rowHeight;
                    if (insertionInRow) {
                        this.insertedCellBounds.height = y + halfLineWidth1 - this.insertedCellBounds.y;
                        insertionInRow = false;
                    }
                    ++i;
                }
                if (ins != null && ins.getIndex() == numRows) {
                    this.addHorizontalLine(left, right, y + halfLineWidth1);
                    Block block = this.addBlock(null, new PrecisionRectangle(left, y, right - left, (double)((int)Math.ceil(bottom - y))));
                    block.alpha = 96;
                }
                double x = left + halfLineWidth2 + (double)chart.getRowHeadWidth() + (double)minorSpacing;
                IInsertion colIns = (IInsertion)MindMapUtils.getCache((IPart)this.branch, (String)"org.xmind.ui.spreadsheet.cache.columnInsertion");
                int i2 = 0;
                while (i2 < numCols) {
                    boolean insertionInColumn;
                    if (colIns != null && colIns.getIndex() == i2) {
                        int colInsWidth = colIns.getSize().width + chart.getMinorSpacing() + lineWidth;
                        Block block = this.addBlock(null, new PrecisionRectangle(x + halfLineWidth1, top, (double)colInsWidth, bottom - top));
                        block.alpha = 96;
                        this.addVerticalLine(x + halfLineWidth1, top, bottom);
                        x += (double)colInsWidth;
                    }
                    Column col = chart.getColumn(i2);
                    ColumnHead colHead = col.getHead();
                    boolean bl = insertionInColumn = insertionColHead != null && insertionColHead.equals(colHead) && this.insertedCellBounds != null;
                    if (insertionInColumn) {
                        this.insertedCellBounds.x = x + halfLineWidth1;
                    }
                    this.addVerticalLine(x + halfLineWidth1, top, bottom);
                    double columnWidth = col.getWidth();
                    PrecisionRectangle colHeadBounds = new PrecisionRectangle(x + (double)lineWidth, colHeadTop, columnWidth, colHeadHeight);
                    String text = colHead.toString();
                    Dimension size = colHead.getPrefSize();
                    Text colHeadText = this.addColumnHeadText(colHeadBounds, text, this.center(colHeadBounds, size.width, size.height));
                    colHeadText.font = colHead.getFont();
                    x += (double)lineWidth + columnWidth;
                    if (insertionInColumn) {
                        this.insertedCellBounds.width = i2 == numCols - 1 ? right - this.insertedCellBounds.x : x + halfLineWidth1 - this.insertedCellBounds.x;
                    }
                    ++i2;
                }
                if (colIns != null && colIns.getIndex() == numCols) {
                    this.addVerticalLine(x + halfLineWidth1, top, bottom);
                    int colInsWidth = colIns.getSize().width + chart.getMinorSpacing() + lineWidth;
                    Block block = this.addBlock(null, new PrecisionRectangle(x + halfLineWidth1, top, (double)colInsWidth, bottom - top));
                    block.alpha = 96;
                }
            }
        }
    }

    private Point center(PrecisionRectangle bounds, int width, int height) {
        double x = bounds.x + (bounds.width - (double)width) / 2.0;
        double y = bounds.y + (bounds.height - (double)height) / 2.0;
        return new Point((int)x, (int)y);
    }

    List<Block> getBlocks() {
        return this.blocks;
    }

    private Block addBlock(IGraphicalPart part, PrecisionRectangle bounds) {
        if (this.blocks == null) {
            this.blocks = new ArrayList<Block>();
        }
        Block block = new Block(bounds, part);
        this.blocks.add(block);
        return block;
    }

    private Text addColumnHeadText(PrecisionRectangle bounds, String text, Point textLocation) {
        if (this.columnHeads == null) {
            this.columnHeads = new ArrayList<Text>();
        }
        Text columnHeadText = new Text(bounds, text, textLocation);
        this.columnHeads.add(columnHeadText);
        return columnHeadText;
    }

    private void addHorizontalLine(double x1, double x2, double y) {
        this.lines.add(new PrecisionLine(x1, y, x2, y));
    }

    private void addVerticalLine(double x, double y1, double y2) {
        this.lines.add(new PrecisionLine(x, y1, x, y2));
    }

    protected int getMinorSpacing() {
        return StyleUtils.getInteger((IGraphicalPart)this.branch, (IStyleSelector)StyleUtils.getStyleSelector((IGraphicalPart)this.branch), (String)"spacing-minor", (int)5);
    }

    protected int getMajorSpacing() {
        return StyleUtils.getMajorSpacing((IGraphicalPart)this.branch, (int)5);
    }

    private Chart getChart() {
        IStructure sa = this.branch.getBranchPolicy().getStructure((IGraphicalPart)this.branch);
        if (sa instanceof SpreadsheetStructure) {
            return ((SpreadsheetStructure)sa).getChart(this.branch);
        }
        return null;
    }

    private ITopicDecoration getTopicDecoration() {
        IDecoration decoration;
        IFigure topicFigure = this.getTopicFigure();
        if (topicFigure instanceof IDecoratedFigure && (decoration = ((IDecoratedFigure)topicFigure).getDecoration()) instanceof ITopicDecoration) {
            return (ITopicDecoration)decoration;
        }
        return null;
    }

    private IFigure getTopicFigure() {
        ITopicPart topicPart = this.branch.getTopicPart();
        return topicPart == null ? null : topicPart.getFigure();
    }

    public void invalidate() {
        super.invalidate();
        this.bounds = null;
        this.columnHeads = null;
        this.blocks = null;
        this.lines = null;
        this.insertedCellBounds = null;
    }

    private Color getTextColor() {
        ITitleTextPart title;
        ITopicPart topicPart = this.branch.getTopicPart();
        if (topicPart != null && (title = topicPart.getTitle()) != null) {
            return title.getFigure().getForegroundColor();
        }
        return null;
    }

    protected void performPaint(IFigure figure, Graphics graphics) {
        int corner;
        Color fillColor;
        int fillAlpha;
        graphics.setAntialias(1);
        ITopicDecoration topicDecoration = this.getTopicDecoration();
        if (topicDecoration != null) {
            fillAlpha = topicDecoration.getFillAlpha();
            fillColor = topicDecoration.getFillColor();
            corner = this.getCornerSize(topicDecoration);
        } else {
            fillColor = null;
            fillAlpha = 255;
            corner = 0;
        }
        if (this.bounds != null) {
            graphics.pushState();
            int alpha = this.getAlpha() * fillAlpha / 255;
            org.xmind.gef.draw2d.graphics.Path path = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            this.addOutline(path, this.bounds, corner);
            try {
                if (fillColor != null) {
                    graphics.setAlpha(alpha);
                    graphics.setBackgroundColor(fillColor);
                    graphics.fillPath((Path)path);
                    graphics.restoreState();
                }
                if (this.blocks != null && !this.blocks.isEmpty()) {
                    for (Block block : this.blocks) {
                        block.paint(graphics, path, alpha, graphics.getClip(CLIP_RECT));
                    }
                }
                if (this.columnHeads != null && !this.columnHeads.isEmpty()) {
                    Color textColor = this.getTextColor();
                    for (Text head : this.columnHeads) {
                        graphics.setTextAntialias(1);
                        graphics.setForegroundColor(textColor);
                        head.paint(graphics, graphics.getClip(CLIP_RECT));
                    }
                }
            }
            finally {
                path.dispose();
                graphics.popState();
            }
        }
    }

    private void addOutline(org.xmind.gef.draw2d.graphics.Path path, PrecisionRectangle bounds, int corner) {
        if (corner == 0) {
            path.addRectangle(bounds);
        } else {
            path.addRoundedRectangle(bounds, (float)corner);
        }
    }

    private int getCornerSize(ITopicDecoration topicDecoration) {
        int corner = topicDecoration instanceof ICorneredDecoration ? ((ICorneredDecoration)topicDecoration).getCornerSize() : 0;
        return corner;
    }

    public void paintAboveChildren(IFigure figure, Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        this.checkValidation(figure);
        ITopicDecoration topicDecoration = this.getTopicDecoration();
        if (topicDecoration == null) {
            return;
        }
        Color lineColor = topicDecoration.getLineColor();
        if (lineColor == null) {
            return;
        }
        int lineAlpha = topicDecoration.getLineAlpha();
        int lineWidth = topicDecoration.getLineWidth();
        int lineStyle = topicDecoration.getLineStyle();
        int corner = 2;
        graphics.setAntialias(1);
        if (this.bounds != null || this.lines != null && !this.lines.isEmpty() || this.insertedCellBounds != null) {
            graphics.setAlpha(this.getAlpha() * lineAlpha / 255);
            graphics.setLineWidth(lineWidth);
            graphics.setLineStyle(lineStyle);
            graphics.setForegroundColor(lineColor);
            org.xmind.gef.draw2d.graphics.Path path = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            if (this.bounds != null) {
                this.addOutline(path, this.bounds, corner);
            }
            if (this.lines != null && !this.lines.isEmpty()) {
                for (PrecisionLine line : this.lines) {
                    path.moveTo(line.getOrigin());
                    path.lineTo(line.getTerminus());
                }
            }
            graphics.drawPath((Path)path);
            path.dispose();
            if (this.insertedCellBounds != null) {
                graphics.setAlpha(128);
                graphics.setLineWidth(lineWidth + 2);
                graphics.setForegroundColor(ColorUtils.getColor((String)"#f00000"));
                path = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
                path.addRectangle(this.insertedCellBounds);
                graphics.drawPath((Path)path);
                path.dispose();
            }
        }
    }

    static class Block {
        PrecisionRectangle bounds;
        IGraphicalPart part;
        int alpha = 255;

        public Block(PrecisionRectangle bounds, IGraphicalPart part) {
            this.bounds = bounds;
            this.part = part;
        }

        public void paint(Graphics graphics, org.xmind.gef.draw2d.graphics.Path path, int alpha, Rectangle clipRect) {
            if (!this.bounds.intersects(clipRect)) {
                return;
            }
            Color fillColor = this.getFillColor();
            if (fillColor == null) {
                return;
            }
            graphics.clipRect(this.bounds.toDraw2DRectangle());
            graphics.setBackgroundColor(fillColor);
            graphics.setAlpha(alpha * this.alpha / 255);
            graphics.fillPath((Path)path);
            graphics.restoreState();
        }

        private Color getFillColor() {
            if (this.part == null) {
                return ColorConstants.gray;
            }
            IStyleSelector ss = StyleUtils.getStyleSelector((IGraphicalPart)this.part);
            String decorationId = StyleUtils.getString((IGraphicalPart)this.part, (IStyleSelector)ss, (String)"shape-class", null);
            return StyleUtils.getColor((IGraphicalPart)this.part, (IStyleSelector)ss, (String)"svg:fill", (String)decorationId, null);
        }
    }

    private static class Text {
        PrecisionRectangle bounds;
        String text;
        Font font;
        Point textLocation;

        public Text(PrecisionRectangle bounds, String text, Point textLocation) {
            this.bounds = bounds;
            this.text = text;
            this.textLocation = textLocation;
        }

        public void paint(Graphics graphics, Rectangle clipRect) {
            if (!this.bounds.intersects(clipRect)) {
                return;
            }
            graphics.clipRect(this.bounds.toDraw2DRectangle());
            if (this.font != null) {
                graphics.setFont(this.font);
            }
            graphics.drawText(this.text, this.textLocation);
            graphics.restoreState();
        }
    }
}

