/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.event.AbstractWordFinder;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.Word;
import com.swabunga.spell.event.WordNotFoundException;

public class DefaultWordFinder
extends AbstractWordFinder {
    public DefaultWordFinder(String inText) {
        super(inText);
    }

    public DefaultWordFinder() {
    }

    public Word next() {
        if (this.nextWord == null) {
            throw new WordNotFoundException("No more words found.");
        }
        this.currentWord.copy(this.nextWord);
        this.setSentenceIterator(this.currentWord);
        int i = this.currentWord.getEnd();
        boolean finished = false;
        while (i < this.text.length() && !finished) {
            if (this.isWordChar(i)) {
                this.nextWord.setStart(i);
                int end = this.getNextWordEnd(this.text, i);
                this.nextWord.setText(this.text.substring(i, end));
                finished = true;
            }
            ++i;
        }
        if (!finished) {
            this.nextWord = null;
        }
        return this.currentWord;
    }

    private int getNextWordEnd(String text, int startPos) {
        if (SpellChecker.isINETWord(text.substring(startPos))) {
            int i = startPos;
            while (i < text.length()) {
                char ch = text.charAt(i);
                if (!Character.isLetterOrDigit(ch)) {
                    if (ch == '\r' || ch == '\n') {
                        return i;
                    }
                    if (Character.isSpaceChar(ch)) {
                        if (i > 0 && Character.isLetterOrDigit(text.charAt(i - 1))) {
                            return i;
                        }
                        return i - 1;
                    }
                }
                ++i;
            }
            return text.length();
        }
        int i = startPos;
        while (i < text.length()) {
            if (!this.isWordChar(i)) {
                return i;
            }
            ++i;
        }
        return text.length();
    }
}

