/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.service;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.draw2d.SimpleLineFigure;
import org.xmind.gef.service.AbstractFeedback;
import org.xmind.gef.service.IPositionProvider;

public class LineFeedback
extends AbstractFeedback {
    private Color color;
    private int alpha;
    private SimpleLineFigure figure;
    private Point sourceProsition;
    private Point targetPosition;
    private IPositionProvider positionProvider;

    public void addToLayer(IFigure layer) {
        if (this.figure == null) {
            this.figure = this.createFigure();
        }
        layer.add((IFigure)this.figure);
    }

    private SimpleLineFigure createFigure() {
        SimpleLineFigure figure = new SimpleLineFigure();
        figure.setForegroundColor(this.color);
        figure.setAlpha(this.alpha);
        return figure;
    }

    public boolean containsPoint(Point point) {
        if (this.figure != null) {
            if (this.getZoomManager() != null) {
                point = this.getZoomManager().getScaled(point);
            }
            return this.figure.containsPoint(point) && this.figure.isShowing();
        }
        return false;
    }

    public void removeFromLayer(IFigure layer) {
        if (this.figure != null) {
            layer.remove((IFigure)this.figure);
        }
    }

    public void update() {
        Point p2;
        Point p1;
        if (this.figure == null) {
            return;
        }
        if (this.positionProvider != null) {
            p1 = this.positionProvider.getSourcePosition();
            p2 = this.positionProvider.getTargetPosition();
            if (p1 != null && p2 != null) {
                this.setLocations(p1, p2);
            }
        }
        if (this.sourceProsition != null && this.targetPosition != null) {
            p1 = this.sourceProsition;
            p2 = this.targetPosition;
            if (this.getZoomManager() != null) {
                p1 = this.getZoomManager().getScaled(p1);
                p2 = this.getZoomManager().getScaled(p2);
            }
            this.figure.setLocations(p1, p2);
        }
        this.figure.setForegroundColor(this.color);
        this.figure.setAlpha(this.alpha);
    }

    public void setLocations(Point sourcePosition, Point targetPosition) {
        this.sourceProsition = sourcePosition;
        this.targetPosition = targetPosition;
    }

    public Point getSourceProsition() {
        return this.sourceProsition;
    }

    public Point getTargetPosition() {
        return this.targetPosition;
    }

    public IPositionProvider getPositionProvider() {
        return this.positionProvider;
    }

    public void setPositionProvider(IPositionProvider positionProvider) {
        this.positionProvider = positionProvider;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

