/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.brainstorm.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.xmind.core.ITopic;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.brainstorm.actions.AbstractEditAction;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertParentTopicAction
extends AbstractEditAction
implements ISelectionAction {
    public InsertParentTopicAction(IGraphicalViewer viewer) {
        super(viewer, "create_parent");
        this.setId(MindMapActionFactory.INSERT_PARENT_TOPIC.getId());
        this.setText(MindMapMessages.InsertParentTopic_text);
        this.setImageDescriptor(MindMapUI.getImages().get("insertparent.png", true));
        this.setDisabledImageDescriptor(MindMapUI.getImages().get("insertparent.png", false));
        this.setActionDefinitionId("org.xmind.ui.command.insertParentTopic");
    }

    public void setSelection(ISelection selection) {
        this.setEnabled(MindMapUtils.isSingleTopic((ISelection)selection) && !MindMapUtils.hasCentralTopic((ISelection)selection, (IViewer)this.getViewer()) && !MindMapUtils.hasSummary((ISelection)selection, (IViewer)this.getViewer()));
        if (MindMapUtils.isSingleTopic((ISelection)selection)) {
            this.setEnabled(!MindMapUtils.hasCentralTopic((ISelection)selection, (IViewer)this.getViewer()) && !MindMapUtils.hasSummary((ISelection)selection, (IViewer)this.getViewer()));
        } else if (MindMapUtils.isAllSuchElements((ISelection)selection, (String)"org.xmind.ui.topic")) {
            List<ITopic> topics = this.getAllTopics(selection);
            if (topics == null || topics.size() == 0 || this.containsCentralTopic(topics) || this.containsSummaryTopic(topics)) {
                this.setEnabled(false);
            } else {
                this.setEnabled(this.isAllBrothers(MindMapUtils.filterOutDescendents(topics, null)));
            }
        }
    }

    private List<ITopic> getAllTopics(ISelection selection) {
        List topics = MindMapUtils.getAllSuchElements((ISelection)selection, (String)"org.xmind.ui.topic");
        if (topics == null) {
            return null;
        }
        ArrayList<ITopic> list = new ArrayList<ITopic>();
        Collections.addAll(list, topics.toArray(new ITopic[0]));
        return list;
    }

    private boolean isAllBrothers(List<ITopic> topics) {
        if (topics == null || topics.size() == 0) {
            return false;
        }
        if (topics.size() == 1) {
            return true;
        }
        int i = 0;
        while (i < topics.size() - 1) {
            if (!this.isBrothers(topics.get(i), topics.get(i + 1))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isBrothers(ITopic t1, ITopic t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        return t1.getParent() == t2.getParent();
    }

    public boolean containsCentralTopic(List<ITopic> topics) {
        if (topics == null || topics.size() == 0) {
            return false;
        }
        for (ITopic t : topics) {
            if (!this.isCentralTopic(t)) continue;
            return true;
        }
        return false;
    }

    public boolean isCentralTopic(ITopic topic) {
        if (topic == null) {
            return false;
        }
        return topic.getOwnedSheet().getRootTopic() == topic;
    }

    private boolean containsSummaryTopic(List<ITopic> topics) {
        if (topics == null || topics.isEmpty()) {
            return false;
        }
        for (ITopic t : topics) {
            if (!this.isSummary(t)) continue;
            return true;
        }
        return false;
    }

    private boolean isSummary(ITopic topic) {
        if (topic == null) {
            return false;
        }
        return "summary".equals(topic.getType());
    }
}

